/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc.io;

import ibis.io.Conversion;
import ibis.io.DataOutputStream;
import ibis.ipl.impl.stacking.lrmc.io.LrmcOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class BufferedArrayOutputStream
extends DataOutputStream {
    private static final int SIZEOF_CHAR = 2;
    private static final int SIZEOF_SHORT = 2;
    private static final int SIZEOF_INT = 4;
    private static final int SIZEOF_LONG = 8;
    private static final int SIZEOF_FLOAT = 4;
    private static final int SIZEOF_DOUBLE = 8;
    private static boolean DEBUG = false;
    private LrmcOutputStream out;
    private byte[] buffer;
    private int index = 0;
    private long bytes = 0L;
    private Conversion conversion;
    private final int BUF_SIZE;

    public BufferedArrayOutputStream(LrmcOutputStream out, int bufsz) {
        this.out = out;
        this.buffer = out.getBuffer();
        this.BUF_SIZE = bufsz;
        this.conversion = Conversion.loadConversion((boolean)false);
    }

    public int bufferSize() {
        return this.BUF_SIZE;
    }

    public long bytesWritten() {
        return this.bytes + (long)this.index;
    }

    public void resetBytesWritten() {
        this.bytes = this.index;
    }

    private void flush(int incr, boolean forced) throws IOException {
        if (DEBUG) {
            System.err.println("flush(" + incr + ") : " + " " + (this.index + incr >= this.BUF_SIZE) + " " + this.index + " " + forced + ")");
        }
        if (forced || this.index + incr > this.BUF_SIZE) {
            this.bytes += (long)this.index;
            this.buffer = this.out.write(0, this.index, forced);
            this.index = 0;
        }
    }

    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    public void writeBoolean(boolean value) throws IOException {
        byte b = this.conversion.boolean2byte(value);
        this.flush(1, false);
        this.buffer[this.index++] = b;
    }

    public void writeByte(byte value) throws IOException {
        this.flush(1, false);
        this.buffer[this.index++] = value;
    }

    public void writeChar(char value) throws IOException {
        this.flush(2, false);
        this.conversion.char2byte(value, this.buffer, this.index);
        this.index += 2;
    }

    public void writeShort(short value) throws IOException {
        this.flush(2, false);
        this.conversion.short2byte(value, this.buffer, this.index);
        this.index += 2;
    }

    public void writeInt(int value) throws IOException {
        this.flush(4, false);
        this.conversion.int2byte(value, this.buffer, this.index);
        this.index += 4;
    }

    public void writeLong(long value) throws IOException {
        this.flush(8, false);
        this.conversion.long2byte(value, this.buffer, this.index);
        this.index += 8;
    }

    public void writeFloat(float value) throws IOException {
        this.flush(4, false);
        this.conversion.float2byte(value, this.buffer, this.index);
        this.index += 4;
    }

    public void writeDouble(double value) throws IOException {
        this.flush(8, false);
        this.conversion.double2byte(value, this.buffer, this.index);
        this.index += 8;
    }

    public void write(byte[] b) throws IOException {
        this.writeArray(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.writeArray(b, off, len);
    }

    public void writeArray(boolean[] ref, int off, int len) throws IOException {
        int size;
        if (DEBUG) {
            System.err.println("writeArray(boolean[" + off + " ... " + (off + len) + "])");
        }
        do {
            this.flush(1, false);
            size = Math.min(this.BUF_SIZE - this.index, len);
            this.conversion.boolean2byte(ref, off, size, this.buffer, this.index);
            off += size;
            this.index += size;
        } while ((len -= size) != 0);
    }

    public void writeArray(byte[] ref, int off, int len) throws IOException {
        if (DEBUG) {
            System.err.println("writeArray(byte[" + off + " ... " + (off + len) + "])");
        }
        while (len > this.BUF_SIZE - this.index) {
            int space = this.BUF_SIZE - this.index;
            System.arraycopy(ref, off, this.buffer, this.index, space);
            this.index += space;
            len -= space;
            off += space;
            this.flush(this.BUF_SIZE + 1, false);
        }
        if (len > 0) {
            System.arraycopy(ref, off, this.buffer, this.index, len);
            this.index += len;
        }
    }

    public void writeArray(char[] ref, int off, int len) throws IOException {
        int size;
        if (DEBUG) {
            System.err.println("writeArray(char[" + off + " ... " + (off + len) + "])");
        }
        do {
            this.flush(2, false);
            size = Math.min((this.BUF_SIZE - this.index) / 2, len);
            this.conversion.char2byte(ref, off, size, this.buffer, this.index);
            off += size;
            this.index += size * 2;
        } while ((len -= size) != 0);
    }

    public void writeArray(short[] ref, int off, int len) throws IOException {
        int size;
        if (DEBUG) {
            System.err.println("writeArray(short[" + off + " ... " + (off + len) + "])");
        }
        do {
            this.flush(2, false);
            size = Math.min((this.BUF_SIZE - this.index) / 2, len);
            this.conversion.short2byte(ref, off, size, this.buffer, this.index);
            off += size;
            this.index += size * 2;
        } while ((len -= size) != 0);
    }

    public void writeArray(int[] ref, int off, int len) throws IOException {
        int size;
        if (DEBUG) {
            System.err.println("writeArray(int[" + off + " ... " + (off + len) + "])");
        }
        do {
            this.flush(4, false);
            size = Math.min((this.BUF_SIZE - this.index) / 4, len);
            this.conversion.int2byte(ref, off, size, this.buffer, this.index);
            off += size;
            this.index += size * 4;
        } while ((len -= size) != 0);
    }

    public void writeArray(long[] ref, int off, int len) throws IOException {
        int size;
        if (DEBUG) {
            System.err.println("writeArray(long[" + off + " ... " + (off + len) + "])");
        }
        do {
            this.flush(8, false);
            size = Math.min((this.BUF_SIZE - this.index) / 8, len);
            this.conversion.long2byte(ref, off, size, this.buffer, this.index);
            off += size;
            this.index += size * 8;
        } while ((len -= size) != 0);
    }

    public void writeArray(float[] ref, int off, int len) throws IOException {
        int size;
        if (DEBUG) {
            System.err.println("writeArray(float[" + off + " ... " + (off + len) + "])");
        }
        do {
            this.flush(4, false);
            size = Math.min((this.BUF_SIZE - this.index) / 4, len);
            this.conversion.float2byte(ref, off, size, this.buffer, this.index);
            off += size;
            this.index += size * 4;
        } while ((len -= size) != 0);
    }

    public void writeArray(double[] ref, int off, int len) throws IOException {
        int size;
        if (DEBUG) {
            System.err.println("writeArray(double[" + off + " ... " + (off + len) + "])");
        }
        do {
            this.flush(8, false);
            size = Math.min((this.BUF_SIZE - this.index) / 8, len);
            this.conversion.double2byte(ref, off, size, this.buffer, this.index);
            off += size;
            this.index += size * 8;
        } while ((len -= size) != 0);
    }

    public void flush() throws IOException {
    }

    public void forcedFlush() throws IOException {
        this.flush(this.BUF_SIZE + 1, true);
        this.out.flush();
    }

    public void finish() {
    }

    public boolean finished() {
        return true;
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public void writeByteBuffer(ByteBuffer value) throws IOException {
        int len;
        int space;
        for (len = value.limit() - value.position(); len > this.BUF_SIZE - this.index; len -= space) {
            space = this.BUF_SIZE - this.index;
            value.get(this.buffer, this.index, space);
            this.index += space;
            this.flush(this.BUF_SIZE + 1, false);
        }
        if (len > 0) {
            value.get(this.buffer, this.index, len);
            this.index += len;
        }
    }
}

