/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import nl.esciencecenter.xenon.XenonRuntimeException;
import nl.esciencecenter.xenon.schedulers.JobDescription;

public class JavaJobDescription
extends JobDescription {
    private final List<String> javaOptions = new ArrayList<String>();
    private final Map<String, String> javaSystemProperties = new HashMap<String, String>();
    private String javaMain = null;
    private final List<String> javaArguments = new ArrayList<String>();
    private final List<String> javaClasspath = new ArrayList<String>();

    public List<String> getJavaOptions() {
        return this.javaOptions;
    }

    public void setJavaOptions(String ... options) {
        this.javaOptions.clear();
        for (String option : options) {
            this.addJavaOption(option);
        }
    }

    public void addJavaOption(String option) {
        if (option == null || option.length() == 0) {
            throw new IllegalArgumentException("Option may not be null or empty!");
        }
        this.javaOptions.add(option);
    }

    public Map<String, String> getJavaSystemProperties() {
        return this.javaSystemProperties;
    }

    public void setJavaSystemProperties(Map<String, String> systemProperties) {
        this.javaSystemProperties.clear();
        this.javaSystemProperties.putAll(systemProperties);
    }

    public void addJavaSystemProperty(String key, String value) {
        this.javaSystemProperties.put(key, value);
    }

    public String getJavaMain() {
        return this.javaMain;
    }

    public void setJavaMain(String main) {
        this.javaMain = main;
    }

    public List<String> getJavaArguments() {
        return this.javaArguments;
    }

    public void setJavaArguments(String ... javaArguments) {
        this.javaArguments.clear();
        this.javaArguments.addAll(Arrays.asList(javaArguments));
    }

    public void addJavaArgument(String javaArgument) {
        if (javaArgument == null || javaArgument.length() == 0) {
            throw new IllegalArgumentException("javaArgument may not be null or empty!");
        }
        this.javaArguments.add(javaArgument);
    }

    @Override
    public void setArguments(String ... arguments) {
        throw new XenonRuntimeException("Utils", "Setting arguments not supported by the JavaJobDescription");
    }

    @Override
    public List<String> getArguments() {
        return this.getArguments(File.pathSeparatorChar);
    }

    public List<String> getArguments(char pathSeparator) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getJavaOptions());
        if (!this.getJavaClasspath().isEmpty()) {
            result.add("-classpath");
            String classpath = null;
            for (String string : this.getJavaClasspath()) {
                if (classpath == null) {
                    classpath = string;
                    continue;
                }
                classpath = classpath + pathSeparator + string;
            }
            result.add(classpath);
        }
        Map<String, String> properties = this.getJavaSystemProperties();
        for (Map.Entry entry : properties.entrySet()) {
            result.add("-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        if (this.getJavaMain() != null) {
            result.add(this.getJavaMain());
        }
        result.addAll(this.getJavaArguments());
        return result;
    }

    @Override
    public String getExecutable() {
        if (super.getExecutable() == null) {
            return "java";
        }
        return super.getExecutable();
    }

    public List<String> getJavaClasspath() {
        return this.javaClasspath;
    }

    public void setJavaClasspath(String ... javaClasspath) {
        this.javaClasspath.clear();
        for (String element : javaClasspath) {
            this.addJavaClasspathElement(element);
        }
    }

    public void addJavaClasspathElement(String element) {
        if (element == null || element.length() == 0) {
            throw new IllegalArgumentException("java classpath element may not be null or empty!");
        }
        this.javaClasspath.add(element);
    }

    @Override
    public String toString() {
        return "JavaJobDescription [javaOptions=" + this.javaOptions + ", javaSystemProperties=" + this.javaSystemProperties + ", javaMain=" + this.javaMain + ", javaArguments=" + this.javaArguments + ", javaClassPath=" + this.javaClasspath + ", queueName=" + this.getQueueName() + ", executable=" + this.getExecutable() + ", stdin=" + this.getStdin() + ", stdout=" + this.getStdout() + ", stderr=" + this.getStderr() + ", workingDirectory=" + this.getWorkingDirectory() + ", environment=" + this.getEnvironment() + ", jobOptions=" + this.getJobOptions() + ", nodeCount=" + this.getNodeCount() + ", processesPerNode=" + this.getProcessesPerNode() + ", maxTime=" + this.getMaxRuntime() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.javaArguments.hashCode();
        result = 31 * result + this.javaClasspath.hashCode();
        result = 31 * result + (this.javaMain == null ? 0 : this.javaMain.hashCode());
        result = 31 * result + this.javaOptions.hashCode();
        result = 31 * result + this.javaSystemProperties.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JavaJobDescription other = (JavaJobDescription)obj;
        return super.equals(obj) && this.javaArguments.equals(other.javaArguments) && this.javaClasspath.equals(other.javaClasspath) && Objects.equals(this.javaMain, other.javaMain) && this.javaOptions.equals(other.javaOptions) && this.javaSystemProperties.equals(other.javaSystemProperties);
    }
}

