/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.filesystems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Path
implements Iterable<Path> {
    public static final char DEFAULT_SEPARATOR = '/';
    private final List<String> elements;
    private final char separator;
    private boolean isAbsolute;
    private static final int PATH_ELEMENT_LENGTH = 25;

    public Path() {
        this('/', false, new ArrayList<String>(0));
    }

    public Path(String path) {
        this('/', path);
    }

    public Path(char separator, String path) {
        this.separator = separator;
        if (path == null || path.isEmpty()) {
            this.isAbsolute = false;
            this.elements = new ArrayList<String>(0);
        } else {
            this.isAbsolute = path.indexOf(separator) == 0;
            StringTokenizer tok = new StringTokenizer(path, "" + separator);
            this.elements = new ArrayList<String>(tok.countTokens());
            while (tok.hasMoreTokens()) {
                this.elements.add(tok.nextToken());
            }
        }
    }

    public Path(boolean isAbsolute, String ... elements) {
        this(isAbsolute, (List<String>)(elements == null ? new ArrayList(0) : Arrays.asList(elements)));
    }

    public Path(char separator, boolean isAbsolute, String ... elements) {
        this(separator, isAbsolute, (List<String>)(elements == null ? new ArrayList(0) : Arrays.asList(elements)));
    }

    public Path(boolean isAbsolute, List<String> elements) {
        this('/', isAbsolute, elements);
    }

    public Path(char separator, boolean isAbsolute, List<String> elements) {
        this.separator = separator;
        this.isAbsolute = isAbsolute;
        this.elements = Path.checkForNullAndSeparator(separator, elements);
    }

    protected static List<String> checkForNullAndSeparator(char separator, List<String> elements) {
        ArrayList<String> result = new ArrayList<String>(0);
        if (elements == null || elements.isEmpty()) {
            return result;
        }
        for (String s : elements) {
            if (s == null) {
                throw new IllegalArgumentException("Path elements list contains null");
            }
            if (s.isEmpty()) {
                throw new IllegalArgumentException("Path elements list contains an empty element");
            }
            if (s.indexOf(separator) != -1) {
                throw new IllegalArgumentException("Path element " + s + " contains separator '" + separator + "'");
            }
            result.add(s);
        }
        return result;
    }

    public Path getFileName() {
        if (this.isEmpty()) {
            return null;
        }
        return new Path(this.separator, this.getFileNameAsString());
    }

    public String getFileNameAsString() {
        if (this.isEmpty()) {
            return null;
        }
        return this.elements.get(this.elements.size() - 1);
    }

    public char getSeparator() {
        return this.separator;
    }

    public Path getParent() {
        if (this.isEmpty() || this.elements.size() == 1) {
            return null;
        }
        return new Path(this.separator, this.isAbsolute, this.elements.subList(0, this.elements.size() - 1));
    }

    public int getNameCount() {
        return this.elements.size();
    }

    public Path getName(int index) {
        boolean alsoAbsolute = index == 0 && this.isAbsolute;
        return new Path(this.separator, alsoAbsolute, Collections.singletonList(this.elements.get(index)));
    }

    public Path subpath(int beginIndex, int endIndex) {
        if (beginIndex == endIndex) {
            throw new IllegalArgumentException("beginIndex " + beginIndex + " equal to endIndex " + endIndex);
        }
        boolean alsoAbsolute = beginIndex == 0 && this.isAbsolute;
        return new Path(this.separator, alsoAbsolute, this.elements.subList(beginIndex, endIndex));
    }

    public boolean startsWith(Path other) {
        return other.isAbsolute == this.isAbsolute && other.elements.size() <= this.elements.size() && this.elements.subList(0, other.elements.size()).equals(other.elements);
    }

    public boolean endsWith(Path other) {
        if (other.isAbsolute) {
            return this.equals(other);
        }
        int offset = this.elements.size() - other.elements.size();
        return other.elements.size() <= this.elements.size() && this.elements.subList(offset, this.elements.size()).equals(other.elements);
    }

    public boolean startsWith(String other) {
        return this.startsWith(new Path(this.separator, other));
    }

    public boolean endsWith(String other) {
        return this.endsWith(new Path(this.separator, other));
    }

    public Path resolve(Path other) {
        if (other == null || other.isEmpty()) {
            return this;
        }
        ArrayList<String> tmp = new ArrayList<String>(this.elements.size() + other.elements.size());
        tmp.addAll(this.elements);
        tmp.addAll(other.elements);
        return new Path(this.separator, this.isAbsolute, tmp);
    }

    public Path resolve(String other) {
        if (other == null || other.isEmpty()) {
            return this;
        }
        return this.resolve(new Path(this.separator, other));
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public Path resolveSibling(Path other) {
        if (this.isEmpty()) {
            if (other == null) {
                return this;
            }
            return other;
        }
        return this.getParent().resolve(other);
    }

    public Path relativize(Path other) {
        if (this.isEmpty()) {
            return other;
        }
        List<String> normalized = this.normalize().elements;
        List<String> normalizedOther = other.normalize().elements;
        if (normalized.size() > normalizedOther.size()) {
            throw new IllegalArgumentException("Cannot relativize " + other + " to " + this);
        }
        if (!normalizedOther.subList(0, normalized.size()).equals(normalized)) {
            throw new IllegalArgumentException("Cannot relativize " + other + " to " + this);
        }
        return new Path(this.separator, false, normalizedOther.subList(normalized.size(), normalizedOther.size()));
    }

    @Override
    public Iterator<Path> iterator() {
        return new PathIterator();
    }

    private String getRelativePath() {
        StringBuilder tmp = new StringBuilder(this.elements.size() * 25);
        String sep = "";
        for (String element : this.elements) {
            tmp.append(sep);
            tmp.append(element);
            sep = String.valueOf(this.separator);
        }
        return tmp.toString();
    }

    private String getAbsolutePath() {
        return this.separator + this.getRelativePath();
    }

    public Path normalize() {
        if (this.isEmpty()) {
            return this;
        }
        ArrayList<String> stack = new ArrayList<String>(this.elements);
        boolean change = true;
        while (change) {
            change = false;
            for (int i = stack.size() - 1; i >= 0; --i) {
                String parent;
                if (i >= stack.size()) continue;
                String elt = stack.get(i);
                if (".".equals(elt)) {
                    stack.remove(i);
                    change = true;
                    continue;
                }
                if (i <= 0 || !"..".equals(elt) || ".".equals(parent = stack.get(i - 1)) || "..".equals(parent)) continue;
                stack.subList(i - 1, i + 1).clear();
                change = true;
            }
        }
        return new Path(this.separator, this.isAbsolute, stack);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.elements.hashCode();
        result = 31 * result + this.separator;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return this.isAbsolute == other.isAbsolute && this.separator == other.separator && this.elements.equals(other.elements);
    }

    public String toString() {
        if (this.isAbsolute) {
            return this.getAbsolutePath();
        }
        return this.getRelativePath();
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public Path toRelativePath() {
        return new Path(this.separator, false, this.elements);
    }

    public Path toAbsolutePath() {
        return new Path(this.separator, true, this.elements);
    }

    private class PathIterator
    implements Iterator<Path> {
        private int index = 1;

        private PathIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index <= Path.this.elements.size();
        }

        @Override
        public Path next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available!");
            }
            return Path.this.subpath(0, this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported!");
        }
    }
}

