/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.local;

import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.InteractiveProcess;
import nl.esciencecenter.xenon.adaptors.schedulers.InteractiveProcessFactory;
import nl.esciencecenter.xenon.adaptors.schedulers.SchedulerClosedException;
import nl.esciencecenter.xenon.adaptors.schedulers.local.LocalInteractiveProcess;
import nl.esciencecenter.xenon.schedulers.JobDescription;

public class LocalInteractiveProcessFactory
implements InteractiveProcessFactory {
    private boolean open = true;

    @Override
    public synchronized InteractiveProcess createInteractiveProcess(JobDescription description, String jobIdentifier, long timeoutInMillis) throws XenonException {
        if (!this.open) {
            throw new SchedulerClosedException("local", "Scheduler is closed");
        }
        return new LocalInteractiveProcess(description, jobIdentifier);
    }

    @Override
    public synchronized void close() throws XenonException {
        if (!this.open) {
            throw new SchedulerClosedException("local", "Scheduler already closed");
        }
        this.open = false;
    }

    @Override
    public synchronized boolean isOpen() throws XenonException {
        return this.open;
    }
}

