/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.filesystems.jclouds;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import nl.esciencecenter.xenon.UnsupportedOperationException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.NotConnectedException;
import nl.esciencecenter.xenon.adaptors.XenonProperties;
import nl.esciencecenter.xenon.adaptors.filesystems.PathAttributesImplementation;
import nl.esciencecenter.xenon.filesystems.AttributeNotSupportedException;
import nl.esciencecenter.xenon.filesystems.FileSystem;
import nl.esciencecenter.xenon.filesystems.InvalidPathException;
import nl.esciencecenter.xenon.filesystems.NoSuchPathException;
import nl.esciencecenter.xenon.filesystems.Path;
import nl.esciencecenter.xenon.filesystems.PathAttributes;
import nl.esciencecenter.xenon.filesystems.PosixFilePermission;
import org.apache.sshd.common.util.io.NullInputStream;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;

public class JCloudsFileSytem
extends FileSystem {
    private static final String NOT_EMPTY = "___not__empty___";
    final String bucket;
    final BlobStoreContext context;
    final String adaptorName;
    boolean open;

    public JCloudsFileSytem(String uniqueID, String adaptorName, String endPoint, Path workingDir, BlobStoreContext context, String bucket, int bufferSize, XenonProperties properties) {
        super(uniqueID, adaptorName, endPoint, workingDir, bufferSize, properties);
        this.context = context;
        this.bucket = bucket;
        this.adaptorName = adaptorName;
        this.open = true;
    }

    String toBucketEntry(Path path) {
        this.assertNotNull(path);
        if (path.isAbsolute()) {
            return path.toRelativePath().toString();
        }
        return path.toString();
    }

    @Override
    public void close() throws XenonException {
        this.checkClosed();
        this.context.close();
        this.open = false;
    }

    @Override
    public boolean isOpen() throws XenonException {
        return this.open;
    }

    @Override
    public void rename(Path source, Path target) throws XenonException {
        throw new UnsupportedOperationException(this.adaptorName, "This adaptor does not support renaming.");
    }

    void checkClosed() throws XenonException {
        if (!this.isOpen()) {
            throw new NotConnectedException(this.getAdaptorName(), "Already closed file system!");
        }
    }

    @Override
    public void createDirectory(Path dir) throws XenonException {
        this.checkClosed();
        Path absDir = this.toAbsolutePath(dir);
        this.assertPathNotExists(absDir);
        this.assertParentDirectoryExists(absDir);
        this.makeDirectoryPlaceholder(absDir);
    }

    private void makeDirectoryPlaceholder(Path dir) {
        Blob b = this.context.getBlobStore().blobBuilder(this.bucket).name(this.toBucketEntry(dir) + "/" + NOT_EMPTY).payload((InputStream)new ByteArrayInputStream(new byte[0])).contentLength(0L).build();
        this.context.getBlobStore().putBlob(this.bucket, b);
    }

    private void removeDirectoryPlaceholder(Path dir) {
        if (dir == null) {
            return;
        }
        String existsFile = this.toBucketEntry(dir) + "/" + NOT_EMPTY;
        if (this.context.getBlobStore().blobExists(this.bucket, existsFile)) {
            this.context.getBlobStore().removeBlob(this.bucket, existsFile);
        }
    }

    @Override
    public void createFile(Path file) throws XenonException {
        this.checkClosed();
        Path absFile = this.toAbsolutePath(file);
        this.assertPathNotExists(absFile);
        this.assertParentDirectoryExists(absFile);
        this.removeDirectoryPlaceholder(absFile.getParent());
        NullInputStream emtpy = new NullInputStream();
        Blob b = this.context.getBlobStore().blobBuilder(this.bucket).name(this.toBucketEntry(absFile)).payload((InputStream)emtpy).contentLength(0L).build();
        this.context.getBlobStore().putBlob(this.bucket, b);
    }

    @Override
    public void createSymbolicLink(Path link, Path target) throws XenonException {
        throw new AttributeNotSupportedException(this.adaptorName, "Symbolic link  not supported by " + this.adaptorName);
    }

    private void ensureDirectoryExists(Path dir) {
        if (!this.dirExists(dir)) {
            this.makeDirectoryPlaceholder(dir);
        }
    }

    @Override
    public void deleteFile(Path file) throws XenonException {
        this.checkClosed();
        Path absFile = this.toAbsolutePath(file);
        this.context.getBlobStore().removeBlob(this.bucket, this.toBucketEntry(absFile));
        Path parent = absFile.getParent();
        if (parent != null && !parent.isEmpty()) {
            this.ensureDirectoryExists(absFile.getParent());
        }
    }

    @Override
    protected void deleteDirectory(Path dir) throws XenonException {
        this.checkClosed();
        if (!this.dirExists(dir)) {
            throw new NoSuchPathException(this.adaptorName, "Directory does not exist: " + dir);
        }
        this.removeDirectoryPlaceholder(dir);
    }

    @Override
    protected Iterable<PathAttributes> listDirectory(Path dir) throws XenonException {
        return this.list(dir, false);
    }

    private boolean dirExists(Path path) {
        ListContainerOptions options = new ListContainerOptions().prefix(this.toBucketEntry(path) + "/");
        return this.context.getBlobStore().list(this.bucket, options).iterator().hasNext();
    }

    private boolean fileExists(Path path) {
        return this.context.getBlobStore().blobExists(this.bucket, this.toBucketEntry(path));
    }

    @Override
    public boolean exists(Path path) throws XenonException {
        this.checkClosed();
        Path absPath = this.toAbsolutePath(path);
        return this.dirExists(absPath) || this.fileExists(absPath);
    }

    PathAttributes makeDirAttributes(StorageMetadata m, BlobAccess access) {
        Date d;
        PathAttributesImplementation pa = new PathAttributesImplementation();
        pa.setPath(new Path("/" + m.getName()));
        if (m.getSize() != null) {
            pa.setSize(m.getSize());
        }
        if ((d = m.getLastModified()) != null) {
            pa.setLastModifiedTime(d.getTime());
        } else {
            pa.setLastModifiedTime(0L);
        }
        d = m.getCreationDate();
        if (d != null) {
            pa.setCreationTime(d.getTime());
        } else {
            pa.setCreationTime(pa.getCreationTime());
        }
        pa.setLastAccessTime(pa.getLastModifiedTime());
        pa.setDirectory(true);
        pa.setReadable(true);
        pa.setWritable(true);
        return pa;
    }

    private PathAttributes makeBlobAttributes(String name) {
        BlobMetadata md = this.context.getBlobStore().blobMetadata(this.bucket, name);
        PathAttributesImplementation pa = new PathAttributesImplementation();
        pa.setPath(new Path("/" + name));
        pa.setLastAccessTime(md.getLastModified().getTime());
        pa.setSize(md.getSize());
        pa.setRegular(true);
        if (md.getCreationDate() == null) {
            pa.setCreationTime(pa.getLastModifiedTime());
        } else {
            pa.setCreationTime(md.getCreationDate().getTime());
        }
        pa.setLastAccessTime(md.getLastModified().getTime());
        pa.setDirectory(false);
        pa.setReadable(true);
        return pa;
    }

    PathAttributes toPathAttributes(StorageMetadata m, BlobAccess access) {
        switch (m.getType()) {
            case RELATIVE_PATH: {
                return this.makeDirAttributes(m, access);
            }
            case BLOB: {
                return this.makeBlobAttributes(m.getName());
            }
        }
        throw new RuntimeException("Unknow file type" + m.getType());
    }

    Iterator<PathAttributes> listNonRecursiveIterator(String bucketEntry) {
        ListContainerOptions options;
        ListContainerOptions optionsFinal = options = new ListContainerOptions().prefix(bucketEntry + "/");
        return new ListingIterator(optionsFinal, (PageSet<? extends StorageMetadata>)this.context.getBlobStore().list(this.bucket, optionsFinal));
    }

    @Override
    public Iterable<PathAttributes> list(Path path, boolean recursive) throws XenonException {
        this.checkClosed();
        Path dir = this.toAbsolutePath(path);
        this.assertPathIsDirectory(dir);
        final String bucketEntry = this.toBucketEntry(dir);
        ListContainerOptions options = new ListContainerOptions().prefix(bucketEntry + "/");
        PageSet ps = this.context.getBlobStore().list(this.bucket, options);
        Iterator curIt = ps.iterator();
        if (!curIt.hasNext()) {
            if (this.context.getBlobStore().blobExists(this.bucket, bucketEntry)) {
                throw new InvalidPathException(this.getAdaptorName(), "Not a directory: " + dir);
            }
            throw new NoSuchPathException(this.adaptorName, "No such directory: " + dir);
        }
        if (!recursive) {
            return new Iterable<PathAttributes>(){

                @Override
                public Iterator<PathAttributes> iterator() {
                    return JCloudsFileSytem.this.listNonRecursiveIterator(bucketEntry);
                }
            };
        }
        return new Iterable<PathAttributes>(){

            @Override
            public Iterator<PathAttributes> iterator() {
                return new RecursiveListIterator(JCloudsFileSytem.this.listNonRecursiveIterator(bucketEntry));
            }
        };
    }

    private Iterable<PathAttributes> listPrefix(String prefix, boolean recursive) {
        ListContainerOptions options = new ListContainerOptions().prefix(prefix);
        if (recursive) {
            options = options.recursive();
        }
        final ListContainerOptions optionsFinal = options;
        return new Iterable<PathAttributes>(){

            @Override
            public Iterator<PathAttributes> iterator() {
                return new ListingIterator(optionsFinal, (PageSet<? extends StorageMetadata>)JCloudsFileSytem.this.context.getBlobStore().list(JCloudsFileSytem.this.bucket, optionsFinal));
            }
        };
    }

    @Override
    public InputStream readFromFile(Path path) throws XenonException {
        Path absPath = this.toAbsolutePath(path);
        this.assertPathIsFile(absPath);
        try {
            return this.context.getBlobStore().getBlob(this.bucket, this.toBucketEntry(absPath)).getPayload().openStream();
        }
        catch (IOException e) {
            throw new XenonException(this.adaptorName, e.getMessage());
        }
    }

    @Override
    public OutputStream writeToFile(Path path, long size) throws XenonException {
        Path absPath = this.toAbsolutePath(path);
        this.assertPathNotExists(absPath);
        PipedInputStream read = new PipedInputStream();
        final Blob b = this.context.getBlobStore().blobBuilder(this.bucket).name(this.toBucketEntry(absPath)).payload((InputStream)read).contentLength(size).build();
        try {
            PipedOutputStream out = new PipedOutputStream(read);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JCloudsFileSytem.this.context.getBlobStore().putBlob(JCloudsFileSytem.this.bucket, b);
                }
            }).start();
            return out;
        }
        catch (IOException e) {
            throw new XenonException(this.adaptorName, "IO error when trying to write: " + e.getMessage());
        }
    }

    @Override
    public OutputStream writeToFile(Path file) throws XenonException {
        throw new UnsupportedOperationException(this.adaptorName, "WriteToFile without predefined size not supported");
    }

    @Override
    public OutputStream appendToFile(Path file) throws XenonException {
        throw new UnsupportedOperationException(this.adaptorName, "Append not supported");
    }

    @Override
    public PathAttributes getAttributes(Path path) throws XenonException {
        Path absPath = this.toAbsolutePath(path);
        String name = this.toBucketEntry(absPath);
        for (PathAttributes p : this.listPrefix(name, false)) {
            if (!p.getPath().equals(absPath)) continue;
            return p;
        }
        throw new NoSuchPathException(this.adaptorName, "File does not exist: " + absPath);
    }

    @Override
    public Path readSymbolicLink(Path link) throws XenonException {
        throw new AttributeNotSupportedException(this.adaptorName, "Symbolic link  not supported by " + this.adaptorName);
    }

    @Override
    public void setPosixFilePermissions(Path path, Set<PosixFilePermission> permissions) throws XenonException {
        throw new UnsupportedOperationException(this.getAdaptorName(), "POSIX permissions not supported");
    }

    private class RecursiveListIterator
    implements Iterator<PathAttributes> {
        final Stack<Iterator<PathAttributes>> stack = new Stack();

        public RecursiveListIterator(Iterator<PathAttributes> root) {
            this.stack.push(root);
        }

        void popEmpties() {
            while (!this.stack.empty()) {
                if (!this.stack.peek().hasNext()) {
                    this.stack.pop();
                    continue;
                }
                return;
            }
        }

        @Override
        public boolean hasNext() {
            this.popEmpties();
            return !this.stack.isEmpty();
        }

        @Override
        public PathAttributes next() {
            PathAttributes nxt = this.stack.peek().next();
            if (nxt.isDirectory()) {
                this.stack.push(JCloudsFileSytem.this.listNonRecursiveIterator(JCloudsFileSytem.this.toBucketEntry(nxt.getPath())));
            }
            this.popEmpties();
            return nxt;
        }
    }

    class ListingIterator
    implements Iterator<PathAttributes> {
        private final ListContainerOptions options;
        Iterator<? extends StorageMetadata> curIterator;
        PageSet<? extends StorageMetadata> curPageSet;
        StorageMetadata nxt;

        ListingIterator(ListContainerOptions options, PageSet<? extends StorageMetadata> pageSet) {
            this.options = options;
            this.curPageSet = pageSet;
            this.curIterator = this.curPageSet.iterator();
            this.getNext();
        }

        void getNext() {
            if (!this.curIterator.hasNext() && this.curPageSet.getNextMarker() != null) {
                this.curPageSet = JCloudsFileSytem.this.context.getBlobStore().list(JCloudsFileSytem.this.bucket, this.options.afterMarker(this.curPageSet.getNextMarker()));
                this.curIterator = this.curPageSet.iterator();
            }
            this.nxt = this.curIterator.hasNext() ? this.curIterator.next() : null;
            if (this.nxt != null && this.nxt.getName().endsWith(JCloudsFileSytem.NOT_EMPTY)) {
                this.getNext();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nxt != null;
        }

        @Override
        public PathAttributes next() {
            BlobAccess access = BlobAccess.PUBLIC_READ;
            PathAttributes res = JCloudsFileSytem.this.toPathAttributes(this.nxt, access);
            this.getNext();
            return res;
        }
    }
}

