/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.GraphListener;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGPanel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class LocalityScroll
implements GraphListener {
    private Scrollbar localitySB;
    private TGPanel tgPanel;

    public LocalityScroll(TGPanel tgp) {
        this.tgPanel = tgp;
        this.localitySB = new Scrollbar(0, 1, 1, 0, 7);
        this.localitySB.setBlockIncrement(1);
        this.localitySB.setUnitIncrement(1);
        this.localitySB.addAdjustmentListener(new localityAdjustmentListener());
        this.tgPanel.addGraphListener(this);
    }

    public Scrollbar getLocalitySB() {
        return this.localitySB;
    }

    public int getLocalityRadius() {
        int locVal = this.localitySB.getValue();
        if (locVal >= 6) {
            return Integer.MAX_VALUE;
        }
        return locVal;
    }

    public void setLocalityRadius(int radius) {
        if (radius <= 0) {
            this.localitySB.setValue(0);
        } else if (radius <= 5) {
            this.localitySB.setValue(radius);
        } else {
            this.localitySB.setValue(6);
        }
    }

    public void graphMoved() {
    }

    public void graphReset() {
        this.localitySB.setValue(1);
    }

    private class localityAdjustmentListener
    implements AdjustmentListener {
        private localityAdjustmentListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            Node select = LocalityScroll.this.tgPanel.getSelect();
            if (select != null || LocalityScroll.this.getLocalityRadius() == Integer.MAX_VALUE) {
                try {
                    LocalityScroll.this.tgPanel.setLocale(select, LocalityScroll.this.getLocalityRadius());
                }
                catch (TGException ex) {
                    System.out.println("Error setting locale");
                    ex.printStackTrace();
                }
            }
        }
    }
}

