/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGPaintListener;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class DragAddUI
extends TGAbstractDragUI
implements TGPaintListener {
    Point mousePos = null;
    Node dragAddNode = null;

    public DragAddUI(TGPanel tgp) {
        super(tgp);
    }

    public void preActivate() {
        this.mousePos = null;
        this.tgPanel.addPaintListener(this);
    }

    public void preDeactivate() {
        this.tgPanel.removePaintListener(this);
    }

    public void mousePressed(MouseEvent e) {
        this.dragAddNode = this.tgPanel.getMouseOverN();
    }

    public void mouseReleased(MouseEvent e) {
        Node mouseOverN = this.tgPanel.getMouseOverN();
        if (mouseOverN != null && this.dragAddNode != null && mouseOverN != this.dragAddNode) {
            Edge ed = this.tgPanel.findEdge(this.dragAddNode, mouseOverN);
            if (ed == null) {
                this.tgPanel.addEdge(this.dragAddNode, mouseOverN, Edge.DEFAULT_LENGTH);
            } else {
                this.tgPanel.deleteEdge(ed);
            }
        } else if (mouseOverN == null && this.dragAddNode != null) {
            try {
                Node n = this.tgPanel.addNode();
                this.tgPanel.addEdge(this.dragAddNode, n, Edge.DEFAULT_LENGTH);
                n.drawx = this.tgPanel.getMousePos().x;
                n.drawy = this.tgPanel.getMousePos().y;
                this.tgPanel.updatePosFromDraw(n);
            }
            catch (TGException tge) {
                System.err.println(tge.getMessage());
                tge.printStackTrace(System.err);
            }
        }
        if (this.mouseWasDragged) {
            this.tgPanel.resetDamper();
            this.tgPanel.startDamper();
        }
        this.dragAddNode = null;
    }

    public void mouseDragged(MouseEvent e) {
        this.mousePos = e.getPoint();
        this.tgPanel.repaint();
    }

    public void paintFirst(Graphics g) {
    }

    public void paintLast(Graphics g) {
    }

    public void paintAfterEdges(Graphics g) {
        if (this.mousePos == null) {
            return;
        }
        Node mouseOverN = this.tgPanel.getMouseOverN();
        if (mouseOverN == null) {
            g.drawRect(this.mousePos.x - 7, this.mousePos.y - 7, 14, 14);
        }
        Color c = mouseOverN == this.dragAddNode ? Color.darkGray : Color.blue;
        Edge.paintArrow(g, (int)this.dragAddNode.drawx, (int)this.dragAddNode.drawy, this.mousePos.x, this.mousePos.y, c);
    }
}

