/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.suppliers;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ForwardingObject;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.suppliers.ValueLoadedCallback;
import org.jclouds.util.Throwables2;

public class MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<T>
extends ForwardingObject
implements Supplier<T> {
    private final Supplier<T> delegate;
    private final long duration;
    private final TimeUnit unit;
    private final LoadingCache<String, Optional<T>> cache;

    public static <T> MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<T> create(AtomicReference<AuthorizationException> authException, Supplier<T> delegate, long duration, TimeUnit unit) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<T>(authException, delegate, duration, unit, new ValueLoadedCallback.NoOpCallback());
    }

    public static <T> MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<T> create(AtomicReference<AuthorizationException> authException, Supplier<T> delegate, long duration, TimeUnit unit, ValueLoadedCallback<T> valueLoadedCallback) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<T>(authException, delegate, duration, unit, valueLoadedCallback);
    }

    MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(AtomicReference<AuthorizationException> authException, Supplier<T> delegate, long duration, TimeUnit unit, ValueLoadedCallback<T> valueLoadedCallback) {
        this.delegate = delegate;
        this.duration = duration;
        this.unit = unit;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(duration, unit).build(new SetAndThrowAuthorizationExceptionSupplierBackedLoader<T>(delegate, authException, valueLoadedCallback));
    }

    protected Supplier<T> delegate() {
        return this.delegate;
    }

    public T get() {
        try {
            return (T)((Optional)this.cache.get((Object)"FOO")).orNull();
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("delegate", this.delegate).add("duration", this.duration).add("unit", (Object)this.unit).toString();
    }

    public static class ValueLoadedEvent<V> {
        private final Object eventKey;
        private final Optional<V> value;

        public ValueLoadedEvent(Object eventKey, Optional<V> value) {
            this.eventKey = Preconditions.checkNotNull((Object)eventKey, (Object)"eventKey");
            this.value = (Optional)Preconditions.checkNotNull(value, (Object)"value");
        }

        public Object getEventKey() {
            return this.eventKey;
        }

        public Optional<V> getValue() {
            return this.value;
        }
    }

    static class SetAndThrowAuthorizationExceptionSupplierBackedLoader<V>
    extends CacheLoader<String, Optional<V>> {
        private final Supplier<V> delegate;
        private final AtomicReference<AuthorizationException> authException;
        private final ValueLoadedCallback<V> valueLoadedCallback;

        public SetAndThrowAuthorizationExceptionSupplierBackedLoader(Supplier<V> delegate, AtomicReference<AuthorizationException> authException, ValueLoadedCallback<V> valueLoadedCallback) {
            this.delegate = (Supplier)Preconditions.checkNotNull(delegate, (Object)"delegate");
            this.authException = (AtomicReference)Preconditions.checkNotNull(authException, (Object)"authException");
            this.valueLoadedCallback = (ValueLoadedCallback)Preconditions.checkNotNull(valueLoadedCallback, (Object)"valueLoadedCallback");
        }

        public Optional<V> load(String key) {
            if (this.authException.get() != null) {
                throw this.authException.get();
            }
            try {
                Optional value = Optional.fromNullable((Object)this.delegate.get());
                this.valueLoadedCallback.valueLoaded(value);
                return value;
            }
            catch (Exception e) {
                AuthorizationException aex = Throwables2.getFirstThrowableOfType(e, AuthorizationException.class);
                if (aex != null) {
                    this.authException.set(aex);
                    throw aex;
                }
                throw Throwables.propagate((Throwable)e);
            }
        }

        public String toString() {
            return Objects.toStringHelper((Object)((Object)this)).add("delegate", this.delegate).toString();
        }
    }
}

