/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.handlers;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.logging.Logger;

@Beta
public abstract class RateLimitRetryHandler
implements HttpRetryHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.max-retries")
    private int retryCountLimit = 5;
    @Inject(optional=true)
    @Named(value="jclouds.max-ratelimit-wait")
    private int maxRateLimitWait = 120000;

    protected int rateLimitErrorStatus() {
        return 429;
    }

    protected abstract Optional<Long> millisToNextAvailableRequest(HttpCommand var1, HttpResponse var2);

    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        command.incrementFailureCount();
        if (response.getStatusCode() != this.rateLimitErrorStatus()) {
            return false;
        }
        if (!command.isReplayable()) {
            this.logger.error("Cannot retry after rate limit error, command is not replayable: %1$s", command);
            return false;
        }
        if (command.getFailureCount() > this.retryCountLimit) {
            this.logger.error("Cannot retry after rate limit error, command has exceeded retry limit %1$d: %2$s", this.retryCountLimit, command);
            return false;
        }
        return this.delayRequestUntilAllowed(command, response);
    }

    private boolean delayRequestUntilAllowed(HttpCommand command, HttpResponse response) {
        Optional<Long> millisToNextAvailableRequest = this.millisToNextAvailableRequest(command, response);
        if (!millisToNextAvailableRequest.isPresent()) {
            this.logger.error("Cannot retry after rate limit error, no retry information provided in the response", new Object[0]);
            return false;
        }
        long waitPeriod = (Long)millisToNextAvailableRequest.get();
        if (waitPeriod > 0L) {
            if (waitPeriod > (long)this.maxRateLimitWait) {
                this.logger.error("Max wait for rate limited requests is %sms but need to wait %sms, aborting", this.maxRateLimitWait, waitPeriod);
                return false;
            }
            try {
                this.logger.debug("Waiting %sms before retrying, as defined by the rate limit", waitPeriod);
                Thread.sleep(waitPeriod);
            }
            catch (InterruptedException ex) {
                this.logger.error("Request execution was interrupted, aborting", new Object[0]);
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }

    public int getRetryCountLimit() {
        return this.retryCountLimit;
    }

    public int getMaxRateLimitWait() {
        return this.maxRateLimitWait;
    }
}

