/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl;

import ibis.ipl.IbisIdentifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public class SendPortIdentifier
implements ibis.ipl.SendPortIdentifier {
    private static final long serialVersionUID = 8169019358172536222L;
    public final String name;
    public final ibis.ipl.impl.IbisIdentifier ibis;

    public SendPortIdentifier(String name, ibis.ipl.impl.IbisIdentifier ibis) {
        if (name == null) {
            throw new NullPointerException("name is null in SendPortIdentifier");
        }
        if (ibis == null) {
            throw new NullPointerException("Ibis identifier is null in SendPortIdentifier");
        }
        this.name = name;
        this.ibis = ibis;
    }

    public SendPortIdentifier(byte[] codedForm) throws IOException {
        this(codedForm, 0, codedForm.length);
    }

    public SendPortIdentifier(byte[] codedForm, int offset, int length) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(codedForm, offset, length)));
    }

    public SendPortIdentifier(DataInput dis) throws IOException {
        this.name = dis.readUTF();
        this.ibis = new ibis.ipl.impl.IbisIdentifier(dis);
    }

    public byte[] toBytes() {
        return this.computeCodedForm();
    }

    private byte[] computeCodedForm() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeUTF(this.name);
            this.ibis.writeTo(dos);
            dos.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void writeTo(DataOutput dos) throws IOException {
        dos.write(this.computeCodedForm());
    }

    private boolean equals(SendPortIdentifier other) {
        if (other == this) {
            return true;
        }
        return this.name.equals(other.name) && this.ibis.equals(other.ibis);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof SendPortIdentifier) {
            return this.equals((SendPortIdentifier)other);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.ibis.hashCode();
    }

    public final String name() {
        return this.name;
    }

    public IbisIdentifier ibisIdentifier() {
        return this.ibis;
    }

    public String toString() {
        return "(SendPortIdentifier: name = \"" + this.name + "\", ibis = \"" + this.ibis + "\")";
    }
}

