/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl;

import ibis.ipl.IbisIdentifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ReceivePortIdentifier
implements ibis.ipl.ReceivePortIdentifier {
    private static final long serialVersionUID = -6757071659785922784L;
    public final String name;
    public final ibis.ipl.impl.IbisIdentifier ibis;

    public ReceivePortIdentifier(String name, ibis.ipl.impl.IbisIdentifier ibis) {
        if (name == null) {
            throw new NullPointerException("name is null in ReceivePortIdentifier");
        }
        if (ibis == null) {
            throw new NullPointerException("Ibis identifier is null in ReceivePortIdentifier");
        }
        this.name = name;
        this.ibis = ibis;
    }

    public ReceivePortIdentifier(byte[] codedForm) throws IOException {
        this(codedForm, 0, codedForm.length);
    }

    public ReceivePortIdentifier(byte[] codedForm, int offset, int length) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(codedForm, offset, length)));
    }

    public ReceivePortIdentifier(DataInput dis) throws IOException {
        this.name = dis.readUTF();
        this.ibis = new ibis.ipl.impl.IbisIdentifier(dis);
    }

    public byte[] toBytes() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeUTF(this.name);
            this.ibis.writeTo(dos);
            dos.flush();
            return bos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean equals(ReceivePortIdentifier other) {
        if (other == this) {
            return true;
        }
        return this.name.equals(other.name) && this.ibis.equals(other.ibis);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof ReceivePortIdentifier) {
            return this.equals((ReceivePortIdentifier)other);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.ibis.hashCode();
    }

    public String name() {
        return this.name;
    }

    public IbisIdentifier ibisIdentifier() {
        return this.ibis;
    }

    public String toString() {
        return "(ReceivePortIdentifier: name = " + this.name + ", ibis = " + this.ibis + ")";
    }
}

