/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.util.messagecombining;

import ibis.io.DataOutputStream;
import ibis.ipl.WriteMessage;
import java.io.IOException;
import java.nio.ByteBuffer;

final class StoreArrayOutputStream
extends DataOutputStream {
    private static final int DEFAULT_SIZE = 16384;
    private int[] indices = new int[8];
    private boolean[] boolean_store;
    private int boolean_count;
    private byte[] byte_store;
    private int byte_count;
    private short[] short_store;
    private int short_count;
    private char[] char_store;
    private int char_count;
    private int[] int_store;
    private int int_count;
    private long[] long_store;
    private int long_count;
    private float[] float_store;
    private int float_count;
    private double[] double_store;
    private int double_count;
    private long count = 0L;
    private final int initialSize;

    public StoreArrayOutputStream() {
        this(16384);
    }

    public StoreArrayOutputStream(int initialSize) {
        this.initialSize = initialSize;
        this.clear();
    }

    public int bufferSize() {
        return -1;
    }

    private void clear() {
        this.boolean_store = new boolean[this.initialSize];
        this.byte_store = new byte[this.initialSize];
        this.short_store = new short[this.initialSize];
        this.char_store = new char[this.initialSize];
        this.int_store = new int[this.initialSize];
        this.long_store = new long[this.initialSize];
        this.float_store = new float[this.initialSize];
        this.double_store = new double[this.initialSize];
        this.boolean_count = 0;
        this.byte_count = 0;
        this.short_count = 0;
        this.char_count = 0;
        this.int_count = 0;
        this.long_count = 0;
        this.float_count = 0;
        this.double_count = 0;
        this.count = 0L;
    }

    private final void resize_boolean(int required) {
        int new_size;
        for (new_size = this.boolean_store.length; new_size < required; new_size *= 2) {
        }
        boolean[] tmp = new boolean[new_size];
        System.arraycopy(this.boolean_store, 0, tmp, 0, this.boolean_count);
        this.boolean_store = tmp;
    }

    private final void resize_byte(int required) {
        int new_size;
        for (new_size = this.byte_store.length; new_size < required; new_size *= 2) {
        }
        byte[] tmp = new byte[new_size];
        System.arraycopy(this.byte_store, 0, tmp, 0, this.byte_count);
        this.byte_store = tmp;
    }

    private final void resize_short(int required) {
        int new_size;
        for (new_size = this.short_store.length; new_size < required; new_size *= 2) {
        }
        short[] tmp = new short[new_size];
        System.arraycopy(this.short_store, 0, tmp, 0, this.short_count);
        this.short_store = tmp;
    }

    private final void resize_char(int required) {
        int new_size;
        for (new_size = this.char_store.length; new_size < required; new_size *= 2) {
        }
        char[] tmp = new char[new_size];
        System.arraycopy(this.char_store, 0, tmp, 0, this.char_count);
        this.char_store = tmp;
    }

    private final void resize_int(int required) {
        int new_size;
        for (new_size = this.int_store.length; new_size < required; new_size *= 2) {
        }
        int[] tmp = new int[new_size];
        System.arraycopy(this.int_store, 0, tmp, 0, this.int_count);
        this.int_store = tmp;
    }

    private final void resize_long(int required) {
        int new_size;
        for (new_size = this.long_store.length; new_size < required; new_size *= 2) {
        }
        long[] tmp = new long[new_size];
        System.arraycopy(this.long_store, 0, tmp, 0, this.long_count);
        this.long_store = tmp;
    }

    private final void resize_float(int required) {
        int new_size;
        for (new_size = this.float_store.length; new_size < required; new_size *= 2) {
        }
        float[] tmp = new float[new_size];
        System.arraycopy(this.float_store, 0, tmp, 0, this.float_count);
        this.float_store = tmp;
    }

    private final void resize_double(int required) {
        int new_size;
        for (new_size = this.double_store.length; new_size < required; new_size *= 2) {
        }
        double[] tmp = new double[new_size];
        System.arraycopy(this.double_store, 0, tmp, 0, this.double_count);
        this.double_store = tmp;
    }

    public void writeArray(boolean[] a, int off, int len) {
        if (this.boolean_count + len > this.boolean_store.length) {
            this.resize_boolean(this.boolean_count + len);
        }
        System.arraycopy(a, off, this.boolean_store, this.boolean_count, len);
        this.boolean_count += len;
        this.count += (long)len;
    }

    public void writeArray(byte[] a, int off, int len) {
        if (this.byte_count + len > this.byte_store.length) {
            this.resize_byte(this.byte_count + len);
        }
        System.arraycopy(a, off, this.byte_store, this.byte_count, len);
        this.byte_count += len;
        this.count += (long)len;
    }

    public void writeArray(short[] a, int off, int len) {
        if (this.short_count + len > this.short_store.length) {
            this.resize_short(this.short_count + len);
        }
        System.arraycopy(a, off, this.short_store, this.short_count, len);
        this.short_count += len;
        this.count += 2L * (long)len;
    }

    public void writeArray(char[] a, int off, int len) {
        if (this.char_count + len > this.char_store.length) {
            this.resize_char(this.char_count + len);
        }
        System.arraycopy(a, off, this.char_store, this.char_count, len);
        this.char_count += len;
        this.count += 2L * (long)len;
    }

    public void writeArray(int[] a, int off, int len) {
        if (this.int_count + len > this.int_store.length) {
            this.resize_int(this.int_count + len);
        }
        System.arraycopy(a, off, this.int_store, this.int_count, len);
        this.int_count += len;
        this.count += 4L * (long)len;
    }

    public void writeArray(long[] a, int off, int len) {
        if (this.long_count + len > this.long_store.length) {
            this.resize_long(this.long_count + len);
        }
        System.arraycopy(a, off, this.long_store, this.long_count, len);
        this.long_count += len;
        this.count += 8L * (long)len;
    }

    public void writeArray(float[] a, int off, int len) {
        if (this.float_count + len > this.float_store.length) {
            this.resize_float(this.float_count + len);
        }
        System.arraycopy(a, off, this.float_store, this.float_count, len);
        this.float_count += len;
        this.count += 4L * (long)len;
    }

    public void writeArray(double[] a, int off, int len) {
        if (this.double_count + len > this.double_store.length) {
            this.resize_double(this.double_count + len);
        }
        System.arraycopy(a, off, this.double_store, this.double_count, len);
        this.double_count += len;
        this.count += 8L * (long)len;
    }

    public void write(byte[] a, int off, int len) {
        this.writeArray(a, off, len);
    }

    public void write(byte[] a) {
        this.writeArray(a, 0, a.length);
    }

    public void write(int b) {
        this.writeByte((byte)b);
    }

    public void writeByte(byte b) {
        if (this.byte_count + 1 > this.byte_store.length) {
            this.resize_byte(this.byte_count + 1);
        }
        this.byte_store[this.byte_count++] = b;
        ++this.count;
    }

    public void writeBoolean(boolean b) {
        if (this.boolean_count + 1 > this.boolean_store.length) {
            this.resize_boolean(this.boolean_count + 1);
        }
        this.boolean_store[this.boolean_count++] = b;
        ++this.count;
    }

    public void writeShort(short b) {
        if (this.short_count + 1 > this.short_store.length) {
            this.resize_short(this.short_count + 1);
        }
        this.short_store[this.short_count++] = b;
        this.count += 2L;
    }

    public void writeChar(char b) {
        if (this.char_count + 1 > this.char_store.length) {
            this.resize_char(this.char_count + 1);
        }
        this.char_store[this.char_count++] = b;
        this.count += 2L;
    }

    public void writeInt(int b) {
        if (this.int_count + 1 > this.int_store.length) {
            this.resize_int(this.int_count + 1);
        }
        this.int_store[this.int_count++] = b;
        this.count += 4L;
    }

    public void writeLong(long b) {
        if (this.long_count + 1 > this.long_store.length) {
            this.resize_long(this.long_count + 1);
        }
        this.long_store[this.long_count++] = b;
        this.count += 8L;
    }

    public void writeFloat(float b) {
        if (this.float_count + 1 > this.float_store.length) {
            this.resize_float(this.float_count + 1);
        }
        this.float_store[this.float_count++] = b;
        this.count += 4L;
    }

    public void writeDouble(double b) {
        if (this.double_count + 1 > this.double_store.length) {
            this.resize_double(this.double_count + 1);
        }
        this.double_store[this.double_count++] = b;
        this.count += 8L;
    }

    public long bytesWritten() {
        return this.count;
    }

    public void resetBytesWritten() {
        this.count = 0L;
    }

    public void flush() throws IOException {
    }

    public boolean finished() {
        return true;
    }

    public void finish() throws IOException {
        this.flush();
    }

    public void close() throws IOException {
        this.flush();
    }

    public void writeToMessage(WriteMessage message) throws IOException {
        this.indices[0] = this.boolean_count;
        this.indices[1] = this.byte_count;
        this.indices[2] = this.short_count;
        this.indices[3] = this.char_count;
        this.indices[4] = this.int_count;
        this.indices[5] = this.long_count;
        this.indices[6] = this.float_count;
        this.indices[7] = this.double_count;
        message.writeArray(this.indices);
        if (this.boolean_count > 0) {
            message.writeArray(this.boolean_store, 0, this.boolean_count);
        }
        if (this.byte_count > 0) {
            message.writeArray(this.byte_store, 0, this.byte_count);
        }
        if (this.short_count > 0) {
            message.writeArray(this.short_store, 0, this.short_count);
        }
        if (this.char_count > 0) {
            message.writeArray(this.char_store, 0, this.char_count);
        }
        if (this.int_count > 0) {
            message.writeArray(this.int_store, 0, this.int_count);
        }
        if (this.long_count > 0) {
            message.writeArray(this.long_store, 0, this.long_count);
        }
        if (this.float_count > 0) {
            message.writeArray(this.float_store, 0, this.float_count);
        }
        if (this.double_count > 0) {
            message.writeArray(this.double_store, 0, this.double_count);
        }
        message.finish();
        this.boolean_count = 0;
        this.byte_count = 0;
        this.short_count = 0;
        this.char_count = 0;
        this.int_count = 0;
        this.long_count = 0;
        this.float_count = 0;
        this.double_count = 0;
        this.count = 0L;
    }

    public void writeByteBuffer(ByteBuffer value) throws IOException {
        int len = value.limit() - value.position();
        if (this.byte_count + len > this.byte_store.length) {
            this.resize_byte(this.byte_count + len);
        }
        value.get(this.byte_store, this.byte_count, len);
        this.byte_count += len;
        this.count += (long)len;
    }
}

