/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.support.vivaldi;

import ibis.ipl.support.Connection;
import ibis.ipl.support.vivaldi.VivaldiClient;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.util.ThreadPool;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHandler
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionHandler.class);
    private final VirtualServerSocket serverSocket;
    private final VivaldiClient vivaldi;

    ConnectionHandler(VirtualServerSocket socket, VivaldiClient vivaldi) throws IOException {
        this.serverSocket = socket;
        this.vivaldi = vivaldi;
        ThreadPool.createNew((Runnable)this, (String)"Vivaldi Connection handler");
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Connection connection = new Connection(this.serverSocket);
                    this.vivaldi.handleConnection(connection);
                }
            }
            catch (IOException e) {
                if (this.serverSocket.isClosed()) {
                    return;
                }
                logger.error("Accept failed, waiting a second, will retry", (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }
}

