/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.statistics;

import ibis.ipl.registry.statistics.Statistics;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Experiment {
    private static final Logger logger = LoggerFactory.getLogger(Experiment.class);
    private final String poolName;
    private final List<Statistics> clientStatistics;
    private final Statistics serverStatistics;
    private final long startTime;
    private final long endTime;

    Experiment(File directory) throws IOException {
        this.poolName = directory.getName();
        File serverFile = new File(directory, "server");
        if (serverFile.exists()) {
            this.serverStatistics = new Statistics(serverFile);
        } else {
            this.serverStatistics = null;
            if (logger.isDebugEnabled()) {
                logger.debug("no server file found");
            }
        }
        this.clientStatistics = new ArrayList<Statistics>();
        if (!directory.isDirectory()) {
            throw new IOException(directory + " not a directory");
        }
        int loadErrors = 0;
        for (File file : directory.listFiles()) {
            if (file.getName().equals("server") || file.getName().endsWith(".old")) continue;
            try {
                this.clientStatistics.add(new Statistics(file));
            }
            catch (IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("cannot load statistics file: " + file + " (trying .old version)", (Throwable)e);
                }
                ++loadErrors;
                try {
                    File oldFile = new File(file.getPath() + ".old");
                    this.clientStatistics.add(new Statistics(oldFile));
                }
                catch (IOException e2) {
                    logger.error("cannot load OLD statistics file: " + file, (Throwable)e2);
                }
            }
        }
        if (loadErrors > 0) {
            logger.warn(this.poolName + ": " + loadErrors + " files could not be read (used .old version instead)");
        }
        this.startTime = this.getStartTime();
        this.endTime = this.getEndTime();
    }

    private long getStartTime() {
        long result = Long.MAX_VALUE;
        if (this.serverStatistics != null) {
            result = this.serverStatistics.getStartTime();
        }
        for (Statistics statistics : this.clientStatistics) {
            if (statistics.getStartTime() >= result) continue;
            result = statistics.getStartTime();
        }
        return result;
    }

    private long getEndTime() {
        long result = 0L;
        if (this.serverStatistics != null) {
            result = this.serverStatistics.getEndTime();
        }
        for (Statistics statistics : this.clientStatistics) {
            if (statistics.getEndTime() <= result) continue;
            result = statistics.getEndTime();
        }
        return result;
    }

    String getName() {
        return this.poolName;
    }

    long duration() {
        if (logger.isDebugEnabled()) {
            logger.debug("duration = " + (this.endTime - this.startTime));
        }
        return this.endTime - this.startTime;
    }

    double serverPoolSize(long time) {
        long realtime = time + this.startTime;
        if (this.serverStatistics != null) {
            double result = this.serverStatistics.poolSizeAt(realtime);
            if (logger.isDebugEnabled()) {
                logger.debug("SERVER statistics: value at " + time + " (" + realtime + ") = " + result);
            }
            if (result == -1.0) {
                return 0.0;
            }
            return result;
        }
        return 0.0;
    }

    double averagePoolSize(long time) {
        long realtime = time + this.startTime;
        double active = 0.0;
        double total = 0.0;
        for (Statistics statistics : this.clientStatistics) {
            double value = statistics.poolSizeAt(realtime);
            if (logger.isDebugEnabled()) {
                logger.debug("statistics: " + statistics + " value at " + time + " (" + realtime + ") = " + value);
            }
            if (value == -1.0) continue;
            active += 1.0;
            total += value;
        }
        if (active == 0.0) {
            return 0.0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("total = " + total + ", active = " + active + ", value = " + total / active);
        }
        return total / active;
    }

    double averageClientTraffic() {
        if (this.clientStatistics.size() == 0) {
            return 0.0;
        }
        double total = 0.0;
        for (Statistics statistics : this.clientStatistics) {
            total += statistics.totalTraffic();
        }
        return total / (double)this.clientStatistics.size();
    }

    double serverTraffic() {
        if (this.serverStatistics == null) {
            return 0.0;
        }
        return this.serverStatistics.totalTraffic();
    }

    public void serverCommStats(Formatter out) {
        if (this.serverStatistics == null) {
            return;
        }
        this.serverStatistics.printCommStats(out);
    }
}

