/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central.server;

import ibis.ipl.Location;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.registry.ControlPolicy;
import ibis.ipl.registry.central.Member;
import ibis.ipl.registry.central.RegistryProperties;
import ibis.ipl.registry.central.server.Pool;
import ibis.ipl.registry.central.server.ServerConnectionHandler;
import ibis.ipl.server.RegistryServiceInterface;
import ibis.ipl.server.Service;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import ibis.util.ThreadPool;
import ibis.util.TypedProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CentralRegistryService
extends Thread
implements Service,
RegistryServiceInterface {
    private static final Logger logger = LoggerFactory.getLogger(CentralRegistryService.class);
    public static final boolean REMOVE_ENDED_POOLS = true;
    private static final long POOL_CLEANUP_TIMEOUT = 60000L;
    private final VirtualSocketFactory socketFactory;
    private final SortedMap<String, Pool> pools;
    private final boolean printStats;
    private final boolean printEvents;
    private final boolean printErrors;
    private final int connectTimeout;
    private ServerConnectionHandler handler;
    private boolean stopped = false;

    public CentralRegistryService(TypedProperties properties, VirtualSocketFactory socketFactory, ControlPolicy policy) throws IOException {
        this.socketFactory = socketFactory;
        TypedProperties typedProperties = RegistryProperties.getHardcodedProperties();
        typedProperties.addProperties((Properties)properties);
        this.printStats = typedProperties.getBooleanProperty("ibis.server.print.stats");
        this.printEvents = typedProperties.getBooleanProperty("ibis.server.print.events");
        this.printErrors = typedProperties.getBooleanProperty("ibis.server.print.errors");
        this.connectTimeout = typedProperties.getIntProperty("ibis.registry.central.server.connect.timeout") * 1000;
        this.pools = new TreeMap<String, Pool>();
        this.handler = new ServerConnectionHandler(this, socketFactory, policy);
        ThreadPool.createNew((Runnable)this, (String)"Central Registry Service");
        if (logger.isDebugEnabled()) {
            logger.debug("Started Central Registry service on virtual port 302");
        }
    }

    synchronized Pool getPool(String poolName) {
        return (Pool)this.pools.get(poolName);
    }

    @Override
    public String getServiceName() {
        return "registry";
    }

    synchronized Pool getOrCreatePool(String poolName, boolean peerBootstrap, long heartbeatInterval, long eventPushInterval, boolean gossip, long gossipInterval, boolean adaptGossipInterval, boolean tree, boolean closedWorld, int poolSize, boolean keepStatistics, long statisticsInterval, boolean purgeHistory, String implementationVersion) throws IOException {
        Pool result = this.getPool(poolName);
        if (result == null || result.hasEnded()) {
            result = new Pool(poolName, this.socketFactory, peerBootstrap, heartbeatInterval, eventPushInterval, gossip, gossipInterval, adaptGossipInterval, tree, closedWorld, poolSize, keepStatistics, statisticsInterval, this.connectTimeout, implementationVersion, this.printEvents, this.printErrors, purgeHistory);
            this.pools.put(poolName, result);
        }
        return result;
    }

    synchronized boolean isStopped() {
        return this.stopped;
    }

    @Override
    public synchronized void end(long deadline) {
        if (this.stopped) {
            return;
        }
        long timeLeft = deadline - System.currentTimeMillis();
        while (timeLeft > 0L && this.pools.size() > 0) {
            try {
                this.notifyAll();
                this.wait(Math.min(1000L, timeLeft));
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            timeLeft = deadline - System.currentTimeMillis();
        }
        this.stopped = true;
        this.notifyAll();
        this.handler.end();
    }

    @Override
    public String toString() {
        return "Central Registry service on virtual port 302";
    }

    @Override
    public synchronized void run() {
        while (!this.stopped) {
            if (this.pools.size() > 0) {
                String message = "list of pools:\n     CURRENT_SIZE JOINS LEAVES DIEDS ELECTIONS SIGNALS FIXED_SIZE CLOSED TERMINATED ENDED\n";
                for (Pool pool : this.pools.values().toArray(new Pool[0])) {
                    if (this.printStats) {
                        message = message + pool.getStatsString() + "\n";
                    }
                    if (!pool.hasEnded()) continue;
                    pool.saveStatistics();
                    this.pools.remove(pool.getName());
                    if (this.pools.size() != 0) continue;
                    this.notifyAll();
                }
                if (this.printStats) {
                    if (logger.isInfoEnabled()) {
                        logger.info(message);
                    } else {
                        System.err.println(message);
                    }
                }
            }
            try {
                this.wait(60000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized Map<String, String> getStats() {
        HashMap<String, String> result = new HashMap<String, String>();
        String poolNames = null;
        for (Pool pool : this.pools.values()) {
            poolNames = poolNames == null ? pool.getName() : poolNames + "," + pool.getName();
            result.putAll(pool.getStatsMap());
        }
        result.put("pool.names", poolNames);
        return result;
    }

    @Override
    public synchronized String[] getPools() {
        return this.pools.keySet().toArray(new String[0]);
    }

    public IbisIdentifier[] getMembers(String poolName) {
        Pool pool = this.getPool(poolName);
        if (pool == null) {
            return new IbisIdentifier[0];
        }
        Member[] members = pool.getMembers();
        IbisIdentifier[] result = new IbisIdentifier[members.length];
        for (int i = 0; i < members.length; ++i) {
            result[i] = members[i].getIbis();
        }
        return result;
    }

    @Override
    public String[] getLocations(String poolName) throws IOException {
        Pool pool = this.getPool(poolName);
        if (pool == null) {
            return new String[0];
        }
        Location[] locations = pool.getLocations();
        String[] result = new String[locations.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = locations[i].toString();
        }
        return result;
    }

    @Override
    public synchronized Map<String, Integer> getPoolSizes() throws IOException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Pool pool : this.pools.values()) {
            result.put(pool.getName(), pool.getSize());
        }
        return result;
    }
}

