/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry;

import ibis.ipl.Credentials;
import ibis.ipl.IbisCapabilities;
import ibis.ipl.IbisConfigurationException;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.RegistryEventHandler;
import ibis.ipl.impl.Location;
import ibis.ipl.registry.Registry;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public final class NullRegistry
extends Registry {
    private final ibis.ipl.impl.IbisIdentifier identifier;

    @Override
    public long getSequenceNumber(String name) throws IOException {
        throw new IbisConfigurationException("sequence numbers not supported by NullRegistry");
    }

    public NullRegistry(IbisCapabilities capabilities, RegistryEventHandler handler, Properties properties, byte[] data, String implementationVersion, Credentials credentials, byte[] tag) throws IOException {
        if (handler != null) {
            throw new IbisConfigurationException("upcalls not supported by NullRegistry");
        }
        UUID id = UUID.randomUUID();
        Location location = Location.defaultLocation((Properties)properties, null);
        String pool = properties.getProperty("ibis.pool.name");
        this.identifier = new ibis.ipl.impl.IbisIdentifier(id.toString(), data, null, location, pool, tag);
    }

    @Override
    public void leave() throws IOException {
    }

    public void assumeDead(IbisIdentifier ibis) throws IOException {
    }

    public IbisIdentifier elect(String election) throws IOException {
        throw new IbisConfigurationException("elections not supported by NullRegistry");
    }

    public IbisIdentifier elect(String election, long timeoutMillis) throws IOException {
        throw new IbisConfigurationException("elections not supported by NullRegistry");
    }

    public IbisIdentifier getElectionResult(String election) throws IOException {
        throw new IbisConfigurationException("elections not supported by NullRegistry");
    }

    public IbisIdentifier getElectionResult(String election, long timeoutMillis) throws IOException {
        throw new IbisConfigurationException("elections not supported by NullRegistry");
    }

    @Override
    public String[] wonElections() {
        throw new IbisConfigurationException("elections not supported by NullRegistry");
    }

    public void maybeDead(IbisIdentifier ibis) throws IOException {
    }

    public void signal(String string, IbisIdentifier ... ibisses) throws IOException {
        throw new IbisConfigurationException("signals not supported by NullRegistry");
    }

    @Override
    public ibis.ipl.impl.IbisIdentifier getIbisIdentifier() {
        return this.identifier;
    }

    public IbisIdentifier[] diedIbises() {
        throw new IbisConfigurationException("died not supported by NullRegistry");
    }

    public IbisIdentifier[] joinedIbises() {
        throw new IbisConfigurationException("joins not supported by NullRegistry");
    }

    public IbisIdentifier[] leftIbises() {
        throw new IbisConfigurationException("leaves not supported by NullRegistry");
    }

    public String[] receivedSignals() {
        throw new IbisConfigurationException("signals not supported by NullRegistry");
    }

    public void disableEvents() {
    }

    public void enableEvents() {
    }

    public int getPoolSize() {
        throw new IbisConfigurationException("pool size not supported by NullRegistry");
    }

    public String getPoolName() {
        return this.identifier.poolName();
    }

    public void waitUntilPoolClosed() {
        throw new IbisConfigurationException("waitUntilPoolClosed not supported by NullRegistry");
    }

    public boolean isClosed() {
        throw new IbisConfigurationException("closed world not supported by NullRegistry");
    }

    public Map<String, String> managementProperties() {
        return new HashMap<String, String>();
    }

    public String getManagementProperty(String key) throws NoSuchPropertyException {
        throw new NoSuchPropertyException("no properties supported by null registry");
    }

    public void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
        throw new NoSuchPropertyException("no properties supported by null registry");
    }

    public void setManagementProperty(String key, String value) throws NoSuchPropertyException {
        throw new NoSuchPropertyException("no properties supported by null registry");
    }

    public void printManagementProperties(PrintStream stream) {
    }

    public boolean hasTerminated() {
        throw new IbisConfigurationException("termination not supported by NullRegistry");
    }

    public void terminate() throws IOException {
        throw new IbisConfigurationException("termination not supported by NullRegistry");
    }

    public ibis.ipl.impl.IbisIdentifier waitUntilTerminated() {
        throw new IbisConfigurationException("termination not supported by NullRegistry");
    }

    @Override
    public ibis.ipl.impl.IbisIdentifier getRandomPoolMember() {
        return null;
    }
}

