# auto generated by update_py.py
class SCHEMAS:
    DB_CORE = 'db_core'

# f'''CREATE PROCEDURE addcol()
# BEGIN
#     IF NOT EXISTS(
#         SELECT NULL FROM INFORMATION_SCHEMA.COLUMNS
#             WHERE table_name = '{table_name}'
#             AND table_schema = '{schema_name}'
#             AND column_name = '{column_name}') THEN
#         ALTER TABLE `{table_name}` ADD COLUMN `{column_name}` double;
#     END IF;
# END;
# CALL addcol();
# DROP PROCEDURE addcol;'''


def get_add_col_sql(table_name, schema_name, column_name, column_type='double'):
    assert column_type in ['double'], 'only double type column is tested and supported for now'
    script = f'ALTER TABLE `{table_name}` ADD COLUMN `{column_name}` double;'
    return script


# all scripts shall be idempotent

DB_CORE_SQLS = [
    get_add_col_sql('exch_pos', SCHEMAS.DB_CORE, 'realized_pnl'),
    get_add_col_sql('exch_pos', SCHEMAS.DB_CORE, 'unrealized_pnl'),
    get_add_col_sql('acc_pos', SCHEMAS.DB_CORE, 'realized_pnl'),
    get_add_col_sql('acc_pos', SCHEMAS.DB_CORE, 'unrealized_pnl'),
]

DB_MIGRATE_SQLS = {
    SCHEMAS.DB_CORE: DB_CORE_SQLS
}
