"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BucketReplication = exports.ReplicationRuleStatus = exports.ReplicationDestinationStorageClass = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
var ReplicationDestinationStorageClass;
(function (ReplicationDestinationStorageClass) {
    ReplicationDestinationStorageClass["DEEP_ARCHIVE"] = "DEEP_ARCHIVE";
    ReplicationDestinationStorageClass["GLACIER"] = "GLACIER";
    ReplicationDestinationStorageClass["INTELLIGENT_TIERING"] = "INTELLIGENT_TIERING";
    ReplicationDestinationStorageClass["ONEZONE_IA"] = "ONEZONE_IA";
    ReplicationDestinationStorageClass["OUTPOSTS"] = "OUTPOSTS";
    ReplicationDestinationStorageClass["REDUCED_REDUNDANCY"] = "REDUCED_REDUNDANCY";
    ReplicationDestinationStorageClass["STANDARD"] = "STANDARD";
    ReplicationDestinationStorageClass["STANDARD_IA"] = "STANDARD_IA";
})(ReplicationDestinationStorageClass = exports.ReplicationDestinationStorageClass || (exports.ReplicationDestinationStorageClass = {}));
/**
 * @stability stable
 */
var ReplicationRuleStatus;
(function (ReplicationRuleStatus) {
    ReplicationRuleStatus["DISABLED"] = "Disabled";
    ReplicationRuleStatus["ENABLED"] = "Enabled";
})(ReplicationRuleStatus = exports.ReplicationRuleStatus || (exports.ReplicationRuleStatus = {}));
/**
 * @stability stable
 */
class BucketReplication extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const sourceAccount = cdk.Stack.of(props.sourceBucket).account;
        const destinationAccount = cdk.Stack.of(props.destinationBucket).account;
        const cfnSourceBucket = props.sourceBucket.node
            .defaultChild;
        const replicationRole = new iam.Role(this, 'ReplicationRole', {
            assumedBy: new iam.ServicePrincipal('s3.amazonaws.com'),
        });
        replicationRole.addToPolicy(new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            resources: [`${props.destinationBucket.bucketArn}/*`],
            actions: [
                's3:ReplicateObject',
                's3:ReplicateDelete',
                's3:ReplicateTags',
            ],
        }));
        replicationRole.addToPolicy(new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            resources: [props.sourceBucket.bucketArn],
            actions: ['s3:GetReplicationConfiguration', 's3:ListBucket'],
        }));
        replicationRole.addToPolicy(new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            resources: [`${props.sourceBucket.bucketArn}/*`],
            actions: [
                's3:GetObjectVersion',
                's3:GetObjectVersionAcl',
                's3:GetObjectVersionTagging',
            ],
        }));
        if (sourceAccount !== destinationAccount) {
            props.destinationBucket.addToResourcePolicy(new iam.PolicyStatement({
                effect: iam.Effect.ALLOW,
                principals: [
                    new iam.ArnPrincipal(`arn:aws:iam::${sourceAccount}:root`),
                ],
                resources: [`${props.destinationBucket.bucketArn}/*`],
                actions: [
                    's3:ReplicateObject',
                    's3:ReplicateDelete',
                    's3:ReplicateTags',
                ],
            }));
            props.destinationBucket.addToResourcePolicy(new iam.PolicyStatement({
                effect: iam.Effect.ALLOW,
                principals: [
                    new iam.ArnPrincipal(`arn:aws:iam::${sourceAccount}:root`),
                ],
                resources: [`${props.destinationBucket.bucketArn}`],
                actions: [
                    's3:List*',
                    's3:GetBucketVersioning',
                    's3:PutBucketVersioning',
                ],
            }));
        }
        cfnSourceBucket.replicationConfiguration = {
            role: replicationRole.roleArn,
            rules: [
                {
                    destination: {
                        storageClass: ReplicationDestinationStorageClass.STANDARD,
                        ...props.replicationDestinationProperties,
                        bucket: props.destinationBucket.bucketArn,
                    },
                    status: ReplicationRuleStatus.ENABLED,
                    ...props.replicationRuleProperties,
                },
            ],
        };
    }
}
exports.BucketReplication = BucketReplication;
_a = JSII_RTTI_SYMBOL_1;
BucketReplication[_a] = { fqn: "cdk-s3-bucketreplication.BucketReplication", version: "0.0.7" };
//# sourceMappingURL=data:application/json;base64,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