/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.StatementHandler;
import no.priv.garshol.duke.utils.NTriplesParser;
import org.junit.Assert;
import org.junit.Test;

public class NTriplesParserTest {
    @Test
    public void testEmpty() throws IOException {
        List<Statement> model = NTriplesParserTest.parse("");
        Assert.assertTrue((String)"empty data didn't produce empty model", (boolean)model.isEmpty());
    }

    @Test
    public void testSingleLine() throws IOException {
        List<Statement> model = NTriplesParserTest.parse("<http://a> <http://b> <http://c> .");
        Assert.assertEquals((long)1L, (long)model.size());
        Statement st = model.get(0);
        Assert.assertEquals((String)"subject", (Object)"http://a", (Object)st.subject);
        Assert.assertEquals((String)"property", (Object)"http://b", (Object)st.property);
        Assert.assertEquals((String)"object", (Object)"http://c", (Object)st.object);
        Assert.assertEquals((String)"literal", (Object)false, (Object)st.literal);
    }

    @Test
    public void testSingleLineBnode() throws IOException {
        List<Statement> model = NTriplesParserTest.parse("_:a <http://b> <http://c> .");
        Assert.assertEquals((long)1L, (long)model.size());
        Statement st = model.get(0);
        Assert.assertEquals((String)"subject", (Object)"_:a", (Object)st.subject);
        Assert.assertEquals((String)"property", (Object)"http://b", (Object)st.property);
        Assert.assertEquals((String)"object", (Object)"http://c", (Object)st.object);
        Assert.assertEquals((String)"literal", (Object)false, (Object)st.literal);
    }

    @Test
    public void testTwoLines() throws IOException {
        List<Statement> model = NTriplesParserTest.parse("<http://a> <http://b> <http://c> .\n<http://d> <http://e> <http://f> .\n");
        Assert.assertEquals((long)2L, (long)model.size());
        Statement st = model.get(0);
        Assert.assertEquals((String)"subject", (Object)"http://a", (Object)st.subject);
        Assert.assertEquals((String)"property", (Object)"http://b", (Object)st.property);
        Assert.assertEquals((String)"object", (Object)"http://c", (Object)st.object);
        Assert.assertEquals((String)"literal", (Object)false, (Object)st.literal);
        st = model.get(1);
        Assert.assertEquals((String)"subject", (Object)"http://d", (Object)st.subject);
        Assert.assertEquals((String)"property", (Object)"http://e", (Object)st.property);
        Assert.assertEquals((String)"object", (Object)"http://f", (Object)st.object);
        Assert.assertEquals((String)"literal", (Object)false, (Object)st.literal);
    }

    @Test
    public void testSingleLineLiteral() throws IOException {
        List<Statement> model = NTriplesParserTest.parse("<http://a> <http://b> \"c\" .");
        Assert.assertEquals((long)1L, (long)model.size());
        Statement st = model.get(0);
        Assert.assertEquals((String)"subject", (Object)"http://a", (Object)st.subject);
        Assert.assertEquals((String)"property", (Object)"http://b", (Object)st.property);
        Assert.assertEquals((String)"object", (Object)"c", (Object)st.object);
        Assert.assertEquals((String)"literal", (Object)true, (Object)st.literal);
    }

    @Test
    public void testLiteralEscaping() throws IOException {
        List<Statement> model = NTriplesParserTest.parse("<http://data.semanticweb.org/person/antonella-poggi> <http://data.semanticweb.org/ns/swc/ontology#affiliation> \"Universita' degli Studi di Roma 'La \\r\\n    Sapienza'\" .  ");
        Assert.assertEquals((long)1L, (long)model.size());
        Statement st = model.get(0);
        Assert.assertEquals((String)"subject", (Object)"http://data.semanticweb.org/person/antonella-poggi", (Object)st.subject);
        Assert.assertEquals((String)"property", (Object)"http://data.semanticweb.org/ns/swc/ontology#affiliation", (Object)st.property);
        Assert.assertEquals((String)"object", (Object)"Universita' degli Studi di Roma 'La \r\n    Sapienza'", (Object)st.object);
        Assert.assertEquals((String)"literal", (Object)true, (Object)st.literal);
    }

    @Test
    public void testComment() throws IOException {
        List<Statement> model = NTriplesParserTest.parse("<http://a> <http://b> <http://c> .\n# this is a comment\n<http://d> <http://e> <http://f> .\n");
        Assert.assertEquals((long)2L, (long)model.size());
        Statement st = model.get(0);
        Assert.assertEquals((String)"subject", (Object)"http://a", (Object)st.subject);
        Assert.assertEquals((String)"property", (Object)"http://b", (Object)st.property);
        Assert.assertEquals((String)"object", (Object)"http://c", (Object)st.object);
        Assert.assertEquals((String)"literal", (Object)false, (Object)st.literal);
        st = model.get(1);
        Assert.assertEquals((String)"subject", (Object)"http://d", (Object)st.subject);
        Assert.assertEquals((String)"property", (Object)"http://e", (Object)st.property);
        Assert.assertEquals((String)"object", (Object)"http://f", (Object)st.object);
        Assert.assertEquals((String)"literal", (Object)false, (Object)st.literal);
    }

    @Test
    public void testLanguageTag() throws IOException {
        List<Statement> model = NTriplesParserTest.parse("<http://a> <http://b> \"foo\"@en .");
        Assert.assertEquals((long)1L, (long)model.size());
        Statement st = model.get(0);
        Assert.assertEquals((String)"subject", (Object)"http://a", (Object)st.subject);
        Assert.assertEquals((String)"property", (Object)"http://b", (Object)st.property);
        Assert.assertEquals((String)"object", (Object)"foo", (Object)st.object);
        Assert.assertEquals((String)"literal", (Object)true, (Object)st.literal);
    }

    @Test
    public void testLanguageTagLonger() throws IOException {
        List<Statement> model = NTriplesParserTest.parse("<http://a> <http://b> \"foo\"@en-uk .");
        Assert.assertEquals((long)1L, (long)model.size());
        Statement st = model.get(0);
        Assert.assertEquals((String)"subject", (Object)"http://a", (Object)st.subject);
        Assert.assertEquals((String)"property", (Object)"http://b", (Object)st.property);
        Assert.assertEquals((String)"object", (Object)"foo", (Object)st.object);
        Assert.assertEquals((String)"literal", (Object)true, (Object)st.literal);
    }

    @Test
    public void testLanguageTagBad() throws IOException {
        try {
            NTriplesParserTest.parse("<http://a> <http://b> \"foo\"@12 .");
            Assert.fail((String)"bad language tag accepted");
        }
        catch (DukeException dukeException) {
            // empty catch block
        }
    }

    @Test
    public void testLanguageTagBad2() throws IOException {
        try {
            NTriplesParserTest.parse("<http://a> <http://b> \"foo\"@en-gb-uk .");
            Assert.fail((String)"bad language tag accepted");
        }
        catch (DukeException dukeException) {
            // empty catch block
        }
    }

    @Test
    public void testDataType() throws IOException {
        List<Statement> model = NTriplesParserTest.parse("<http://a> <http://b> \"1\"^^<http://www.w3.org/2001/XMLSchema#int> .");
        Assert.assertEquals((long)1L, (long)model.size());
        Statement st = model.get(0);
        Assert.assertEquals((String)"subject", (Object)"http://a", (Object)st.subject);
        Assert.assertEquals((String)"property", (Object)"http://b", (Object)st.property);
        Assert.assertEquals((String)"object", (Object)"1", (Object)st.object);
        Assert.assertEquals((String)"literal", (Object)true, (Object)st.literal);
    }

    @Test
    public void testDataTypeAndLanguageTag() throws IOException {
        try {
            NTriplesParserTest.parse("<http://a> <http://b> \"1\"^^<http://www.w3.org/2001/XMLSchema#int>@en .");
            Assert.fail((String)"language tag AND datatype not allowed");
        }
        catch (DukeException dukeException) {
            // empty catch block
        }
    }

    @Test
    public void testLanguageTagAndDataType() throws IOException {
        try {
            NTriplesParserTest.parse("<http://a> <http://b> \"1\"@en^^<http://www.w3.org/2001/XMLSchema#int> .");
            Assert.fail((String)"language tag AND datatype not allowed");
        }
        catch (DukeException dukeException) {
            // empty catch block
        }
    }

    @Test
    public void testLiteralEscaping2() throws IOException {
        String aelig = "\\u00C6";
        List<Statement> model = NTriplesParserTest.parse("<http://data.semanticweb.org/a> <http://data.semanticweb.org/b> \"\\\\\\\"" + aelig + "bing\" .  ");
        Assert.assertEquals((long)1L, (long)model.size());
        Statement st = model.get(0);
        Assert.assertEquals((String)"subject", (Object)"http://data.semanticweb.org/a", (Object)st.subject);
        Assert.assertEquals((String)"property", (Object)"http://data.semanticweb.org/b", (Object)st.property);
        Assert.assertEquals((String)"object", (Object)"\\\"\u00c6bing", (Object)st.object);
        Assert.assertEquals((String)"literal", (Object)true, (Object)st.literal);
    }

    @Test
    public void testLiteralEscaping3() throws IOException {
        String aelig = "\\u00c6";
        List<Statement> model = NTriplesParserTest.parse("<http://data.semanticweb.org/a> <http://data.semanticweb.org/b> \"\\\\\\\"" + aelig + "bing\" .  ");
        Assert.assertEquals((long)1L, (long)model.size());
        Statement st = model.get(0);
        Assert.assertEquals((String)"subject", (Object)"http://data.semanticweb.org/a", (Object)st.subject);
        Assert.assertEquals((String)"property", (Object)"http://data.semanticweb.org/b", (Object)st.property);
        Assert.assertEquals((String)"object", (Object)"\\\"\u00c6bing", (Object)st.object);
        Assert.assertEquals((String)"literal", (Object)true, (Object)st.literal);
    }

    @Test
    public void testBlankLine() throws IOException {
        List<Statement> model = NTriplesParserTest.parse("<http://a> <http://b> <http://c> .\n\n<http://d> <http://e> <http://f> .\n");
        Assert.assertEquals((long)2L, (long)model.size());
        Statement st = model.get(0);
        Assert.assertEquals((String)"subject", (Object)"http://a", (Object)st.subject);
        Assert.assertEquals((String)"property", (Object)"http://b", (Object)st.property);
        Assert.assertEquals((String)"object", (Object)"http://c", (Object)st.object);
        Assert.assertEquals((String)"literal", (Object)false, (Object)st.literal);
        st = model.get(1);
        Assert.assertEquals((String)"subject", (Object)"http://d", (Object)st.subject);
        Assert.assertEquals((String)"property", (Object)"http://e", (Object)st.property);
        Assert.assertEquals((String)"object", (Object)"http://f", (Object)st.object);
        Assert.assertEquals((String)"literal", (Object)false, (Object)st.literal);
    }

    @Test
    public void testSingleLineFollowedByGarbage() throws IOException {
        try {
            NTriplesParserTest.parse("<http://a> <http://b> <http://c> . <http://d> ");
            Assert.fail((String)"parser accepted invalid data");
        }
        catch (DukeException dukeException) {
            // empty catch block
        }
    }

    @Test
    public void testLineStops() throws IOException {
        try {
            NTriplesParserTest.parse("<http://data.mattilsynet.no/sesam/webcruiter/dokument/8865432a-0eec-41e2-a781-992091aba0cc>\t  ");
            Assert.fail((String)"parser accepted invalid data");
        }
        catch (DukeException dukeException) {
            // empty catch block
        }
    }

    @Test
    public void testLineStopsBeforeObject() throws IOException {
        try {
            NTriplesParserTest.parse("<http://data.mattilsynet.no/sesam/webcruiter/dokument/8865432a-0eec-41e2-a781-992091aba0cc>\t  <http://foo> ");
            Assert.fail((String)"parser accepted invalid data");
        }
        catch (DukeException dukeException) {
            // empty catch block
        }
    }

    @Test
    public void testLineStopsBeforePeriod() throws IOException {
        try {
            NTriplesParserTest.parse("<http://data.mattilsynet.no/sesam/webcruiter/dokument/8865432a-0eec-41e2-a781-992091aba0cc>\t  <http://foo> \"2\" ");
            Assert.fail((String)"parser accepted invalid data");
        }
        catch (DukeException dukeException) {
            // empty catch block
        }
    }

    @Test
    public void testLineStopsInURI() throws IOException {
        try {
            NTriplesParserTest.parse("<http://data.mattilsynet.no/sesam/webcruiter/dokument/8865432a-0eec-41e2-a781-992091aba0cc>\t  <http://foo> <http://burrur");
            Assert.fail((String)"parser accepted invalid data");
        }
        catch (DukeException dukeException) {
            // empty catch block
        }
    }

    public static List<Statement> parse(String data) throws IOException {
        StatementBuilder builder = new StatementBuilder();
        NTriplesParser.parse((Reader)new StringReader(data), (StatementHandler)builder);
        return builder.statements;
    }

    static class StatementBuilder
    implements StatementHandler {
        List<Statement> statements = new ArrayList<Statement>();

        public void statement(String subject, String property, String object, boolean literal) {
            this.statements.add(new Statement(subject, property, object, literal));
        }
    }

    static class Statement {
        String subject;
        String property;
        String object;
        boolean literal;

        public Statement(String subject, String property, String object, boolean literal) {
            this.subject = subject;
            this.property = property;
            this.object = object;
            this.literal = literal;
        }
    }
}

