/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.genetic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.genetic.GeneticConfiguration;

public class GeneticPopulation {
    private Configuration config;
    private List<GeneticConfiguration> population;
    private int size;
    private int mutation_rate;
    private double recombination_rate;
    private int copies_of_original;
    private boolean evolve_comparators;

    public GeneticPopulation(Configuration config) {
        this.config = config;
        this.size = 100;
        this.mutation_rate = -1;
        this.recombination_rate = -1.0;
        this.copies_of_original = 0;
        this.evolve_comparators = true;
    }

    public void create() {
        int ix;
        GeneticConfiguration cfg = new GeneticConfiguration(this.config, this.mutation_rate, this.recombination_rate, this.evolve_comparators);
        this.population = new ArrayList<GeneticConfiguration>(this.size);
        for (ix = 0; ix < this.copies_of_original; ++ix) {
            this.population.add(cfg.makeCopy());
        }
        while (ix < this.size) {
            this.population.add(cfg.makeRandomCopy());
            ++ix;
        }
    }

    public List<GeneticConfiguration> getConfigs() {
        return this.population;
    }

    public void setNewGeneration(List<GeneticConfiguration> nextgen) {
        this.population = nextgen;
    }

    public void sort() {
        Collections.sort(this.population);
        for (int ix = 0; ix < this.population.size(); ++ix) {
            this.population.get(ix).setRank(ix + 1);
        }
    }

    public GeneticConfiguration getBestConfiguration() {
        return this.population.get(0);
    }

    public GeneticConfiguration getWorstConfiguration() {
        return this.population.get(this.population.size() - 1);
    }

    public GeneticConfiguration pickRandomConfig() {
        return this.population.get((int)Math.random() * this.population.size());
    }

    public GeneticConfiguration runTournament(int k) {
        GeneticConfiguration best = this.pickRandomConfig();
        for (int ix = 1; ix < k; ++ix) {
            GeneticConfiguration candidate = this.pickRandomConfig();
            if (!(candidate.getFNumber() > best.getFNumber())) continue;
            best = candidate;
        }
        return best;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setMutationRate(int mutation_rate) {
        this.mutation_rate = mutation_rate;
    }

    public void setRecombinationRate(double recombination_rate) {
        this.recombination_rate = recombination_rate;
    }

    public void setEvolveComparators(boolean evolve_comparators) {
        this.evolve_comparators = evolve_comparators;
    }

    public void setCopiesOfOriginal(int copies) {
        this.copies_of_original = copies;
    }

    public int size() {
        return this.size;
    }
}

