"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Secrets = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * Secrets required for GitHub runners operation.
 */
class Secrets extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.webhook = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'Webhook', {
            generateSecretString: {
                secretStringTemplate: '{}',
                generateStringKey: 'webhookSecret',
                includeSpace: false,
                excludePunctuation: true,
            },
        });
        this.github = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'GitHub', {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({
                    domain: 'github.com',
                    appId: '',
                    personalAuthToken: '',
                }),
                generateStringKey: 'dummy',
                includeSpace: false,
                excludePunctuation: true,
            },
        });
        // we create a separate secret for the private key because putting it in JSON secret is hard for the user
        this.githubPrivateKey = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'GitHub Private Key', {
            secretStringValue: cdk.SecretValue.unsafePlainText('-----BEGIN RSA PRIVATE KEY-----\n...\n-----END RSA PRIVATE KEY-----'),
        });
        this.setup = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'Setup', {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({
                    token: '',
                }),
                generateStringKey: 'token',
                includeSpace: false,
                excludePunctuation: true,
            },
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
Secrets[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.Secrets", version: "0.9.2" };
exports.Secrets = Secrets;
//# sourceMappingURL=data:application/json;base64,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