"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultBaseDockerImage = exports.ContainerRecipe = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const common_1 = require("./common");
const common_2 = require("../../common");
const common_3 = require("../common");
/**
 * Image builder recipe for a Docker container image.
 *
 * @internal
 */
class ContainerRecipe extends common_1.ImageBuilderObjectBase {
    constructor(scope, id, props) {
        super(scope, id);
        const name = (0, common_3.uniqueImageBuilderName)(this);
        let components = props.components.map(component => {
            return {
                componentArn: component.arn,
            };
        });
        const recipe = new aws_cdk_lib_1.aws_imagebuilder.CfnContainerRecipe(this, 'Recipe', {
            name: name,
            version: this.version('ContainerRecipe', name, {
                platform: props.platform,
                components,
                dockerfileTemplate: props.dockerfileTemplate,
            }),
            parentImage: props.parentImage ?? 'mcr.microsoft.com/windows/servercore:ltsc2019-amd64',
            components,
            containerType: 'DOCKER',
            targetRepository: {
                service: 'ECR',
                repositoryName: props.targetRepository.repositoryName,
            },
            dockerfileTemplateData: props.dockerfileTemplate,
        });
        this.arn = recipe.attrArn;
        this.name = name;
    }
}
exports.ContainerRecipe = ContainerRecipe;
/**
 * Default base Docker image for given OS.
 *
 * @internal
 */
function defaultBaseDockerImage(os) {
    if (os.is(common_2.Os.WINDOWS)) {
        return 'mcr.microsoft.com/windows/servercore:ltsc2019-amd64';
    }
    else if (os.is(common_2.Os.LINUX_UBUNTU)) {
        return 'public.ecr.aws/lts/ubuntu:22.04';
    }
    else if (os.is(common_2.Os.LINUX_AMAZON_2)) {
        return 'public.ecr.aws/amazonlinux/amazonlinux:2';
    }
    else {
        throw new Error(`OS ${os.name} not supported for Docker runner image`);
    }
}
exports.defaultBaseDockerImage = defaultBaseDockerImage;
//# sourceMappingURL=data:application/json;base64,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