import { aws_ec2 as ec2 } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { ImageBuilderComponent } from './builder';
import { ImageBuilderObjectBase } from './common';
import { Architecture, Os } from '../../common';
/**
 * Properties for AmiRecipe construct.
 */
interface AmiRecipeProperties {
    /**
     * Target platform. Must match builder platform.
     */
    readonly platform: 'Linux' | 'Windows';
    /**
     * Target architecture. Must match builder platform.
     */
    readonly architecture: Architecture;
    /**
     * Base AMI to use for the new runner AMI.
     */
    readonly baseAmi: string;
    /**
     * Components to add to target container image.
     */
    readonly components: ImageBuilderComponent[];
}
/**
 * Image builder recipe for Amazon Machine Image (AMI).
 *
 * @internal
 */
export declare class AmiRecipe extends ImageBuilderObjectBase {
    readonly arn: string;
    readonly name: string;
    constructor(scope: Construct, id: string, props: AmiRecipeProperties);
}
/**
 * Default base AMI for given OS and architecture.
 *
 * @internal
 */
export declare function defaultBaseAmi(os: Os, architecture: Architecture): ec2.IMachineImage;
export {};
