"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunnerImageBuilder = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_image_builder_1 = require("./aws-image-builder");
const codebuild_1 = require("./codebuild");
const common_1 = require("./common");
const common_2 = require("../common");
/**
 * GitHub Runner image builder. Builds a Docker image or AMI with GitHub Runner and other requirements installed.
 *
 * Images can be customized before passed into the provider by adding or removing components to be installed.
 *
 * Images are rebuilt every week by default to ensure that the latest security patches are applied.
 */
class RunnerImageBuilder extends common_1.RunnerImageBuilderBase {
    /**
     * Create a new image builder based on the provided properties. The implementation will differ based on the OS, architecture, and requested builder type.
     */
    static new(scope, id, props) {
        if (props?.components && props.runnerVersion) {
            aws_cdk_lib_1.Annotations.of(scope).addWarning('runnerVersion is ignored when components are specified. The runner version will be determined by the components.');
        }
        if (props?.builderType === common_1.RunnerImageBuilderType.CODE_BUILD) {
            return new codebuild_1.CodeBuildRunnerImageBuilder(scope, id, props);
        }
        else if (props?.builderType === common_1.RunnerImageBuilderType.AWS_IMAGE_BUILDER) {
            return new aws_image_builder_1.AwsImageBuilderRunnerImageBuilder(scope, id, props);
        }
        const os = props?.os ?? common_2.Os.LINUX_UBUNTU;
        if (os.is(common_2.Os.LINUX_UBUNTU) || os.is(common_2.Os.LINUX_AMAZON_2)) {
            return new codebuild_1.CodeBuildRunnerImageBuilder(scope, id, props);
        }
        else if (os.is(common_2.Os.WINDOWS)) {
            return new aws_image_builder_1.AwsImageBuilderRunnerImageBuilder(scope, id, props);
        }
        else {
            throw new Error(`Unable to find runner image builder implementation for ${os.name}`);
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
RunnerImageBuilder[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.RunnerImageBuilder", version: "0.9.2" };
exports.RunnerImageBuilder = RunnerImageBuilder;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3Byb3ZpZGVycy9pbWFnZS1idWlsZGVycy9hcGkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw2Q0FBMEM7QUFFMUMsMkRBQXdFO0FBQ3hFLDJDQUEwRDtBQUMxRCxxQ0FBbUc7QUFDbkcsc0NBQStCO0FBRS9COzs7Ozs7R0FNRztBQUNILE1BQXNCLGtCQUFtQixTQUFRLCtCQUFzQjtJQUNyRTs7T0FFRztJQUNILE1BQU0sQ0FBQyxHQUFHLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBK0I7UUFDdEUsSUFBSSxLQUFLLEVBQUUsVUFBVSxJQUFJLEtBQUssQ0FBQyxhQUFhLEVBQUU7WUFDNUMseUJBQVcsQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsVUFBVSxDQUFDLGtIQUFrSCxDQUFDLENBQUM7U0FDdEo7UUFFRCxJQUFJLEtBQUssRUFBRSxXQUFXLEtBQUssK0JBQXNCLENBQUMsVUFBVSxFQUFFO1lBQzVELE9BQU8sSUFBSSx1Q0FBMkIsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1NBQzFEO2FBQU0sSUFBSSxLQUFLLEVBQUUsV0FBVyxLQUFLLCtCQUFzQixDQUFDLGlCQUFpQixFQUFFO1lBQzFFLE9BQU8sSUFBSSxxREFBaUMsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1NBQ2hFO1FBRUQsTUFBTSxFQUFFLEdBQUcsS0FBSyxFQUFFLEVBQUUsSUFBSSxXQUFFLENBQUMsWUFBWSxDQUFDO1FBQ3hDLElBQUksRUFBRSxDQUFDLEVBQUUsQ0FBQyxXQUFFLENBQUMsWUFBWSxDQUFDLElBQUksRUFBRSxDQUFDLEVBQUUsQ0FBQyxXQUFFLENBQUMsY0FBYyxDQUFDLEVBQUU7WUFDdEQsT0FBTyxJQUFJLHVDQUEyQixDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7U0FDMUQ7YUFBTSxJQUFJLEVBQUUsQ0FBQyxFQUFFLENBQUMsV0FBRSxDQUFDLE9BQU8sQ0FBQyxFQUFFO1lBQzVCLE9BQU8sSUFBSSxxREFBaUMsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1NBQ2hFO2FBQU07WUFDTCxNQUFNLElBQUksS0FBSyxDQUFDLDBEQUEwRCxFQUFFLENBQUMsSUFBSSxFQUFFLENBQUMsQ0FBQztTQUN0RjtJQUNILENBQUM7Ozs7QUF2Qm1CLGdEQUFrQiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFubm90YXRpb25zIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBBd3NJbWFnZUJ1aWxkZXJSdW5uZXJJbWFnZUJ1aWxkZXIgfSBmcm9tICcuL2F3cy1pbWFnZS1idWlsZGVyJztcbmltcG9ydCB7IENvZGVCdWlsZFJ1bm5lckltYWdlQnVpbGRlciB9IGZyb20gJy4vY29kZWJ1aWxkJztcbmltcG9ydCB7IFJ1bm5lckltYWdlQnVpbGRlckJhc2UsIFJ1bm5lckltYWdlQnVpbGRlclByb3BzLCBSdW5uZXJJbWFnZUJ1aWxkZXJUeXBlIH0gZnJvbSAnLi9jb21tb24nO1xuaW1wb3J0IHsgT3MgfSBmcm9tICcuLi9jb21tb24nO1xuXG4vKipcbiAqIEdpdEh1YiBSdW5uZXIgaW1hZ2UgYnVpbGRlci4gQnVpbGRzIGEgRG9ja2VyIGltYWdlIG9yIEFNSSB3aXRoIEdpdEh1YiBSdW5uZXIgYW5kIG90aGVyIHJlcXVpcmVtZW50cyBpbnN0YWxsZWQuXG4gKlxuICogSW1hZ2VzIGNhbiBiZSBjdXN0b21pemVkIGJlZm9yZSBwYXNzZWQgaW50byB0aGUgcHJvdmlkZXIgYnkgYWRkaW5nIG9yIHJlbW92aW5nIGNvbXBvbmVudHMgdG8gYmUgaW5zdGFsbGVkLlxuICpcbiAqIEltYWdlcyBhcmUgcmVidWlsdCBldmVyeSB3ZWVrIGJ5IGRlZmF1bHQgdG8gZW5zdXJlIHRoYXQgdGhlIGxhdGVzdCBzZWN1cml0eSBwYXRjaGVzIGFyZSBhcHBsaWVkLlxuICovXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgUnVubmVySW1hZ2VCdWlsZGVyIGV4dGVuZHMgUnVubmVySW1hZ2VCdWlsZGVyQmFzZSB7XG4gIC8qKlxuICAgKiBDcmVhdGUgYSBuZXcgaW1hZ2UgYnVpbGRlciBiYXNlZCBvbiB0aGUgcHJvdmlkZWQgcHJvcGVydGllcy4gVGhlIGltcGxlbWVudGF0aW9uIHdpbGwgZGlmZmVyIGJhc2VkIG9uIHRoZSBPUywgYXJjaGl0ZWN0dXJlLCBhbmQgcmVxdWVzdGVkIGJ1aWxkZXIgdHlwZS5cbiAgICovXG4gIHN0YXRpYyBuZXcoc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM/OiBSdW5uZXJJbWFnZUJ1aWxkZXJQcm9wcyk6IFJ1bm5lckltYWdlQnVpbGRlciB7XG4gICAgaWYgKHByb3BzPy5jb21wb25lbnRzICYmIHByb3BzLnJ1bm5lclZlcnNpb24pIHtcbiAgICAgIEFubm90YXRpb25zLm9mKHNjb3BlKS5hZGRXYXJuaW5nKCdydW5uZXJWZXJzaW9uIGlzIGlnbm9yZWQgd2hlbiBjb21wb25lbnRzIGFyZSBzcGVjaWZpZWQuIFRoZSBydW5uZXIgdmVyc2lvbiB3aWxsIGJlIGRldGVybWluZWQgYnkgdGhlIGNvbXBvbmVudHMuJyk7XG4gICAgfVxuXG4gICAgaWYgKHByb3BzPy5idWlsZGVyVHlwZSA9PT0gUnVubmVySW1hZ2VCdWlsZGVyVHlwZS5DT0RFX0JVSUxEKSB7XG4gICAgICByZXR1cm4gbmV3IENvZGVCdWlsZFJ1bm5lckltYWdlQnVpbGRlcihzY29wZSwgaWQsIHByb3BzKTtcbiAgICB9IGVsc2UgaWYgKHByb3BzPy5idWlsZGVyVHlwZSA9PT0gUnVubmVySW1hZ2VCdWlsZGVyVHlwZS5BV1NfSU1BR0VfQlVJTERFUikge1xuICAgICAgcmV0dXJuIG5ldyBBd3NJbWFnZUJ1aWxkZXJSdW5uZXJJbWFnZUJ1aWxkZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG4gICAgfVxuXG4gICAgY29uc3Qgb3MgPSBwcm9wcz8ub3MgPz8gT3MuTElOVVhfVUJVTlRVO1xuICAgIGlmIChvcy5pcyhPcy5MSU5VWF9VQlVOVFUpIHx8IG9zLmlzKE9zLkxJTlVYX0FNQVpPTl8yKSkge1xuICAgICAgcmV0dXJuIG5ldyBDb2RlQnVpbGRSdW5uZXJJbWFnZUJ1aWxkZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG4gICAgfSBlbHNlIGlmIChvcy5pcyhPcy5XSU5ET1dTKSkge1xuICAgICAgcmV0dXJuIG5ldyBBd3NJbWFnZUJ1aWxkZXJSdW5uZXJJbWFnZUJ1aWxkZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgVW5hYmxlIHRvIGZpbmQgcnVubmVyIGltYWdlIGJ1aWxkZXIgaW1wbGVtZW50YXRpb24gZm9yICR7b3MubmFtZX1gKTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==