"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const github_1 = require("./github");
exports.handler = async function (event) {
    const { githubSecrets, octokit } = await (0, github_1.getOctokit)(event.installationId);
    const response = await octokit.rest.actions.createRegistrationTokenForRepo({
        owner: event.owner,
        repo: event.repo,
    });
    return {
        domain: githubSecrets.domain,
        token: response.data.token,
    };
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidG9rZW4tcmV0cmlldmVyLmxhbWJkYS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9sYW1iZGFzL3Rva2VuLXJldHJpZXZlci5sYW1iZGEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxxQ0FBc0M7QUFHdEMsT0FBTyxDQUFDLE9BQU8sR0FBRyxLQUFLLFdBQVcsS0FBOEI7SUFDOUQsTUFBTSxFQUFFLGFBQWEsRUFBRSxPQUFPLEVBQUUsR0FBRyxNQUFNLElBQUEsbUJBQVUsRUFBQyxLQUFLLENBQUMsY0FBYyxDQUFDLENBQUM7SUFFMUUsTUFBTSxRQUFRLEdBQUcsTUFBTSxPQUFPLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyw4QkFBOEIsQ0FBQztRQUN6RSxLQUFLLEVBQUUsS0FBSyxDQUFDLEtBQUs7UUFDbEIsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO0tBQ2pCLENBQUMsQ0FBQztJQUVILE9BQU87UUFDTCxNQUFNLEVBQUUsYUFBYSxDQUFDLE1BQU07UUFDNUIsS0FBSyxFQUFFLFFBQVEsQ0FBQyxJQUFJLENBQUMsS0FBSztLQUMzQixDQUFDO0FBQ0osQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgZ2V0T2N0b2tpdCB9IGZyb20gJy4vZ2l0aHViJztcbmltcG9ydCB7IFN0ZXBGdW5jdGlvbkxhbWJkYUlucHV0IH0gZnJvbSAnLi9oZWxwZXJzJztcblxuZXhwb3J0cy5oYW5kbGVyID0gYXN5bmMgZnVuY3Rpb24gKGV2ZW50OiBTdGVwRnVuY3Rpb25MYW1iZGFJbnB1dCkge1xuICBjb25zdCB7IGdpdGh1YlNlY3JldHMsIG9jdG9raXQgfSA9IGF3YWl0IGdldE9jdG9raXQoZXZlbnQuaW5zdGFsbGF0aW9uSWQpO1xuXG4gIGNvbnN0IHJlc3BvbnNlID0gYXdhaXQgb2N0b2tpdC5yZXN0LmFjdGlvbnMuY3JlYXRlUmVnaXN0cmF0aW9uVG9rZW5Gb3JSZXBvKHtcbiAgICBvd25lcjogZXZlbnQub3duZXIsXG4gICAgcmVwbzogZXZlbnQucmVwbyxcbiAgfSk7XG5cbiAgcmV0dXJuIHtcbiAgICBkb21haW46IGdpdGh1YlNlY3JldHMuZG9tYWluLFxuICAgIHRva2VuOiByZXNwb25zZS5kYXRhLnRva2VuLFxuICB9O1xufTtcbiJdfQ==