"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.customResourceRespond = exports.updateSecretValue = exports.getSecretJsonValue = exports.getSecretValue = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const AWS = require("aws-sdk");
const sm = new AWS.SecretsManager();
async function getSecretValue(arn) {
    if (!arn) {
        throw new Error('Missing secret ARN');
    }
    const secret = await sm.getSecretValue({ SecretId: arn }).promise();
    if (!secret.SecretString) {
        throw new Error(`No SecretString in ${arn}`);
    }
    return secret.SecretString;
}
exports.getSecretValue = getSecretValue;
async function getSecretJsonValue(arn) {
    return JSON.parse(await getSecretValue(arn));
}
exports.getSecretJsonValue = getSecretJsonValue;
async function updateSecretValue(arn, value) {
    if (!arn) {
        throw new Error('Missing secret ARN');
    }
    await sm.updateSecret({ SecretId: arn, SecretString: value }).promise();
}
exports.updateSecretValue = updateSecretValue;
async function customResourceRespond(event, responseStatus, reason, physicalResourceId, data) {
    const responseBody = JSON.stringify({
        Status: responseStatus,
        Reason: reason,
        PhysicalResourceId: physicalResourceId,
        StackId: event.StackId,
        RequestId: event.RequestId,
        LogicalResourceId: event.LogicalResourceId,
        NoEcho: false,
        Data: data,
    });
    console.log('Responding', responseBody);
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    const parsedUrl = require('url').parse(event.ResponseURL);
    const requestOptions = {
        hostname: parsedUrl.hostname,
        path: parsedUrl.path,
        method: 'PUT',
        headers: {
            'content-type': '',
            'content-length': responseBody.length,
        },
    };
    return new Promise((resolve, reject) => {
        try {
            // eslint-disable-next-line @typescript-eslint/no-require-imports
            const request = require('https').request(requestOptions, resolve);
            request.on('error', reject);
            request.write(responseBody);
            request.end();
        }
        catch (e) {
            reject(e);
        }
    });
}
exports.customResourceRespond = customResourceRespond;
//# sourceMappingURL=data:application/json;base64,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