"""
Setup script for types-boto3.

Copyright 2024 Vlad Emelianov
"""

from pathlib import Path

from setuptools import setup  # type: ignore

LONG_DESCRIPTION = (Path(__file__).parent / "README.md").read_text()


setup(
    name="types-boto3",
    version="1.35.74",
    packages=["boto3-stubs"],
    url="https://github.com/youtype/mypy_boto3_builder",
    license="MIT License",
    author="Vlad Emelianov",
    author_email="vlad.emelianov.nz@gmail.com",
    description="Type annotations for boto3 1.35.74 generated with mypy-boto3-builder 8.5.0",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "Environment :: Console",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Programming Language :: Python :: 3.13",
        "Programming Language :: Python :: 3.14",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: Implementation :: CPython",
        "Typing :: Stubs Only",
    ],
    keywords="boto3 boto3-stubs type-annotations typeshed autocomplete",
    long_description=LONG_DESCRIPTION,
    long_description_content_type="text/markdown",
    package_data={"boto3-stubs": ["py.typed", "*.pyi", "*/*.pyi"]},
    python_requires=">=3.8",
    project_urls={
        "Documentation": "https://youtype.github.io/types_boto3_docs/",
        "Source": "https://github.com/youtype/mypy_boto3_builder",
        "Tracker": "https://github.com/youtype/mypy_boto3_builder/issues",
    },
    install_requires=[
        "botocore-stubs",
        "types-s3transfer",
        'typing-extensions>=4.1.0; python_version<"3.12"',
    ],
    extras_require={
        "full": [
            "types-boto3-full",
        ],
        "all": [
            "types-boto3-accessanalyzer>=1.35.0, <1.36.0",
            "types-boto3-account>=1.35.0, <1.36.0",
            "types-boto3-acm>=1.35.0, <1.36.0",
            "types-boto3-acm-pca>=1.35.0, <1.36.0",
            "types-boto3-amp>=1.35.0, <1.36.0",
            "types-boto3-amplify>=1.35.0, <1.36.0",
            "types-boto3-amplifybackend>=1.35.0, <1.36.0",
            "types-boto3-amplifyuibuilder>=1.35.0, <1.36.0",
            "types-boto3-apigateway>=1.35.0, <1.36.0",
            "types-boto3-apigatewaymanagementapi>=1.35.0, <1.36.0",
            "types-boto3-apigatewayv2>=1.35.0, <1.36.0",
            "types-boto3-appconfig>=1.35.0, <1.36.0",
            "types-boto3-appconfigdata>=1.35.0, <1.36.0",
            "types-boto3-appfabric>=1.35.0, <1.36.0",
            "types-boto3-appflow>=1.35.0, <1.36.0",
            "types-boto3-appintegrations>=1.35.0, <1.36.0",
            "types-boto3-application-autoscaling>=1.35.0, <1.36.0",
            "types-boto3-application-insights>=1.35.0, <1.36.0",
            "types-boto3-application-signals>=1.35.0, <1.36.0",
            "types-boto3-applicationcostprofiler>=1.35.0, <1.36.0",
            "types-boto3-appmesh>=1.35.0, <1.36.0",
            "types-boto3-apprunner>=1.35.0, <1.36.0",
            "types-boto3-appstream>=1.35.0, <1.36.0",
            "types-boto3-appsync>=1.35.0, <1.36.0",
            "types-boto3-apptest>=1.35.0, <1.36.0",
            "types-boto3-arc-zonal-shift>=1.35.0, <1.36.0",
            "types-boto3-artifact>=1.35.0, <1.36.0",
            "types-boto3-athena>=1.35.0, <1.36.0",
            "types-boto3-auditmanager>=1.35.0, <1.36.0",
            "types-boto3-autoscaling>=1.35.0, <1.36.0",
            "types-boto3-autoscaling-plans>=1.35.0, <1.36.0",
            "types-boto3-b2bi>=1.35.0, <1.36.0",
            "types-boto3-backup>=1.35.0, <1.36.0",
            "types-boto3-backup-gateway>=1.35.0, <1.36.0",
            "types-boto3-batch>=1.35.0, <1.36.0",
            "types-boto3-bcm-data-exports>=1.35.0, <1.36.0",
            "types-boto3-bcm-pricing-calculator>=1.35.0, <1.36.0",
            "types-boto3-bedrock>=1.35.0, <1.36.0",
            "types-boto3-bedrock-agent>=1.35.0, <1.36.0",
            "types-boto3-bedrock-agent-runtime>=1.35.0, <1.36.0",
            "types-boto3-bedrock-runtime>=1.35.0, <1.36.0",
            "types-boto3-billing>=1.35.0, <1.36.0",
            "types-boto3-billingconductor>=1.35.0, <1.36.0",
            "types-boto3-braket>=1.35.0, <1.36.0",
            "types-boto3-budgets>=1.35.0, <1.36.0",
            "types-boto3-ce>=1.35.0, <1.36.0",
            "types-boto3-chatbot>=1.35.0, <1.36.0",
            "types-boto3-chime>=1.35.0, <1.36.0",
            "types-boto3-chime-sdk-identity>=1.35.0, <1.36.0",
            "types-boto3-chime-sdk-media-pipelines>=1.35.0, <1.36.0",
            "types-boto3-chime-sdk-meetings>=1.35.0, <1.36.0",
            "types-boto3-chime-sdk-messaging>=1.35.0, <1.36.0",
            "types-boto3-chime-sdk-voice>=1.35.0, <1.36.0",
            "types-boto3-cleanrooms>=1.35.0, <1.36.0",
            "types-boto3-cleanroomsml>=1.35.0, <1.36.0",
            "types-boto3-cloud9>=1.35.0, <1.36.0",
            "types-boto3-cloudcontrol>=1.35.0, <1.36.0",
            "types-boto3-clouddirectory>=1.35.0, <1.36.0",
            "types-boto3-cloudformation>=1.35.0, <1.36.0",
            "types-boto3-cloudfront>=1.35.0, <1.36.0",
            "types-boto3-cloudfront-keyvaluestore>=1.35.0, <1.36.0",
            "types-boto3-cloudhsm>=1.35.0, <1.36.0",
            "types-boto3-cloudhsmv2>=1.35.0, <1.36.0",
            "types-boto3-cloudsearch>=1.35.0, <1.36.0",
            "types-boto3-cloudsearchdomain>=1.35.0, <1.36.0",
            "types-boto3-cloudtrail>=1.35.0, <1.36.0",
            "types-boto3-cloudtrail-data>=1.35.0, <1.36.0",
            "types-boto3-cloudwatch>=1.35.0, <1.36.0",
            "types-boto3-codeartifact>=1.35.0, <1.36.0",
            "types-boto3-codebuild>=1.35.0, <1.36.0",
            "types-boto3-codecatalyst>=1.35.0, <1.36.0",
            "types-boto3-codecommit>=1.35.0, <1.36.0",
            "types-boto3-codeconnections>=1.35.0, <1.36.0",
            "types-boto3-codedeploy>=1.35.0, <1.36.0",
            "types-boto3-codeguru-reviewer>=1.35.0, <1.36.0",
            "types-boto3-codeguru-security>=1.35.0, <1.36.0",
            "types-boto3-codeguruprofiler>=1.35.0, <1.36.0",
            "types-boto3-codepipeline>=1.35.0, <1.36.0",
            "types-boto3-codestar-connections>=1.35.0, <1.36.0",
            "types-boto3-codestar-notifications>=1.35.0, <1.36.0",
            "types-boto3-cognito-identity>=1.35.0, <1.36.0",
            "types-boto3-cognito-idp>=1.35.0, <1.36.0",
            "types-boto3-cognito-sync>=1.35.0, <1.36.0",
            "types-boto3-comprehend>=1.35.0, <1.36.0",
            "types-boto3-comprehendmedical>=1.35.0, <1.36.0",
            "types-boto3-compute-optimizer>=1.35.0, <1.36.0",
            "types-boto3-config>=1.35.0, <1.36.0",
            "types-boto3-connect>=1.35.0, <1.36.0",
            "types-boto3-connect-contact-lens>=1.35.0, <1.36.0",
            "types-boto3-connectcampaigns>=1.35.0, <1.36.0",
            "types-boto3-connectcampaignsv2>=1.35.0, <1.36.0",
            "types-boto3-connectcases>=1.35.0, <1.36.0",
            "types-boto3-connectparticipant>=1.35.0, <1.36.0",
            "types-boto3-controlcatalog>=1.35.0, <1.36.0",
            "types-boto3-controltower>=1.35.0, <1.36.0",
            "types-boto3-cost-optimization-hub>=1.35.0, <1.36.0",
            "types-boto3-cur>=1.35.0, <1.36.0",
            "types-boto3-customer-profiles>=1.35.0, <1.36.0",
            "types-boto3-databrew>=1.35.0, <1.36.0",
            "types-boto3-dataexchange>=1.35.0, <1.36.0",
            "types-boto3-datapipeline>=1.35.0, <1.36.0",
            "types-boto3-datasync>=1.35.0, <1.36.0",
            "types-boto3-datazone>=1.35.0, <1.36.0",
            "types-boto3-dax>=1.35.0, <1.36.0",
            "types-boto3-deadline>=1.35.0, <1.36.0",
            "types-boto3-detective>=1.35.0, <1.36.0",
            "types-boto3-devicefarm>=1.35.0, <1.36.0",
            "types-boto3-devops-guru>=1.35.0, <1.36.0",
            "types-boto3-directconnect>=1.35.0, <1.36.0",
            "types-boto3-discovery>=1.35.0, <1.36.0",
            "types-boto3-dlm>=1.35.0, <1.36.0",
            "types-boto3-dms>=1.35.0, <1.36.0",
            "types-boto3-docdb>=1.35.0, <1.36.0",
            "types-boto3-docdb-elastic>=1.35.0, <1.36.0",
            "types-boto3-drs>=1.35.0, <1.36.0",
            "types-boto3-ds>=1.35.0, <1.36.0",
            "types-boto3-ds-data>=1.35.0, <1.36.0",
            "types-boto3-dsql>=1.35.0, <1.36.0",
            "types-boto3-dynamodb>=1.35.0, <1.36.0",
            "types-boto3-dynamodbstreams>=1.35.0, <1.36.0",
            "types-boto3-ebs>=1.35.0, <1.36.0",
            "types-boto3-ec2>=1.35.0, <1.36.0",
            "types-boto3-ec2-instance-connect>=1.35.0, <1.36.0",
            "types-boto3-ecr>=1.35.0, <1.36.0",
            "types-boto3-ecr-public>=1.35.0, <1.36.0",
            "types-boto3-ecs>=1.35.0, <1.36.0",
            "types-boto3-efs>=1.35.0, <1.36.0",
            "types-boto3-eks>=1.35.0, <1.36.0",
            "types-boto3-eks-auth>=1.35.0, <1.36.0",
            "types-boto3-elastic-inference>=1.35.0, <1.36.0",
            "types-boto3-elasticache>=1.35.0, <1.36.0",
            "types-boto3-elasticbeanstalk>=1.35.0, <1.36.0",
            "types-boto3-elastictranscoder>=1.35.0, <1.36.0",
            "types-boto3-elb>=1.35.0, <1.36.0",
            "types-boto3-elbv2>=1.35.0, <1.36.0",
            "types-boto3-emr>=1.35.0, <1.36.0",
            "types-boto3-emr-containers>=1.35.0, <1.36.0",
            "types-boto3-emr-serverless>=1.35.0, <1.36.0",
            "types-boto3-entityresolution>=1.35.0, <1.36.0",
            "types-boto3-es>=1.35.0, <1.36.0",
            "types-boto3-events>=1.35.0, <1.36.0",
            "types-boto3-evidently>=1.35.0, <1.36.0",
            "types-boto3-finspace>=1.35.0, <1.36.0",
            "types-boto3-finspace-data>=1.35.0, <1.36.0",
            "types-boto3-firehose>=1.35.0, <1.36.0",
            "types-boto3-fis>=1.35.0, <1.36.0",
            "types-boto3-fms>=1.35.0, <1.36.0",
            "types-boto3-forecast>=1.35.0, <1.36.0",
            "types-boto3-forecastquery>=1.35.0, <1.36.0",
            "types-boto3-frauddetector>=1.35.0, <1.36.0",
            "types-boto3-freetier>=1.35.0, <1.36.0",
            "types-boto3-fsx>=1.35.0, <1.36.0",
            "types-boto3-gamelift>=1.35.0, <1.36.0",
            "types-boto3-geo-maps>=1.35.0, <1.36.0",
            "types-boto3-geo-places>=1.35.0, <1.36.0",
            "types-boto3-geo-routes>=1.35.0, <1.36.0",
            "types-boto3-glacier>=1.35.0, <1.36.0",
            "types-boto3-globalaccelerator>=1.35.0, <1.36.0",
            "types-boto3-glue>=1.35.0, <1.36.0",
            "types-boto3-grafana>=1.35.0, <1.36.0",
            "types-boto3-greengrass>=1.35.0, <1.36.0",
            "types-boto3-greengrassv2>=1.35.0, <1.36.0",
            "types-boto3-groundstation>=1.35.0, <1.36.0",
            "types-boto3-guardduty>=1.35.0, <1.36.0",
            "types-boto3-health>=1.35.0, <1.36.0",
            "types-boto3-healthlake>=1.35.0, <1.36.0",
            "types-boto3-iam>=1.35.0, <1.36.0",
            "types-boto3-identitystore>=1.35.0, <1.36.0",
            "types-boto3-imagebuilder>=1.35.0, <1.36.0",
            "types-boto3-importexport>=1.35.0, <1.36.0",
            "types-boto3-inspector>=1.35.0, <1.36.0",
            "types-boto3-inspector-scan>=1.35.0, <1.36.0",
            "types-boto3-inspector2>=1.35.0, <1.36.0",
            "types-boto3-internetmonitor>=1.35.0, <1.36.0",
            "types-boto3-invoicing>=1.35.0, <1.36.0",
            "types-boto3-iot>=1.35.0, <1.36.0",
            "types-boto3-iot-data>=1.35.0, <1.36.0",
            "types-boto3-iot-jobs-data>=1.35.0, <1.36.0",
            "types-boto3-iot1click-devices>=1.35.0, <1.36.0",
            "types-boto3-iot1click-projects>=1.35.0, <1.36.0",
            "types-boto3-iotanalytics>=1.35.0, <1.36.0",
            "types-boto3-iotdeviceadvisor>=1.35.0, <1.36.0",
            "types-boto3-iotevents>=1.35.0, <1.36.0",
            "types-boto3-iotevents-data>=1.35.0, <1.36.0",
            "types-boto3-iotfleethub>=1.35.0, <1.36.0",
            "types-boto3-iotfleetwise>=1.35.0, <1.36.0",
            "types-boto3-iotsecuretunneling>=1.35.0, <1.36.0",
            "types-boto3-iotsitewise>=1.35.0, <1.36.0",
            "types-boto3-iotthingsgraph>=1.35.0, <1.36.0",
            "types-boto3-iottwinmaker>=1.35.0, <1.36.0",
            "types-boto3-iotwireless>=1.35.0, <1.36.0",
            "types-boto3-ivs>=1.35.0, <1.36.0",
            "types-boto3-ivs-realtime>=1.35.0, <1.36.0",
            "types-boto3-ivschat>=1.35.0, <1.36.0",
            "types-boto3-kafka>=1.35.0, <1.36.0",
            "types-boto3-kafkaconnect>=1.35.0, <1.36.0",
            "types-boto3-kendra>=1.35.0, <1.36.0",
            "types-boto3-kendra-ranking>=1.35.0, <1.36.0",
            "types-boto3-keyspaces>=1.35.0, <1.36.0",
            "types-boto3-kinesis>=1.35.0, <1.36.0",
            "types-boto3-kinesis-video-archived-media>=1.35.0, <1.36.0",
            "types-boto3-kinesis-video-media>=1.35.0, <1.36.0",
            "types-boto3-kinesis-video-signaling>=1.35.0, <1.36.0",
            "types-boto3-kinesis-video-webrtc-storage>=1.35.0, <1.36.0",
            "types-boto3-kinesisanalytics>=1.35.0, <1.36.0",
            "types-boto3-kinesisanalyticsv2>=1.35.0, <1.36.0",
            "types-boto3-kinesisvideo>=1.35.0, <1.36.0",
            "types-boto3-kms>=1.35.0, <1.36.0",
            "types-boto3-lakeformation>=1.35.0, <1.36.0",
            "types-boto3-lambda>=1.35.0, <1.36.0",
            "types-boto3-launch-wizard>=1.35.0, <1.36.0",
            "types-boto3-lex-models>=1.35.0, <1.36.0",
            "types-boto3-lex-runtime>=1.35.0, <1.36.0",
            "types-boto3-lexv2-models>=1.35.0, <1.36.0",
            "types-boto3-lexv2-runtime>=1.35.0, <1.36.0",
            "types-boto3-license-manager>=1.35.0, <1.36.0",
            "types-boto3-license-manager-linux-subscriptions>=1.35.0, <1.36.0",
            "types-boto3-license-manager-user-subscriptions>=1.35.0, <1.36.0",
            "types-boto3-lightsail>=1.35.0, <1.36.0",
            "types-boto3-location>=1.35.0, <1.36.0",
            "types-boto3-logs>=1.35.0, <1.36.0",
            "types-boto3-lookoutequipment>=1.35.0, <1.36.0",
            "types-boto3-lookoutmetrics>=1.35.0, <1.36.0",
            "types-boto3-lookoutvision>=1.35.0, <1.36.0",
            "types-boto3-m2>=1.35.0, <1.36.0",
            "types-boto3-machinelearning>=1.35.0, <1.36.0",
            "types-boto3-macie2>=1.35.0, <1.36.0",
            "types-boto3-mailmanager>=1.35.0, <1.36.0",
            "types-boto3-managedblockchain>=1.35.0, <1.36.0",
            "types-boto3-managedblockchain-query>=1.35.0, <1.36.0",
            "types-boto3-marketplace-agreement>=1.35.0, <1.36.0",
            "types-boto3-marketplace-catalog>=1.35.0, <1.36.0",
            "types-boto3-marketplace-deployment>=1.35.0, <1.36.0",
            "types-boto3-marketplace-entitlement>=1.35.0, <1.36.0",
            "types-boto3-marketplace-reporting>=1.35.0, <1.36.0",
            "types-boto3-marketplacecommerceanalytics>=1.35.0, <1.36.0",
            "types-boto3-mediaconnect>=1.35.0, <1.36.0",
            "types-boto3-mediaconvert>=1.35.0, <1.36.0",
            "types-boto3-medialive>=1.35.0, <1.36.0",
            "types-boto3-mediapackage>=1.35.0, <1.36.0",
            "types-boto3-mediapackage-vod>=1.35.0, <1.36.0",
            "types-boto3-mediapackagev2>=1.35.0, <1.36.0",
            "types-boto3-mediastore>=1.35.0, <1.36.0",
            "types-boto3-mediastore-data>=1.35.0, <1.36.0",
            "types-boto3-mediatailor>=1.35.0, <1.36.0",
            "types-boto3-medical-imaging>=1.35.0, <1.36.0",
            "types-boto3-memorydb>=1.35.0, <1.36.0",
            "types-boto3-meteringmarketplace>=1.35.0, <1.36.0",
            "types-boto3-mgh>=1.35.0, <1.36.0",
            "types-boto3-mgn>=1.35.0, <1.36.0",
            "types-boto3-migration-hub-refactor-spaces>=1.35.0, <1.36.0",
            "types-boto3-migrationhub-config>=1.35.0, <1.36.0",
            "types-boto3-migrationhuborchestrator>=1.35.0, <1.36.0",
            "types-boto3-migrationhubstrategy>=1.35.0, <1.36.0",
            "types-boto3-mq>=1.35.0, <1.36.0",
            "types-boto3-mturk>=1.35.0, <1.36.0",
            "types-boto3-mwaa>=1.35.0, <1.36.0",
            "types-boto3-neptune>=1.35.0, <1.36.0",
            "types-boto3-neptune-graph>=1.35.0, <1.36.0",
            "types-boto3-neptunedata>=1.35.0, <1.36.0",
            "types-boto3-network-firewall>=1.35.0, <1.36.0",
            "types-boto3-networkflowmonitor>=1.35.0, <1.36.0",
            "types-boto3-networkmanager>=1.35.0, <1.36.0",
            "types-boto3-networkmonitor>=1.35.0, <1.36.0",
            "types-boto3-notifications>=1.35.0, <1.36.0",
            "types-boto3-notificationscontacts>=1.35.0, <1.36.0",
            "types-boto3-oam>=1.35.0, <1.36.0",
            "types-boto3-observabilityadmin>=1.35.0, <1.36.0",
            "types-boto3-omics>=1.35.0, <1.36.0",
            "types-boto3-opensearch>=1.35.0, <1.36.0",
            "types-boto3-opensearchserverless>=1.35.0, <1.36.0",
            "types-boto3-opsworks>=1.35.0, <1.36.0",
            "types-boto3-opsworkscm>=1.35.0, <1.36.0",
            "types-boto3-organizations>=1.35.0, <1.36.0",
            "types-boto3-osis>=1.35.0, <1.36.0",
            "types-boto3-outposts>=1.35.0, <1.36.0",
            "types-boto3-panorama>=1.35.0, <1.36.0",
            "types-boto3-partnercentral-selling>=1.35.0, <1.36.0",
            "types-boto3-payment-cryptography>=1.35.0, <1.36.0",
            "types-boto3-payment-cryptography-data>=1.35.0, <1.36.0",
            "types-boto3-pca-connector-ad>=1.35.0, <1.36.0",
            "types-boto3-pca-connector-scep>=1.35.0, <1.36.0",
            "types-boto3-pcs>=1.35.0, <1.36.0",
            "types-boto3-personalize>=1.35.0, <1.36.0",
            "types-boto3-personalize-events>=1.35.0, <1.36.0",
            "types-boto3-personalize-runtime>=1.35.0, <1.36.0",
            "types-boto3-pi>=1.35.0, <1.36.0",
            "types-boto3-pinpoint>=1.35.0, <1.36.0",
            "types-boto3-pinpoint-email>=1.35.0, <1.36.0",
            "types-boto3-pinpoint-sms-voice>=1.35.0, <1.36.0",
            "types-boto3-pinpoint-sms-voice-v2>=1.35.0, <1.36.0",
            "types-boto3-pipes>=1.35.0, <1.36.0",
            "types-boto3-polly>=1.35.0, <1.36.0",
            "types-boto3-pricing>=1.35.0, <1.36.0",
            "types-boto3-privatenetworks>=1.35.0, <1.36.0",
            "types-boto3-proton>=1.35.0, <1.36.0",
            "types-boto3-qapps>=1.35.0, <1.36.0",
            "types-boto3-qbusiness>=1.35.0, <1.36.0",
            "types-boto3-qconnect>=1.35.0, <1.36.0",
            "types-boto3-qldb>=1.35.0, <1.36.0",
            "types-boto3-qldb-session>=1.35.0, <1.36.0",
            "types-boto3-quicksight>=1.35.0, <1.36.0",
            "types-boto3-ram>=1.35.0, <1.36.0",
            "types-boto3-rbin>=1.35.0, <1.36.0",
            "types-boto3-rds>=1.35.0, <1.36.0",
            "types-boto3-rds-data>=1.35.0, <1.36.0",
            "types-boto3-redshift>=1.35.0, <1.36.0",
            "types-boto3-redshift-data>=1.35.0, <1.36.0",
            "types-boto3-redshift-serverless>=1.35.0, <1.36.0",
            "types-boto3-rekognition>=1.35.0, <1.36.0",
            "types-boto3-repostspace>=1.35.0, <1.36.0",
            "types-boto3-resiliencehub>=1.35.0, <1.36.0",
            "types-boto3-resource-explorer-2>=1.35.0, <1.36.0",
            "types-boto3-resource-groups>=1.35.0, <1.36.0",
            "types-boto3-resourcegroupstaggingapi>=1.35.0, <1.36.0",
            "types-boto3-robomaker>=1.35.0, <1.36.0",
            "types-boto3-rolesanywhere>=1.35.0, <1.36.0",
            "types-boto3-route53>=1.35.0, <1.36.0",
            "types-boto3-route53-recovery-cluster>=1.35.0, <1.36.0",
            "types-boto3-route53-recovery-control-config>=1.35.0, <1.36.0",
            "types-boto3-route53-recovery-readiness>=1.35.0, <1.36.0",
            "types-boto3-route53domains>=1.35.0, <1.36.0",
            "types-boto3-route53profiles>=1.35.0, <1.36.0",
            "types-boto3-route53resolver>=1.35.0, <1.36.0",
            "types-boto3-rum>=1.35.0, <1.36.0",
            "types-boto3-s3>=1.35.0, <1.36.0",
            "types-boto3-s3control>=1.35.0, <1.36.0",
            "types-boto3-s3outposts>=1.35.0, <1.36.0",
            "types-boto3-s3tables>=1.35.0, <1.36.0",
            "types-boto3-sagemaker>=1.35.0, <1.36.0",
            "types-boto3-sagemaker-a2i-runtime>=1.35.0, <1.36.0",
            "types-boto3-sagemaker-edge>=1.35.0, <1.36.0",
            "types-boto3-sagemaker-featurestore-runtime>=1.35.0, <1.36.0",
            "types-boto3-sagemaker-geospatial>=1.35.0, <1.36.0",
            "types-boto3-sagemaker-metrics>=1.35.0, <1.36.0",
            "types-boto3-sagemaker-runtime>=1.35.0, <1.36.0",
            "types-boto3-savingsplans>=1.35.0, <1.36.0",
            "types-boto3-scheduler>=1.35.0, <1.36.0",
            "types-boto3-schemas>=1.35.0, <1.36.0",
            "types-boto3-sdb>=1.35.0, <1.36.0",
            "types-boto3-secretsmanager>=1.35.0, <1.36.0",
            "types-boto3-security-ir>=1.35.0, <1.36.0",
            "types-boto3-securityhub>=1.35.0, <1.36.0",
            "types-boto3-securitylake>=1.35.0, <1.36.0",
            "types-boto3-serverlessrepo>=1.35.0, <1.36.0",
            "types-boto3-service-quotas>=1.35.0, <1.36.0",
            "types-boto3-servicecatalog>=1.35.0, <1.36.0",
            "types-boto3-servicecatalog-appregistry>=1.35.0, <1.36.0",
            "types-boto3-servicediscovery>=1.35.0, <1.36.0",
            "types-boto3-ses>=1.35.0, <1.36.0",
            "types-boto3-sesv2>=1.35.0, <1.36.0",
            "types-boto3-shield>=1.35.0, <1.36.0",
            "types-boto3-signer>=1.35.0, <1.36.0",
            "types-boto3-simspaceweaver>=1.35.0, <1.36.0",
            "types-boto3-sms>=1.35.0, <1.36.0",
            "types-boto3-sms-voice>=1.35.0, <1.36.0",
            "types-boto3-snow-device-management>=1.35.0, <1.36.0",
            "types-boto3-snowball>=1.35.0, <1.36.0",
            "types-boto3-sns>=1.35.0, <1.36.0",
            "types-boto3-socialmessaging>=1.35.0, <1.36.0",
            "types-boto3-sqs>=1.35.0, <1.36.0",
            "types-boto3-ssm>=1.35.0, <1.36.0",
            "types-boto3-ssm-contacts>=1.35.0, <1.36.0",
            "types-boto3-ssm-incidents>=1.35.0, <1.36.0",
            "types-boto3-ssm-quicksetup>=1.35.0, <1.36.0",
            "types-boto3-ssm-sap>=1.35.0, <1.36.0",
            "types-boto3-sso>=1.35.0, <1.36.0",
            "types-boto3-sso-admin>=1.35.0, <1.36.0",
            "types-boto3-sso-oidc>=1.35.0, <1.36.0",
            "types-boto3-stepfunctions>=1.35.0, <1.36.0",
            "types-boto3-storagegateway>=1.35.0, <1.36.0",
            "types-boto3-sts>=1.35.0, <1.36.0",
            "types-boto3-supplychain>=1.35.0, <1.36.0",
            "types-boto3-support>=1.35.0, <1.36.0",
            "types-boto3-support-app>=1.35.0, <1.36.0",
            "types-boto3-swf>=1.35.0, <1.36.0",
            "types-boto3-synthetics>=1.35.0, <1.36.0",
            "types-boto3-taxsettings>=1.35.0, <1.36.0",
            "types-boto3-textract>=1.35.0, <1.36.0",
            "types-boto3-timestream-influxdb>=1.35.0, <1.36.0",
            "types-boto3-timestream-query>=1.35.0, <1.36.0",
            "types-boto3-timestream-write>=1.35.0, <1.36.0",
            "types-boto3-tnb>=1.35.0, <1.36.0",
            "types-boto3-transcribe>=1.35.0, <1.36.0",
            "types-boto3-transfer>=1.35.0, <1.36.0",
            "types-boto3-translate>=1.35.0, <1.36.0",
            "types-boto3-trustedadvisor>=1.35.0, <1.36.0",
            "types-boto3-verifiedpermissions>=1.35.0, <1.36.0",
            "types-boto3-voice-id>=1.35.0, <1.36.0",
            "types-boto3-vpc-lattice>=1.35.0, <1.36.0",
            "types-boto3-waf>=1.35.0, <1.36.0",
            "types-boto3-waf-regional>=1.35.0, <1.36.0",
            "types-boto3-wafv2>=1.35.0, <1.36.0",
            "types-boto3-wellarchitected>=1.35.0, <1.36.0",
            "types-boto3-wisdom>=1.35.0, <1.36.0",
            "types-boto3-workdocs>=1.35.0, <1.36.0",
            "types-boto3-workmail>=1.35.0, <1.36.0",
            "types-boto3-workmailmessageflow>=1.35.0, <1.36.0",
            "types-boto3-workspaces>=1.35.0, <1.36.0",
            "types-boto3-workspaces-thin-client>=1.35.0, <1.36.0",
            "types-boto3-workspaces-web>=1.35.0, <1.36.0",
            "types-boto3-xray>=1.35.0, <1.36.0",
        ],
        "essential": [
            "types-boto3-cloudformation>=1.35.0, <1.36.0",
            "types-boto3-dynamodb>=1.35.0, <1.36.0",
            "types-boto3-ec2>=1.35.0, <1.36.0",
            "types-boto3-lambda>=1.35.0, <1.36.0",
            "types-boto3-rds>=1.35.0, <1.36.0",
            "types-boto3-s3>=1.35.0, <1.36.0",
            "types-boto3-sqs>=1.35.0, <1.36.0",
        ],
        "boto3": ["boto3==1.35.74", "botocore==1.35.74"],
        "accessanalyzer": ["types-boto3-accessanalyzer>=1.35.0, <1.36.0"],
        "account": ["types-boto3-account>=1.35.0, <1.36.0"],
        "acm": ["types-boto3-acm>=1.35.0, <1.36.0"],
        "acm-pca": ["types-boto3-acm-pca>=1.35.0, <1.36.0"],
        "amp": ["types-boto3-amp>=1.35.0, <1.36.0"],
        "amplify": ["types-boto3-amplify>=1.35.0, <1.36.0"],
        "amplifybackend": ["types-boto3-amplifybackend>=1.35.0, <1.36.0"],
        "amplifyuibuilder": ["types-boto3-amplifyuibuilder>=1.35.0, <1.36.0"],
        "apigateway": ["types-boto3-apigateway>=1.35.0, <1.36.0"],
        "apigatewaymanagementapi": ["types-boto3-apigatewaymanagementapi>=1.35.0, <1.36.0"],
        "apigatewayv2": ["types-boto3-apigatewayv2>=1.35.0, <1.36.0"],
        "appconfig": ["types-boto3-appconfig>=1.35.0, <1.36.0"],
        "appconfigdata": ["types-boto3-appconfigdata>=1.35.0, <1.36.0"],
        "appfabric": ["types-boto3-appfabric>=1.35.0, <1.36.0"],
        "appflow": ["types-boto3-appflow>=1.35.0, <1.36.0"],
        "appintegrations": ["types-boto3-appintegrations>=1.35.0, <1.36.0"],
        "application-autoscaling": ["types-boto3-application-autoscaling>=1.35.0, <1.36.0"],
        "application-insights": ["types-boto3-application-insights>=1.35.0, <1.36.0"],
        "application-signals": ["types-boto3-application-signals>=1.35.0, <1.36.0"],
        "applicationcostprofiler": ["types-boto3-applicationcostprofiler>=1.35.0, <1.36.0"],
        "appmesh": ["types-boto3-appmesh>=1.35.0, <1.36.0"],
        "apprunner": ["types-boto3-apprunner>=1.35.0, <1.36.0"],
        "appstream": ["types-boto3-appstream>=1.35.0, <1.36.0"],
        "appsync": ["types-boto3-appsync>=1.35.0, <1.36.0"],
        "apptest": ["types-boto3-apptest>=1.35.0, <1.36.0"],
        "arc-zonal-shift": ["types-boto3-arc-zonal-shift>=1.35.0, <1.36.0"],
        "artifact": ["types-boto3-artifact>=1.35.0, <1.36.0"],
        "athena": ["types-boto3-athena>=1.35.0, <1.36.0"],
        "auditmanager": ["types-boto3-auditmanager>=1.35.0, <1.36.0"],
        "autoscaling": ["types-boto3-autoscaling>=1.35.0, <1.36.0"],
        "autoscaling-plans": ["types-boto3-autoscaling-plans>=1.35.0, <1.36.0"],
        "b2bi": ["types-boto3-b2bi>=1.35.0, <1.36.0"],
        "backup": ["types-boto3-backup>=1.35.0, <1.36.0"],
        "backup-gateway": ["types-boto3-backup-gateway>=1.35.0, <1.36.0"],
        "batch": ["types-boto3-batch>=1.35.0, <1.36.0"],
        "bcm-data-exports": ["types-boto3-bcm-data-exports>=1.35.0, <1.36.0"],
        "bcm-pricing-calculator": ["types-boto3-bcm-pricing-calculator>=1.35.0, <1.36.0"],
        "bedrock": ["types-boto3-bedrock>=1.35.0, <1.36.0"],
        "bedrock-agent": ["types-boto3-bedrock-agent>=1.35.0, <1.36.0"],
        "bedrock-agent-runtime": ["types-boto3-bedrock-agent-runtime>=1.35.0, <1.36.0"],
        "bedrock-runtime": ["types-boto3-bedrock-runtime>=1.35.0, <1.36.0"],
        "billing": ["types-boto3-billing>=1.35.0, <1.36.0"],
        "billingconductor": ["types-boto3-billingconductor>=1.35.0, <1.36.0"],
        "braket": ["types-boto3-braket>=1.35.0, <1.36.0"],
        "budgets": ["types-boto3-budgets>=1.35.0, <1.36.0"],
        "ce": ["types-boto3-ce>=1.35.0, <1.36.0"],
        "chatbot": ["types-boto3-chatbot>=1.35.0, <1.36.0"],
        "chime": ["types-boto3-chime>=1.35.0, <1.36.0"],
        "chime-sdk-identity": ["types-boto3-chime-sdk-identity>=1.35.0, <1.36.0"],
        "chime-sdk-media-pipelines": ["types-boto3-chime-sdk-media-pipelines>=1.35.0, <1.36.0"],
        "chime-sdk-meetings": ["types-boto3-chime-sdk-meetings>=1.35.0, <1.36.0"],
        "chime-sdk-messaging": ["types-boto3-chime-sdk-messaging>=1.35.0, <1.36.0"],
        "chime-sdk-voice": ["types-boto3-chime-sdk-voice>=1.35.0, <1.36.0"],
        "cleanrooms": ["types-boto3-cleanrooms>=1.35.0, <1.36.0"],
        "cleanroomsml": ["types-boto3-cleanroomsml>=1.35.0, <1.36.0"],
        "cloud9": ["types-boto3-cloud9>=1.35.0, <1.36.0"],
        "cloudcontrol": ["types-boto3-cloudcontrol>=1.35.0, <1.36.0"],
        "clouddirectory": ["types-boto3-clouddirectory>=1.35.0, <1.36.0"],
        "cloudformation": ["types-boto3-cloudformation>=1.35.0, <1.36.0"],
        "cloudfront": ["types-boto3-cloudfront>=1.35.0, <1.36.0"],
        "cloudfront-keyvaluestore": ["types-boto3-cloudfront-keyvaluestore>=1.35.0, <1.36.0"],
        "cloudhsm": ["types-boto3-cloudhsm>=1.35.0, <1.36.0"],
        "cloudhsmv2": ["types-boto3-cloudhsmv2>=1.35.0, <1.36.0"],
        "cloudsearch": ["types-boto3-cloudsearch>=1.35.0, <1.36.0"],
        "cloudsearchdomain": ["types-boto3-cloudsearchdomain>=1.35.0, <1.36.0"],
        "cloudtrail": ["types-boto3-cloudtrail>=1.35.0, <1.36.0"],
        "cloudtrail-data": ["types-boto3-cloudtrail-data>=1.35.0, <1.36.0"],
        "cloudwatch": ["types-boto3-cloudwatch>=1.35.0, <1.36.0"],
        "codeartifact": ["types-boto3-codeartifact>=1.35.0, <1.36.0"],
        "codebuild": ["types-boto3-codebuild>=1.35.0, <1.36.0"],
        "codecatalyst": ["types-boto3-codecatalyst>=1.35.0, <1.36.0"],
        "codecommit": ["types-boto3-codecommit>=1.35.0, <1.36.0"],
        "codeconnections": ["types-boto3-codeconnections>=1.35.0, <1.36.0"],
        "codedeploy": ["types-boto3-codedeploy>=1.35.0, <1.36.0"],
        "codeguru-reviewer": ["types-boto3-codeguru-reviewer>=1.35.0, <1.36.0"],
        "codeguru-security": ["types-boto3-codeguru-security>=1.35.0, <1.36.0"],
        "codeguruprofiler": ["types-boto3-codeguruprofiler>=1.35.0, <1.36.0"],
        "codepipeline": ["types-boto3-codepipeline>=1.35.0, <1.36.0"],
        "codestar-connections": ["types-boto3-codestar-connections>=1.35.0, <1.36.0"],
        "codestar-notifications": ["types-boto3-codestar-notifications>=1.35.0, <1.36.0"],
        "cognito-identity": ["types-boto3-cognito-identity>=1.35.0, <1.36.0"],
        "cognito-idp": ["types-boto3-cognito-idp>=1.35.0, <1.36.0"],
        "cognito-sync": ["types-boto3-cognito-sync>=1.35.0, <1.36.0"],
        "comprehend": ["types-boto3-comprehend>=1.35.0, <1.36.0"],
        "comprehendmedical": ["types-boto3-comprehendmedical>=1.35.0, <1.36.0"],
        "compute-optimizer": ["types-boto3-compute-optimizer>=1.35.0, <1.36.0"],
        "config": ["types-boto3-config>=1.35.0, <1.36.0"],
        "connect": ["types-boto3-connect>=1.35.0, <1.36.0"],
        "connect-contact-lens": ["types-boto3-connect-contact-lens>=1.35.0, <1.36.0"],
        "connectcampaigns": ["types-boto3-connectcampaigns>=1.35.0, <1.36.0"],
        "connectcampaignsv2": ["types-boto3-connectcampaignsv2>=1.35.0, <1.36.0"],
        "connectcases": ["types-boto3-connectcases>=1.35.0, <1.36.0"],
        "connectparticipant": ["types-boto3-connectparticipant>=1.35.0, <1.36.0"],
        "controlcatalog": ["types-boto3-controlcatalog>=1.35.0, <1.36.0"],
        "controltower": ["types-boto3-controltower>=1.35.0, <1.36.0"],
        "cost-optimization-hub": ["types-boto3-cost-optimization-hub>=1.35.0, <1.36.0"],
        "cur": ["types-boto3-cur>=1.35.0, <1.36.0"],
        "customer-profiles": ["types-boto3-customer-profiles>=1.35.0, <1.36.0"],
        "databrew": ["types-boto3-databrew>=1.35.0, <1.36.0"],
        "dataexchange": ["types-boto3-dataexchange>=1.35.0, <1.36.0"],
        "datapipeline": ["types-boto3-datapipeline>=1.35.0, <1.36.0"],
        "datasync": ["types-boto3-datasync>=1.35.0, <1.36.0"],
        "datazone": ["types-boto3-datazone>=1.35.0, <1.36.0"],
        "dax": ["types-boto3-dax>=1.35.0, <1.36.0"],
        "deadline": ["types-boto3-deadline>=1.35.0, <1.36.0"],
        "detective": ["types-boto3-detective>=1.35.0, <1.36.0"],
        "devicefarm": ["types-boto3-devicefarm>=1.35.0, <1.36.0"],
        "devops-guru": ["types-boto3-devops-guru>=1.35.0, <1.36.0"],
        "directconnect": ["types-boto3-directconnect>=1.35.0, <1.36.0"],
        "discovery": ["types-boto3-discovery>=1.35.0, <1.36.0"],
        "dlm": ["types-boto3-dlm>=1.35.0, <1.36.0"],
        "dms": ["types-boto3-dms>=1.35.0, <1.36.0"],
        "docdb": ["types-boto3-docdb>=1.35.0, <1.36.0"],
        "docdb-elastic": ["types-boto3-docdb-elastic>=1.35.0, <1.36.0"],
        "drs": ["types-boto3-drs>=1.35.0, <1.36.0"],
        "ds": ["types-boto3-ds>=1.35.0, <1.36.0"],
        "ds-data": ["types-boto3-ds-data>=1.35.0, <1.36.0"],
        "dsql": ["types-boto3-dsql>=1.35.0, <1.36.0"],
        "dynamodb": ["types-boto3-dynamodb>=1.35.0, <1.36.0"],
        "dynamodbstreams": ["types-boto3-dynamodbstreams>=1.35.0, <1.36.0"],
        "ebs": ["types-boto3-ebs>=1.35.0, <1.36.0"],
        "ec2": ["types-boto3-ec2>=1.35.0, <1.36.0"],
        "ec2-instance-connect": ["types-boto3-ec2-instance-connect>=1.35.0, <1.36.0"],
        "ecr": ["types-boto3-ecr>=1.35.0, <1.36.0"],
        "ecr-public": ["types-boto3-ecr-public>=1.35.0, <1.36.0"],
        "ecs": ["types-boto3-ecs>=1.35.0, <1.36.0"],
        "efs": ["types-boto3-efs>=1.35.0, <1.36.0"],
        "eks": ["types-boto3-eks>=1.35.0, <1.36.0"],
        "eks-auth": ["types-boto3-eks-auth>=1.35.0, <1.36.0"],
        "elastic-inference": ["types-boto3-elastic-inference>=1.35.0, <1.36.0"],
        "elasticache": ["types-boto3-elasticache>=1.35.0, <1.36.0"],
        "elasticbeanstalk": ["types-boto3-elasticbeanstalk>=1.35.0, <1.36.0"],
        "elastictranscoder": ["types-boto3-elastictranscoder>=1.35.0, <1.36.0"],
        "elb": ["types-boto3-elb>=1.35.0, <1.36.0"],
        "elbv2": ["types-boto3-elbv2>=1.35.0, <1.36.0"],
        "emr": ["types-boto3-emr>=1.35.0, <1.36.0"],
        "emr-containers": ["types-boto3-emr-containers>=1.35.0, <1.36.0"],
        "emr-serverless": ["types-boto3-emr-serverless>=1.35.0, <1.36.0"],
        "entityresolution": ["types-boto3-entityresolution>=1.35.0, <1.36.0"],
        "es": ["types-boto3-es>=1.35.0, <1.36.0"],
        "events": ["types-boto3-events>=1.35.0, <1.36.0"],
        "evidently": ["types-boto3-evidently>=1.35.0, <1.36.0"],
        "finspace": ["types-boto3-finspace>=1.35.0, <1.36.0"],
        "finspace-data": ["types-boto3-finspace-data>=1.35.0, <1.36.0"],
        "firehose": ["types-boto3-firehose>=1.35.0, <1.36.0"],
        "fis": ["types-boto3-fis>=1.35.0, <1.36.0"],
        "fms": ["types-boto3-fms>=1.35.0, <1.36.0"],
        "forecast": ["types-boto3-forecast>=1.35.0, <1.36.0"],
        "forecastquery": ["types-boto3-forecastquery>=1.35.0, <1.36.0"],
        "frauddetector": ["types-boto3-frauddetector>=1.35.0, <1.36.0"],
        "freetier": ["types-boto3-freetier>=1.35.0, <1.36.0"],
        "fsx": ["types-boto3-fsx>=1.35.0, <1.36.0"],
        "gamelift": ["types-boto3-gamelift>=1.35.0, <1.36.0"],
        "geo-maps": ["types-boto3-geo-maps>=1.35.0, <1.36.0"],
        "geo-places": ["types-boto3-geo-places>=1.35.0, <1.36.0"],
        "geo-routes": ["types-boto3-geo-routes>=1.35.0, <1.36.0"],
        "glacier": ["types-boto3-glacier>=1.35.0, <1.36.0"],
        "globalaccelerator": ["types-boto3-globalaccelerator>=1.35.0, <1.36.0"],
        "glue": ["types-boto3-glue>=1.35.0, <1.36.0"],
        "grafana": ["types-boto3-grafana>=1.35.0, <1.36.0"],
        "greengrass": ["types-boto3-greengrass>=1.35.0, <1.36.0"],
        "greengrassv2": ["types-boto3-greengrassv2>=1.35.0, <1.36.0"],
        "groundstation": ["types-boto3-groundstation>=1.35.0, <1.36.0"],
        "guardduty": ["types-boto3-guardduty>=1.35.0, <1.36.0"],
        "health": ["types-boto3-health>=1.35.0, <1.36.0"],
        "healthlake": ["types-boto3-healthlake>=1.35.0, <1.36.0"],
        "iam": ["types-boto3-iam>=1.35.0, <1.36.0"],
        "identitystore": ["types-boto3-identitystore>=1.35.0, <1.36.0"],
        "imagebuilder": ["types-boto3-imagebuilder>=1.35.0, <1.36.0"],
        "importexport": ["types-boto3-importexport>=1.35.0, <1.36.0"],
        "inspector": ["types-boto3-inspector>=1.35.0, <1.36.0"],
        "inspector-scan": ["types-boto3-inspector-scan>=1.35.0, <1.36.0"],
        "inspector2": ["types-boto3-inspector2>=1.35.0, <1.36.0"],
        "internetmonitor": ["types-boto3-internetmonitor>=1.35.0, <1.36.0"],
        "invoicing": ["types-boto3-invoicing>=1.35.0, <1.36.0"],
        "iot": ["types-boto3-iot>=1.35.0, <1.36.0"],
        "iot-data": ["types-boto3-iot-data>=1.35.0, <1.36.0"],
        "iot-jobs-data": ["types-boto3-iot-jobs-data>=1.35.0, <1.36.0"],
        "iot1click-devices": ["types-boto3-iot1click-devices>=1.35.0, <1.36.0"],
        "iot1click-projects": ["types-boto3-iot1click-projects>=1.35.0, <1.36.0"],
        "iotanalytics": ["types-boto3-iotanalytics>=1.35.0, <1.36.0"],
        "iotdeviceadvisor": ["types-boto3-iotdeviceadvisor>=1.35.0, <1.36.0"],
        "iotevents": ["types-boto3-iotevents>=1.35.0, <1.36.0"],
        "iotevents-data": ["types-boto3-iotevents-data>=1.35.0, <1.36.0"],
        "iotfleethub": ["types-boto3-iotfleethub>=1.35.0, <1.36.0"],
        "iotfleetwise": ["types-boto3-iotfleetwise>=1.35.0, <1.36.0"],
        "iotsecuretunneling": ["types-boto3-iotsecuretunneling>=1.35.0, <1.36.0"],
        "iotsitewise": ["types-boto3-iotsitewise>=1.35.0, <1.36.0"],
        "iotthingsgraph": ["types-boto3-iotthingsgraph>=1.35.0, <1.36.0"],
        "iottwinmaker": ["types-boto3-iottwinmaker>=1.35.0, <1.36.0"],
        "iotwireless": ["types-boto3-iotwireless>=1.35.0, <1.36.0"],
        "ivs": ["types-boto3-ivs>=1.35.0, <1.36.0"],
        "ivs-realtime": ["types-boto3-ivs-realtime>=1.35.0, <1.36.0"],
        "ivschat": ["types-boto3-ivschat>=1.35.0, <1.36.0"],
        "kafka": ["types-boto3-kafka>=1.35.0, <1.36.0"],
        "kafkaconnect": ["types-boto3-kafkaconnect>=1.35.0, <1.36.0"],
        "kendra": ["types-boto3-kendra>=1.35.0, <1.36.0"],
        "kendra-ranking": ["types-boto3-kendra-ranking>=1.35.0, <1.36.0"],
        "keyspaces": ["types-boto3-keyspaces>=1.35.0, <1.36.0"],
        "kinesis": ["types-boto3-kinesis>=1.35.0, <1.36.0"],
        "kinesis-video-archived-media": [
            "types-boto3-kinesis-video-archived-media>=1.35.0, <1.36.0"
        ],
        "kinesis-video-media": ["types-boto3-kinesis-video-media>=1.35.0, <1.36.0"],
        "kinesis-video-signaling": ["types-boto3-kinesis-video-signaling>=1.35.0, <1.36.0"],
        "kinesis-video-webrtc-storage": [
            "types-boto3-kinesis-video-webrtc-storage>=1.35.0, <1.36.0"
        ],
        "kinesisanalytics": ["types-boto3-kinesisanalytics>=1.35.0, <1.36.0"],
        "kinesisanalyticsv2": ["types-boto3-kinesisanalyticsv2>=1.35.0, <1.36.0"],
        "kinesisvideo": ["types-boto3-kinesisvideo>=1.35.0, <1.36.0"],
        "kms": ["types-boto3-kms>=1.35.0, <1.36.0"],
        "lakeformation": ["types-boto3-lakeformation>=1.35.0, <1.36.0"],
        "lambda": ["types-boto3-lambda>=1.35.0, <1.36.0"],
        "launch-wizard": ["types-boto3-launch-wizard>=1.35.0, <1.36.0"],
        "lex-models": ["types-boto3-lex-models>=1.35.0, <1.36.0"],
        "lex-runtime": ["types-boto3-lex-runtime>=1.35.0, <1.36.0"],
        "lexv2-models": ["types-boto3-lexv2-models>=1.35.0, <1.36.0"],
        "lexv2-runtime": ["types-boto3-lexv2-runtime>=1.35.0, <1.36.0"],
        "license-manager": ["types-boto3-license-manager>=1.35.0, <1.36.0"],
        "license-manager-linux-subscriptions": [
            "types-boto3-license-manager-linux-subscriptions>=1.35.0, <1.36.0"
        ],
        "license-manager-user-subscriptions": [
            "types-boto3-license-manager-user-subscriptions>=1.35.0, <1.36.0"
        ],
        "lightsail": ["types-boto3-lightsail>=1.35.0, <1.36.0"],
        "location": ["types-boto3-location>=1.35.0, <1.36.0"],
        "logs": ["types-boto3-logs>=1.35.0, <1.36.0"],
        "lookoutequipment": ["types-boto3-lookoutequipment>=1.35.0, <1.36.0"],
        "lookoutmetrics": ["types-boto3-lookoutmetrics>=1.35.0, <1.36.0"],
        "lookoutvision": ["types-boto3-lookoutvision>=1.35.0, <1.36.0"],
        "m2": ["types-boto3-m2>=1.35.0, <1.36.0"],
        "machinelearning": ["types-boto3-machinelearning>=1.35.0, <1.36.0"],
        "macie2": ["types-boto3-macie2>=1.35.0, <1.36.0"],
        "mailmanager": ["types-boto3-mailmanager>=1.35.0, <1.36.0"],
        "managedblockchain": ["types-boto3-managedblockchain>=1.35.0, <1.36.0"],
        "managedblockchain-query": ["types-boto3-managedblockchain-query>=1.35.0, <1.36.0"],
        "marketplace-agreement": ["types-boto3-marketplace-agreement>=1.35.0, <1.36.0"],
        "marketplace-catalog": ["types-boto3-marketplace-catalog>=1.35.0, <1.36.0"],
        "marketplace-deployment": ["types-boto3-marketplace-deployment>=1.35.0, <1.36.0"],
        "marketplace-entitlement": ["types-boto3-marketplace-entitlement>=1.35.0, <1.36.0"],
        "marketplace-reporting": ["types-boto3-marketplace-reporting>=1.35.0, <1.36.0"],
        "marketplacecommerceanalytics": [
            "types-boto3-marketplacecommerceanalytics>=1.35.0, <1.36.0"
        ],
        "mediaconnect": ["types-boto3-mediaconnect>=1.35.0, <1.36.0"],
        "mediaconvert": ["types-boto3-mediaconvert>=1.35.0, <1.36.0"],
        "medialive": ["types-boto3-medialive>=1.35.0, <1.36.0"],
        "mediapackage": ["types-boto3-mediapackage>=1.35.0, <1.36.0"],
        "mediapackage-vod": ["types-boto3-mediapackage-vod>=1.35.0, <1.36.0"],
        "mediapackagev2": ["types-boto3-mediapackagev2>=1.35.0, <1.36.0"],
        "mediastore": ["types-boto3-mediastore>=1.35.0, <1.36.0"],
        "mediastore-data": ["types-boto3-mediastore-data>=1.35.0, <1.36.0"],
        "mediatailor": ["types-boto3-mediatailor>=1.35.0, <1.36.0"],
        "medical-imaging": ["types-boto3-medical-imaging>=1.35.0, <1.36.0"],
        "memorydb": ["types-boto3-memorydb>=1.35.0, <1.36.0"],
        "meteringmarketplace": ["types-boto3-meteringmarketplace>=1.35.0, <1.36.0"],
        "mgh": ["types-boto3-mgh>=1.35.0, <1.36.0"],
        "mgn": ["types-boto3-mgn>=1.35.0, <1.36.0"],
        "migration-hub-refactor-spaces": [
            "types-boto3-migration-hub-refactor-spaces>=1.35.0, <1.36.0"
        ],
        "migrationhub-config": ["types-boto3-migrationhub-config>=1.35.0, <1.36.0"],
        "migrationhuborchestrator": ["types-boto3-migrationhuborchestrator>=1.35.0, <1.36.0"],
        "migrationhubstrategy": ["types-boto3-migrationhubstrategy>=1.35.0, <1.36.0"],
        "mq": ["types-boto3-mq>=1.35.0, <1.36.0"],
        "mturk": ["types-boto3-mturk>=1.35.0, <1.36.0"],
        "mwaa": ["types-boto3-mwaa>=1.35.0, <1.36.0"],
        "neptune": ["types-boto3-neptune>=1.35.0, <1.36.0"],
        "neptune-graph": ["types-boto3-neptune-graph>=1.35.0, <1.36.0"],
        "neptunedata": ["types-boto3-neptunedata>=1.35.0, <1.36.0"],
        "network-firewall": ["types-boto3-network-firewall>=1.35.0, <1.36.0"],
        "networkflowmonitor": ["types-boto3-networkflowmonitor>=1.35.0, <1.36.0"],
        "networkmanager": ["types-boto3-networkmanager>=1.35.0, <1.36.0"],
        "networkmonitor": ["types-boto3-networkmonitor>=1.35.0, <1.36.0"],
        "notifications": ["types-boto3-notifications>=1.35.0, <1.36.0"],
        "notificationscontacts": ["types-boto3-notificationscontacts>=1.35.0, <1.36.0"],
        "oam": ["types-boto3-oam>=1.35.0, <1.36.0"],
        "observabilityadmin": ["types-boto3-observabilityadmin>=1.35.0, <1.36.0"],
        "omics": ["types-boto3-omics>=1.35.0, <1.36.0"],
        "opensearch": ["types-boto3-opensearch>=1.35.0, <1.36.0"],
        "opensearchserverless": ["types-boto3-opensearchserverless>=1.35.0, <1.36.0"],
        "opsworks": ["types-boto3-opsworks>=1.35.0, <1.36.0"],
        "opsworkscm": ["types-boto3-opsworkscm>=1.35.0, <1.36.0"],
        "organizations": ["types-boto3-organizations>=1.35.0, <1.36.0"],
        "osis": ["types-boto3-osis>=1.35.0, <1.36.0"],
        "outposts": ["types-boto3-outposts>=1.35.0, <1.36.0"],
        "panorama": ["types-boto3-panorama>=1.35.0, <1.36.0"],
        "partnercentral-selling": ["types-boto3-partnercentral-selling>=1.35.0, <1.36.0"],
        "payment-cryptography": ["types-boto3-payment-cryptography>=1.35.0, <1.36.0"],
        "payment-cryptography-data": ["types-boto3-payment-cryptography-data>=1.35.0, <1.36.0"],
        "pca-connector-ad": ["types-boto3-pca-connector-ad>=1.35.0, <1.36.0"],
        "pca-connector-scep": ["types-boto3-pca-connector-scep>=1.35.0, <1.36.0"],
        "pcs": ["types-boto3-pcs>=1.35.0, <1.36.0"],
        "personalize": ["types-boto3-personalize>=1.35.0, <1.36.0"],
        "personalize-events": ["types-boto3-personalize-events>=1.35.0, <1.36.0"],
        "personalize-runtime": ["types-boto3-personalize-runtime>=1.35.0, <1.36.0"],
        "pi": ["types-boto3-pi>=1.35.0, <1.36.0"],
        "pinpoint": ["types-boto3-pinpoint>=1.35.0, <1.36.0"],
        "pinpoint-email": ["types-boto3-pinpoint-email>=1.35.0, <1.36.0"],
        "pinpoint-sms-voice": ["types-boto3-pinpoint-sms-voice>=1.35.0, <1.36.0"],
        "pinpoint-sms-voice-v2": ["types-boto3-pinpoint-sms-voice-v2>=1.35.0, <1.36.0"],
        "pipes": ["types-boto3-pipes>=1.35.0, <1.36.0"],
        "polly": ["types-boto3-polly>=1.35.0, <1.36.0"],
        "pricing": ["types-boto3-pricing>=1.35.0, <1.36.0"],
        "privatenetworks": ["types-boto3-privatenetworks>=1.35.0, <1.36.0"],
        "proton": ["types-boto3-proton>=1.35.0, <1.36.0"],
        "qapps": ["types-boto3-qapps>=1.35.0, <1.36.0"],
        "qbusiness": ["types-boto3-qbusiness>=1.35.0, <1.36.0"],
        "qconnect": ["types-boto3-qconnect>=1.35.0, <1.36.0"],
        "qldb": ["types-boto3-qldb>=1.35.0, <1.36.0"],
        "qldb-session": ["types-boto3-qldb-session>=1.35.0, <1.36.0"],
        "quicksight": ["types-boto3-quicksight>=1.35.0, <1.36.0"],
        "ram": ["types-boto3-ram>=1.35.0, <1.36.0"],
        "rbin": ["types-boto3-rbin>=1.35.0, <1.36.0"],
        "rds": ["types-boto3-rds>=1.35.0, <1.36.0"],
        "rds-data": ["types-boto3-rds-data>=1.35.0, <1.36.0"],
        "redshift": ["types-boto3-redshift>=1.35.0, <1.36.0"],
        "redshift-data": ["types-boto3-redshift-data>=1.35.0, <1.36.0"],
        "redshift-serverless": ["types-boto3-redshift-serverless>=1.35.0, <1.36.0"],
        "rekognition": ["types-boto3-rekognition>=1.35.0, <1.36.0"],
        "repostspace": ["types-boto3-repostspace>=1.35.0, <1.36.0"],
        "resiliencehub": ["types-boto3-resiliencehub>=1.35.0, <1.36.0"],
        "resource-explorer-2": ["types-boto3-resource-explorer-2>=1.35.0, <1.36.0"],
        "resource-groups": ["types-boto3-resource-groups>=1.35.0, <1.36.0"],
        "resourcegroupstaggingapi": ["types-boto3-resourcegroupstaggingapi>=1.35.0, <1.36.0"],
        "robomaker": ["types-boto3-robomaker>=1.35.0, <1.36.0"],
        "rolesanywhere": ["types-boto3-rolesanywhere>=1.35.0, <1.36.0"],
        "route53": ["types-boto3-route53>=1.35.0, <1.36.0"],
        "route53-recovery-cluster": ["types-boto3-route53-recovery-cluster>=1.35.0, <1.36.0"],
        "route53-recovery-control-config": [
            "types-boto3-route53-recovery-control-config>=1.35.0, <1.36.0"
        ],
        "route53-recovery-readiness": ["types-boto3-route53-recovery-readiness>=1.35.0, <1.36.0"],
        "route53domains": ["types-boto3-route53domains>=1.35.0, <1.36.0"],
        "route53profiles": ["types-boto3-route53profiles>=1.35.0, <1.36.0"],
        "route53resolver": ["types-boto3-route53resolver>=1.35.0, <1.36.0"],
        "rum": ["types-boto3-rum>=1.35.0, <1.36.0"],
        "s3": ["types-boto3-s3>=1.35.0, <1.36.0"],
        "s3control": ["types-boto3-s3control>=1.35.0, <1.36.0"],
        "s3outposts": ["types-boto3-s3outposts>=1.35.0, <1.36.0"],
        "s3tables": ["types-boto3-s3tables>=1.35.0, <1.36.0"],
        "sagemaker": ["types-boto3-sagemaker>=1.35.0, <1.36.0"],
        "sagemaker-a2i-runtime": ["types-boto3-sagemaker-a2i-runtime>=1.35.0, <1.36.0"],
        "sagemaker-edge": ["types-boto3-sagemaker-edge>=1.35.0, <1.36.0"],
        "sagemaker-featurestore-runtime": [
            "types-boto3-sagemaker-featurestore-runtime>=1.35.0, <1.36.0"
        ],
        "sagemaker-geospatial": ["types-boto3-sagemaker-geospatial>=1.35.0, <1.36.0"],
        "sagemaker-metrics": ["types-boto3-sagemaker-metrics>=1.35.0, <1.36.0"],
        "sagemaker-runtime": ["types-boto3-sagemaker-runtime>=1.35.0, <1.36.0"],
        "savingsplans": ["types-boto3-savingsplans>=1.35.0, <1.36.0"],
        "scheduler": ["types-boto3-scheduler>=1.35.0, <1.36.0"],
        "schemas": ["types-boto3-schemas>=1.35.0, <1.36.0"],
        "sdb": ["types-boto3-sdb>=1.35.0, <1.36.0"],
        "secretsmanager": ["types-boto3-secretsmanager>=1.35.0, <1.36.0"],
        "security-ir": ["types-boto3-security-ir>=1.35.0, <1.36.0"],
        "securityhub": ["types-boto3-securityhub>=1.35.0, <1.36.0"],
        "securitylake": ["types-boto3-securitylake>=1.35.0, <1.36.0"],
        "serverlessrepo": ["types-boto3-serverlessrepo>=1.35.0, <1.36.0"],
        "service-quotas": ["types-boto3-service-quotas>=1.35.0, <1.36.0"],
        "servicecatalog": ["types-boto3-servicecatalog>=1.35.0, <1.36.0"],
        "servicecatalog-appregistry": ["types-boto3-servicecatalog-appregistry>=1.35.0, <1.36.0"],
        "servicediscovery": ["types-boto3-servicediscovery>=1.35.0, <1.36.0"],
        "ses": ["types-boto3-ses>=1.35.0, <1.36.0"],
        "sesv2": ["types-boto3-sesv2>=1.35.0, <1.36.0"],
        "shield": ["types-boto3-shield>=1.35.0, <1.36.0"],
        "signer": ["types-boto3-signer>=1.35.0, <1.36.0"],
        "simspaceweaver": ["types-boto3-simspaceweaver>=1.35.0, <1.36.0"],
        "sms": ["types-boto3-sms>=1.35.0, <1.36.0"],
        "sms-voice": ["types-boto3-sms-voice>=1.35.0, <1.36.0"],
        "snow-device-management": ["types-boto3-snow-device-management>=1.35.0, <1.36.0"],
        "snowball": ["types-boto3-snowball>=1.35.0, <1.36.0"],
        "sns": ["types-boto3-sns>=1.35.0, <1.36.0"],
        "socialmessaging": ["types-boto3-socialmessaging>=1.35.0, <1.36.0"],
        "sqs": ["types-boto3-sqs>=1.35.0, <1.36.0"],
        "ssm": ["types-boto3-ssm>=1.35.0, <1.36.0"],
        "ssm-contacts": ["types-boto3-ssm-contacts>=1.35.0, <1.36.0"],
        "ssm-incidents": ["types-boto3-ssm-incidents>=1.35.0, <1.36.0"],
        "ssm-quicksetup": ["types-boto3-ssm-quicksetup>=1.35.0, <1.36.0"],
        "ssm-sap": ["types-boto3-ssm-sap>=1.35.0, <1.36.0"],
        "sso": ["types-boto3-sso>=1.35.0, <1.36.0"],
        "sso-admin": ["types-boto3-sso-admin>=1.35.0, <1.36.0"],
        "sso-oidc": ["types-boto3-sso-oidc>=1.35.0, <1.36.0"],
        "stepfunctions": ["types-boto3-stepfunctions>=1.35.0, <1.36.0"],
        "storagegateway": ["types-boto3-storagegateway>=1.35.0, <1.36.0"],
        "sts": ["types-boto3-sts>=1.35.0, <1.36.0"],
        "supplychain": ["types-boto3-supplychain>=1.35.0, <1.36.0"],
        "support": ["types-boto3-support>=1.35.0, <1.36.0"],
        "support-app": ["types-boto3-support-app>=1.35.0, <1.36.0"],
        "swf": ["types-boto3-swf>=1.35.0, <1.36.0"],
        "synthetics": ["types-boto3-synthetics>=1.35.0, <1.36.0"],
        "taxsettings": ["types-boto3-taxsettings>=1.35.0, <1.36.0"],
        "textract": ["types-boto3-textract>=1.35.0, <1.36.0"],
        "timestream-influxdb": ["types-boto3-timestream-influxdb>=1.35.0, <1.36.0"],
        "timestream-query": ["types-boto3-timestream-query>=1.35.0, <1.36.0"],
        "timestream-write": ["types-boto3-timestream-write>=1.35.0, <1.36.0"],
        "tnb": ["types-boto3-tnb>=1.35.0, <1.36.0"],
        "transcribe": ["types-boto3-transcribe>=1.35.0, <1.36.0"],
        "transfer": ["types-boto3-transfer>=1.35.0, <1.36.0"],
        "translate": ["types-boto3-translate>=1.35.0, <1.36.0"],
        "trustedadvisor": ["types-boto3-trustedadvisor>=1.35.0, <1.36.0"],
        "verifiedpermissions": ["types-boto3-verifiedpermissions>=1.35.0, <1.36.0"],
        "voice-id": ["types-boto3-voice-id>=1.35.0, <1.36.0"],
        "vpc-lattice": ["types-boto3-vpc-lattice>=1.35.0, <1.36.0"],
        "waf": ["types-boto3-waf>=1.35.0, <1.36.0"],
        "waf-regional": ["types-boto3-waf-regional>=1.35.0, <1.36.0"],
        "wafv2": ["types-boto3-wafv2>=1.35.0, <1.36.0"],
        "wellarchitected": ["types-boto3-wellarchitected>=1.35.0, <1.36.0"],
        "wisdom": ["types-boto3-wisdom>=1.35.0, <1.36.0"],
        "workdocs": ["types-boto3-workdocs>=1.35.0, <1.36.0"],
        "workmail": ["types-boto3-workmail>=1.35.0, <1.36.0"],
        "workmailmessageflow": ["types-boto3-workmailmessageflow>=1.35.0, <1.36.0"],
        "workspaces": ["types-boto3-workspaces>=1.35.0, <1.36.0"],
        "workspaces-thin-client": ["types-boto3-workspaces-thin-client>=1.35.0, <1.36.0"],
        "workspaces-web": ["types-boto3-workspaces-web>=1.35.0, <1.36.0"],
        "xray": ["types-boto3-xray>=1.35.0, <1.36.0"],
    },
    zip_safe=False,
)
