# coding: utf-8

"""
    Cythereal MAGIC API

     The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: `ff9790d7902fea4c910b182f6e0b00221a40d616`   * Can be used for `file_hash` parameters. * Procedure RVA: `0x1000`   * Use with the above SHA1 for `proc_rva` parameters.   # API Conventions  Properties MUST be named using `snake_case`.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type `APIResponse` and contain the following fields:  * `api_version` |  The current api version * `success` | Boolean value indicating if the operation succeeded. * `code` | Status code. Typically corresponds to the HTTP status code.  * `message` | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a `SuccessResponse`, which extends `APIResponse` by adding:  * `data` | Properties containing the response object. * `success` | MUST equal True  When returning objects from a successful response, the `data` object SHOULD contain a property named after the requested object type. For example, the `/matches` endpoint should return a response object with `data.matches`. This property SHOULD  contain a list of the returned objects. For the `/matches` endpoint, the `data.matches` property contains a list of MagicMatch objects. See the `/matches` endpoint documentation for an example.  **Failed Operations** MUST return an `ErrorResponse`, which extends `APIResponse` by adding:  * `errors` | Array of error objects. An error object contains the following properties:     * `ErrorObject.reason` | Unique identifier for this error. Example: \"FileNotFoundError\".     * `ErrorObject.message`| Human readable error message. * `success` | MUST equal False.   # noqa: E501

    OpenAPI spec version: 1
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cythereal_magic.api_client import ApiClient


class CytherealMagicApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_file(self, filedata, **kwargs):  # noqa: E501
        """Upload a file for processing  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file(filedata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file filedata: Binary contents of the file (required)
        :param str filename: Name of the file being uploaded
        :param str password: If uploading a password protected zip, this field MUST contain the password. 
        :param list[str] tags: A comma separated list of tags to create (Will not auto tag the file) 
        :param int priority: Analysis priority. Higher priority files are analyzed first. Priorities higher than default may require additional privileges.
        :return: FileUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_file_with_http_info(filedata, **kwargs)  # noqa: E501
        else:
            (data) = self.create_file_with_http_info(filedata, **kwargs)  # noqa: E501
            return data

    def create_file_with_http_info(self, filedata, **kwargs):  # noqa: E501
        """Upload a file for processing  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file_with_http_info(filedata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file filedata: Binary contents of the file (required)
        :param str filename: Name of the file being uploaded
        :param str password: If uploading a password protected zip, this field MUST contain the password. 
        :param list[str] tags: A comma separated list of tags to create (Will not auto tag the file) 
        :param int priority: Analysis priority. Higher priority files are analyzed first. Priorities higher than default may require additional privileges.
        :return: FileUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filedata', 'filename', 'password', 'tags', 'priority']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'filedata' is set
        if ('filedata' not in params or
                params['filedata'] is None):
            raise ValueError("Missing the required parameter `filedata` when calling `create_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filename' in params:
            query_params.append(('filename', params['filename']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501
        if 'priority' in params:
            query_params.append(('priority', params['priority']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'filedata' in params:
            local_var_files['filedata'] = params['filedata']  # noqa: E501
        if 'tags' in params:
            form_params.append(('tags', params['tags']))  # noqa: E501
            collection_formats['tags'] = 'csv'  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/files/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileUploadResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_file(self, file_hash, **kwargs):  # noqa: E501
        """Download a file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_file(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_file_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.download_file_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    def download_file_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Download a file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_file_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `download_file`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `download_file`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/files/{file_hash}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_binary_genomics(self, file_hash, **kwargs):  # noqa: E501
        """Show the genomic features for a given binary.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_binary_genomics(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: BinaryGenomicsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_binary_genomics_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_binary_genomics_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    def get_binary_genomics_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Show the genomic features for a given binary.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_binary_genomics_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: BinaryGenomicsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_binary_genomics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `get_binary_genomics`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `get_binary_genomics`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/genomics/{file_hash}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BinaryGenomicsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_campaign_id(self, file_hash, **kwargs):  # noqa: E501
        """Get the campaign id for a binary.  # noqa: E501

        Useful for quickly getting the campaign_id for a binary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_campaign_id(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: CampaignIdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_campaign_id_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_campaign_id_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    def get_campaign_id_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Get the campaign id for a binary.  # noqa: E501

        Useful for quickly getting the campaign_id for a binary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_campaign_id_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: CampaignIdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `get_campaign_id`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `get_campaign_id`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/reports/{file_hash}/campaign', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CampaignIdResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_details(self, file_hash, **kwargs):  # noqa: E501
        """Get additional details about certain filetypes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_details(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: FileDetailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_details_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_details_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    def get_file_details_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Get additional details about certain filetypes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_details_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: FileDetailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `get_file_details`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `get_file_details`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/files/{file_hash}/details', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileDetailsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_info(self, file_hash, **kwargs):  # noqa: E501
        """Get file info and analysis status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: FileInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_info_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_info_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    def get_file_info_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Get file info and analysis status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_info_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: FileInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `get_file_info`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `get_file_info`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/files/{file_hash}/info/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileInfoResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_owned_files(self, **kwargs):  # noqa: E501
        """List files owned by the authenticated user.  # noqa: E501

        List files owned by the authenticated user.  This includes files uploaded by the user and files created from these originally uploaded files. Known issues:   - Upload date is based on the date *any* user uploaded the file, not specifically this user.   - If the user has uploaded a large amount of files (order of 100k), a query without the date     filter will cause the server to time out. The workaround is to filter by date.   - If the user has uploaded a large amount of files on any given date, filtering by this date     will still cause the server to timeout.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_owned_files(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _date: Return uploads from the given date. If not provided, all owned files from startDate to endDate will be returned Specify date as `YYYY-MM-DD`. 
        :param str start_date: Return uploads from the given date until endDate. Specify date as `YYYY-MM-DD`. 
        :param str end_date: Return uploads from startDate until the given date. Specify date as `YYYY-MM-DD`. 
        :param bool public: Return files that are marked as public. This will return **only** public files, and ignore the user's files. 
        :param bool only_top_level: Will return only uploaded files (no children) when True. 
        :param float page: Page of results to retrieve. Starts at 1. If not provided, the first page of results will be returned. 
        :return: OwnedFilesListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_owned_files_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_owned_files_with_http_info(**kwargs)  # noqa: E501
            return data
    # Backwards compatibility.
    find_owned_files = get_owned_files

    def get_owned_files_with_http_info(self, **kwargs):  # noqa: E501
        """List files owned by the authenticated user.  # noqa: E501

        List files owned by the authenticated user.  This includes files uploaded by the user and files created from these originally uploaded files. Known issues:   - Upload date is based on the date *any* user uploaded the file, not specifically this user.   - If the user has uploaded a large amount of files (order of 100k), a query without the date     filter will cause the server to time out. The workaround is to filter by date.   - If the user has uploaded a large amount of files on any given date, filtering by this date     will still cause the server to timeout.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_owned_files_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _date: Return uploads from the given date. If not provided, all owned files from startDate to endDate will be returned Specify date as `YYYY-MM-DD`. 
        :param str start_date: Return uploads from the given date until endDate. Specify date as `YYYY-MM-DD`. 
        :param str end_date: Return uploads from startDate until the given date. Specify date as `YYYY-MM-DD`. 
        :param bool public: Return files that are marked as public. This will return **only** public files, and ignore the user's files. 
        :param bool only_top_level: Will return only uploaded files (no children) when True. 
        :param float page: Page of results to retrieve. Starts at 1. If not provided, the first page of results will be returned. 
        :return: OwnedFilesListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_date', 'start_date', 'end_date', 'public', 'only_top_level', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_owned_files" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_date' in params:
            query_params.append(('date', params['_date']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'public' in params:
            query_params.append(('public', params['public']))  # noqa: E501
        if 'only_top_level' in params:
            query_params.append(('only_top_level', params['only_top_level']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/files/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OwnedFilesListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_procedure_genomics(self, file_hash, proc_rva, **kwargs):  # noqa: E501
        """Show the genomic features for a given procedure.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_procedure_genomics(file_hash, proc_rva, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :param str proc_rva: The RVA of the procedure to find similarities with. Formatted 0xnnnn (required)
        :return: ProcedureGenomicsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_procedure_genomics_with_http_info(file_hash, proc_rva, **kwargs)  # noqa: E501
        else:
            (data) = self.get_procedure_genomics_with_http_info(file_hash, proc_rva, **kwargs)  # noqa: E501
            return data

    def get_procedure_genomics_with_http_info(self, file_hash, proc_rva, **kwargs):  # noqa: E501
        """Show the genomic features for a given procedure.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_procedure_genomics_with_http_info(file_hash, proc_rva, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :param str proc_rva: The RVA of the procedure to find similarities with. Formatted 0xnnnn (required)
        :return: ProcedureGenomicsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash', 'proc_rva']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_procedure_genomics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `get_procedure_genomics`")  # noqa: E501
        # verify the required parameter 'proc_rva' is set
        if ('proc_rva' not in params or
                params['proc_rva'] is None):
            raise ValueError("Missing the required parameter `proc_rva` when calling `get_procedure_genomics`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `get_procedure_genomics`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501
        if 'proc_rva' in params:
            path_params['proc_rva'] = params['proc_rva']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/genomics/{file_hash}/{proc_rva}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProcedureGenomicsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_report(self, file_hash, **kwargs):  # noqa: E501
        """Get the Magic report for a binary.  # noqa: E501

        Includes most of the report information. Does not include magic matches for performance reasons.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: MagicReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_report_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_report_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    def get_report_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Get the Magic report for a binary.  # noqa: E501

        Includes most of the report information. Does not include magic matches for performance reasons.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: MagicReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `get_report`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `get_report`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/reports/{file_hash}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MagicReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_report_categories(self, file_hash, **kwargs):  # noqa: E501
        """Retrieve the MAGIC categories for a binary.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_categories(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: MagicCategoriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_report_categories_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_report_categories_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    # Backwards compatibility
    find_report_categories = get_report_categories

    def get_report_categories_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Retrieve the MAGIC categories for a binary.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_categories_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: MagicCategoriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_report_categories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `get_report_categories`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `get_report_categories`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/reports/{file_hash}/categories/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MagicCategoriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_report_labels(self, file_hash, **kwargs):  # noqa: E501
        """Retrieve the MAGIC labels report for a binary.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_labels(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: MagicLabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_report_labels_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_report_labels_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    def get_report_labels_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Retrieve the MAGIC labels report for a binary.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_labels_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: MagicLabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_report_labels" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `get_report_labels`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `get_report_labels`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/reports/{file_hash}/labels/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MagicLabelsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_report_matches(self, file_hash, **kwargs):  # noqa: E501
        """Retrieve the MAGIC matches for a binary.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_matches(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :param float threshold: Only similarity matches at value equal or above threshold will be considered.  MUST be in range [0, 1]. Defaults to 0.7.
        :param int limit: Number of matches to return per call
        :param int page: Number of pages per (limit) to skip
        :return: MagicMatchesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_report_matches_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_report_matches_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    # Backwards compatibility
    find_report_matches = get_report_matches

    def get_report_matches_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Retrieve the MAGIC matches for a binary.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_matches_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :param float threshold: Only similarity matches at value equal or above threshold will be considered.  MUST be in range [0, 1]. Defaults to 0.7.
        :param int limit: Number of matches to return per call
        :param int page: Number of pages per (limit) to skip
        :return: MagicMatchesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash', 'threshold', 'limit', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_report_matches" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `get_report_matches`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `get_report_matches`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []
        if 'threshold' in params:
            query_params.append(('threshold', params['threshold']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/reports/{file_hash}/matches/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MagicMatchesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_similar_binaries(self, file_hash, **kwargs):  # noqa: E501
        """Search for similar binaries.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_similar_binaries(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :param float threshold: Similarity threshold, default 0.7.
        :param int limit: Number of matches to return per call
        :param int page: Number of pages per (limit) to skip
        :param str method: Method used to determine this procedure was similar with the query procedure.  Possible values are  - `semantic_hash` The semantics based hashes matched. - `semantic_similarity` The semantics of the binaries are similar. The semantic hashes may or may not match. 
        :return: BinarySimilarityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_similar_binaries_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_similar_binaries_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    # Backwards compatibility
    find_similar_binaries = get_similar_binaries

    def get_similar_binaries_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Search for similar binaries.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_similar_binaries_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :param float threshold: Similarity threshold, default 0.7.
        :param int limit: Number of matches to return per call
        :param int page: Number of pages per (limit) to skip
        :param str method: Method used to determine this procedure was similar with the query procedure.  Possible values are  - `semantic_hash` The semantics based hashes matched. - `semantic_similarity` The semantics of the binaries are similar. The semantic hashes may or may not match. 
        :return: BinarySimilarityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash', 'threshold', 'limit', 'page', 'method']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_similar_binaries" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `get_similar_binaries`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `get_similar_binaries`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []
        if 'threshold' in params:
            query_params.append(('threshold', params['threshold']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'method' in params:
            query_params.append(('method', params['method']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/similarities/{file_hash}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BinarySimilarityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_similar_procedures(self, file_hash, proc_rva, **kwargs):  # noqa: E501
        """Search for procedures similar to a given procedure.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_similar_procedures(file_hash, proc_rva, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :param str proc_rva: The RVA of the procedure to find similarities with. Formatted 0xnnnn (required)
        :param str method: Method used to determine this procedure was similar with the query procedure.  Possible values are  - `semantic_hash` Hashes based on the semantics of the procedures matches. 
        :return: ProcedureSimilarityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_similar_procedures_with_http_info(file_hash, proc_rva, **kwargs)  # noqa: E501
        else:
            (data) = self.get_similar_procedures_with_http_info(file_hash, proc_rva, **kwargs)  # noqa: E501
            return data

    # Backwards compatibility
    find_similar_procedures = get_similar_procedures

    def get_similar_procedures_with_http_info(self, file_hash, proc_rva, **kwargs):  # noqa: E501
        """Search for procedures similar to a given procedure.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_similar_procedures_with_http_info(file_hash, proc_rva, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :param str proc_rva: The RVA of the procedure to find similarities with. Formatted 0xnnnn (required)
        :param str method: Method used to determine this procedure was similar with the query procedure.  Possible values are  - `semantic_hash` Hashes based on the semantics of the procedures matches. 
        :return: ProcedureSimilarityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash', 'proc_rva', 'method']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_similar_procedures" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `get_similar_procedures`")  # noqa: E501
        # verify the required parameter 'proc_rva' is set
        if ('proc_rva' not in params or
                params['proc_rva'] is None):
            raise ValueError("Missing the required parameter `proc_rva` when calling `get_similar_procedures`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `get_similar_procedures`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501
        if 'proc_rva' in params:
            path_params['proc_rva'] = params['proc_rva']  # noqa: E501

        query_params = []
        if 'method' in params:
            query_params.append(('method', params['method']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/similarities/{file_hash}/{proc_rva}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProcedureSimilarityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ping(self, **kwargs):  # noqa: E501
        """Check if server is responding to queries.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ping(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ping_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.ping_with_http_info(**kwargs)  # noqa: E501
            return data

    def ping_with_http_info(self, **kwargs):  # noqa: E501
        """Check if server is responding to queries.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ping_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ping" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/ping/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reprocess_file(self, file_hash, **kwargs):  # noqa: E501
        """Reprocess a previously uploaded file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reprocess_file(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :param int priority: Analysis priority. Higher priority files are analyzed first. Priorities higher than default may require additional privileges.
        :param str password: If uploading a password protected zip, this field MUST contain the password. 
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reprocess_file_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.reprocess_file_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    def reprocess_file_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Reprocess a previously uploaded file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reprocess_file_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :param int priority: Analysis priority. Higher priority files are analyzed first. Priorities higher than default may require additional privileges.
        :param str password: If uploading a password protected zip, this field MUST contain the password. 
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash', 'priority', 'password']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reprocess_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `reprocess_file`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `reprocess_file`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []
        if 'priority' in params:
            query_params.append(('priority', params['priority']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/files/{file_hash}/reprocess/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
