# multiplex-imaging-pipeline

A pipeline for multiplex imaging analysis



## Installation

```bash
pip install multiplex-imaging-pipeline
```

## Cell Annotation

See example notebook [here](https://github.com/estorrs/multiplex-imaging-pipeline/blob/main/notebooks/cell_annotation_example.ipynb) for an example of how to perform cell annotation on the output of `mip generate-spatial-features`. 

## CLI usage

The multiplex imaging analysis command line tool has four main modes:
+ make-ome
  + make an ome.tiff formatted to Human Tumor Atlas Network specifications from a folder of .tif files or a .qptiff file
+ show-channels
  + output channel order of an ome.tiff file
+ generate-spatial-features
  + given a ome.tiff and labeled cell segmentation .tif, generate a table with features for each cell. Features include basic morphology metrics and marker intensity mean, min, and max for each channel.
+ generate-region-features
  + Given an ome.tiff and a .tif file specifying region locations, generate region-based metrics. Region based metrics include the following: region morphology, region boundary characteristics, TME interactions.

#### make-ome

###### Create from a .qptiff file (new CODEX)

```bash
mip make-ome --input-tif </path/to/*.qptiff> --output-filepath </path/to/output.ome.tiff>
```

###### Create from a folder of .tif files

Takes as input a directory containing stitched .tif images and creates and HTAN consortium compatible ome.tiff

```bash
mip make-ome --input-tif </path/to/directory/with/tiffs> --output-filepath </path/to/output.ome.tiff> --platform raw
```

#### show-channels

```bash
mip show-channels --ome-tiff </path/to/*.ome.tiff>
```

#### generate-spatial-features

Takes a label image and ome.tiff as input, and outputs spatial features.

label image - .tif containing cell segmentation information. is a tiff where all background pixels have the value 0, and the pixels representing the location of a cell are given an integer label unique to that cell. This image can be generated by QiTissue, or a variety of cell segmentation tools. Will generate two files: <output_prefix>.txt and <output_prefix>.h5ad. The former is a tab-seperated file where each row is a cell and each column is a feature. The .h5ad file contains the same information, but in scanpy AnnData format.

```bash
mip generate-spatial-features --label-image </path/to/label/image.tif> --ome-tiff </path/to/*.ome.tiff> --output-prefix </path/to/output/prefix>
```

#### generate-region-features

Generates region based features.

inputs:
+ --spatial-features
  + Filepath of a tab-seperated .txt file with columns specifying coordinates cell annotations in slide. First column is cell ID, second and third columns are treated as "x" and "y" coordinates respectively. All following columns are treated as cell metadata features and seperate fractions/metrics will be generated for each feature.
+ --ome-tiff
  + Filepath of ome.tiff corresponding to region mask.
+ --regions-mask
  + Filepath of region mask that will be used when calculating metrics. Mask should be a .tif file and the same height and width as --ome-tiff. 0-valued pixels are background, 1-valued pixels are regions.
+ --channel-thresholds-grid
  + Filepath of tab-seperated .txt file where the first column is a channel name in the --ome-tiff and the second column is threshold values to use when determining positive grid polygons in the ring around each region.
+ -channel-thresholds-pixel
  + Filepath of tab-seperated .txt file where the first column is a channel name in the --ome-tiff and the second column is threshold values to use when determining positive pixels when calculating region positive marker fractions.
+ --output-dir
  + Location to write generate-region-features output files.
+ --expansion
  + Distance (in pixels) to draw ring area around each region that is used to calculate grid metrics. Default is 40 pixels.
+ --boundary-dist
  + Distance (in pixels) to draw boundary area around each region. Default is 150 pixels.
+ --perp-steps
  + Number of perpendicular steps to use in expansion area. I.e. number of arcs to draw that are offset from the region boundary. Default is 10 pixels.
+ --parallel-step
  + Step size (in pixels) to segment grid parallel to region boundary. Default is 50 pixels.
+ --breakage-dist
  + Distance (in pixels) along innermost arc to use when drawing breakage lines. Default is 10 pixels.
+ --area_thresh
  + Filter out grid polygons with area greater than area-thresh. Default is 2000.
+ --breakage-line-thresh
  + Filter out grid polygons with area greater than area-thresh. Default is 100
+ --min-region-size
  + Skip regions below --min-region-size when calculating metrics. Default is None
+ --max-region-size
  + Skip regions over --max-region-size when calculating metrics. Helps speed up runs for debugging purposes since there are non-linear increases in runtime with region size. Default is None.
+ --skip-grid-metrics
  + If --slip-grid-metrics, then do not calculate polygon-mesh related metrics and only calculate basic region metrics.

```bash
mip generate-region-features --spatial-features </path/to/spatial_features/*.txt> --ome-tiff </path/to/*.ome.tiff> --region-mask </path/to/region_mask/*.tif> --channel-thresholds-grid </path/to/channel_thresholds_grid/*.txt> --channel-thresholds-pixel </path/to/channel_thresholds_pixel/*.txt> --output-dir </path/to/output/dir>
```

#### help

```bash
mip --help
```

usage: mip [-h] [--sep SEP] [--input-tif INPUT_TIF] [--output-filepath OUTPUT_FILEPATH] [--platform {codex,phenocycler,raw}] [--bbox BBOX] [--label-image LABEL_IMAGE] [--ome-tiff OME_TIFF] [--output-prefix OUTPUT_PREFIX] [--spatial-features SPATIAL_FEATURES] [--regions-mask REGIONS_MASK] [--channel-thresholds-grid CHANNEL_THRESHOLDS_GRID] [--channel-thresholds-pixel CHANNEL_THRESHOLDS_PIXEL] [--output-dir OUTPUT_DIR] [--boundary-dist BOUNDARY_DIST] [--perp-steps PERP_STEPS] [--expansion EXPANSION] [--parallel-step PARALLEL_STEP] [--breakage-dist BREAKAGE_DIST] [--area_thresh AREA_THRESH] [--breakage-line-thresh BREAKAGE_LINE_THRESH] [--min-region-size MIN_REGION_SIZE] [--max-region-size MAX_REGION_SIZE] [--skip-grid-metrics]
{make-ome,generate-spatial-features,generate-region-features,show-channels}
