# Generated by Django 3.1.7 on 2021-04-10 20:14
import os
from sys import path

from django.db import migrations
from django.core import serializers


fixture_dir = os.path.abspath(os.path.join(os.path.dirname(__file__), "../fixtures"))
fixture_filename = "payment_systems.json"


def load_fixtures(apps, schema_editor):
    fixture_file = os.path.join(fixture_dir, fixture_filename)
    with open(fixture_file, "rb") as fib:
        objects = serializers.deserialize("json", fib, ignorenonexistent=True)
        for obj in objects:
            obj.save()


def unload_fixtures(apps, schema_editor):
    PaymentSystem = apps.get_model("moneta", "PaymentSystem")
    PaymentSystem.objects.all().delete()



class Migration(migrations.Migration):

    dependencies = [
        ('moneta', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(load_fixtures, reverse_code=unload_fixtures)
    ]
