# coding: utf-8

"""
    noia-controller

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import datetime
import unittest
from unittest import mock

from click.testing import CliRunner

import noia_sdk as sdk
from noia_sdk import utils as noiactl
from noia_sdk.rest import ApiException

from .test_data import *


class TestUtilsHappyPath(unittest.TestCase):
    def testPrintTable(self):
        items = [
            {"a": 123, "b": 321, "c": {"ac": 1, "bc": None}},
            {"a": 111, "b": 222},
        ]
        fields = [
            ("A", "a"),
            ("B", "b", lambda x: x * 10),
            ("C->A", ("c", "ac")),
            ("C->B", ("c", "bc")),
        ]
        table_mock = mock.Mock(spec=noiactl.PrettyTable)
        with mock.patch(
            "noia_sdk.utils.PrettyTable", return_value=table_mock
        ) as the_mock:
            noiactl.print_table(items, fields)
            assert table_mock.field_names == ["A", "B", "C->A", "C->B"]
            assert table_mock.add_row.call_args_list == [
                mock.call(
                    [123, 3210, 1, "-"],
                ),
                mock.call(
                    [111, 2220, "-", "-"],
                ),
            ]

    def testPrintTableJson(self):
        items = [
            {"a": 123, "b": 321, "c": {"ac": 1, "bc": None}},
            {"a": 111, "b": 222},
        ]
        fields = []
        table_mock = mock.Mock(spec=noiactl.json)
        with mock.patch(
            "noia_sdk.utils.json.dumps", return_value=table_mock
        ) as the_mock:
            noiactl.print_table(items, fields, to_json=True)
            the_mock.assert_called_once_with(items, indent=4)

    def testFindByName(self):
        items = [
            {"test_id": 1, "test_name": "name"},
            {"test_id": 2, "test_name": "name1"},
        ]
        assert noiactl.find_by_name(items, "name1", "test") == 2

    def testFindByNameList(self):
        items = [
            {"test_id": 1, "test_name": "name"},
            {"test_id": 2, "test_name": "name1"},
        ]
        assert noiactl.find_by_name(items, ["name1", "name"], "test") == [2, 1]

    def testFindByNameListNotFound(self):
        items = [
            {"test_id": 1, "test_name": "name"},
            {"test_id": 2, "test_name": "name1"},
        ]
        assert noiactl.find_by_name(items, ["test", "name1", "name"], "test") == [
            None,
            2,
            1,
        ]

    def testFindByNameNotFound(self):
        items = [
            {"test_id": 1, "test_name": "name"},
            {"test_id": 2, "test_name": "name1"},
        ]
        assert noiactl.find_by_name(items, "test3", "test") is None

    def testFindByNameNoField(self):
        items = [
            {"test_id": 1, "test_name": "name"},
            {"test_id": 2, "test_name": "name1"},
        ]
        assert noiactl.find_by_name(items, "test3", "test") is None

    def testWithRetrySuccess(self):
        assert noiactl.WithRetry(lambda x: x)(42) == 42

    def testWithRetryFailRetry(self):
        func = mock.Mock(
            side_effect=[ApiException(status=502), ApiException(status=503)]
        )
        func.__name__ = "test func"
        with self.assertRaises(noiactl.ApiException):
            noiactl.WithRetry(func, retry_count=2, cap=0.1)(42)
        assert func.call_args_list == [mock.call(42) for _ in range(2)]

    def testWithRetryFail(self):
        func = mock.Mock(side_effect=ValueError)
        with self.assertRaises(ValueError):
            noiactl.WithRetry(func, retry_count=2, cap=0.1)(42)
        func.assert_called_once_with(42)

    def testDetermineBatchSize(self):
        request = noiactl.BatchedRequest(lambda x: x, max_payload_size=5)
        assert request._determine_batch_size(
            None, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9], 10
        ) == (2, [0, 1])

    def testDetermineBatchSizeFail(self):
        request = noiactl.BatchedRequest(lambda x: x, max_payload_size=5)
        with self.assertRaises(noiactl.ConfigureNetworkError):
            request._determine_batch_size(
                None,
                [102400, 10000, 20000, 30000, 40000, 50000, 60000, 70000, 80000, 90000],
                10,
            )

    def testBatchedRequestQuery(self):
        func = mock.Mock(return_value={"data": [1, 2, 3]})
        assert noiactl.BatchedRequest(func, max_payload_size=5)(
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
        ) == {"data": [i + 1 for _ in range(5) for i in range(3)]}
        assert func.call_args_list == [
            mock.call([0, 1]),
            mock.call([2, 3]),
            mock.call([4, 5]),
            mock.call([6, 7]),
            mock.call([8, 9]),
        ]

    def testBatchedRequestQueryFull(self):
        func = mock.Mock(return_value={"data": [1, 2, 3]})
        assert noiactl.BatchedRequest(func, max_payload_size=20)(
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
        ) == {
            "data": [1, 2, 3],
        }
        assert func.call_args_list == [
            mock.call([0, 1, 2, 3, 4, 5, 6, 7, 8, 9]),
        ]

    def testBatchedRequestBody(self):
        func = mock.Mock(return_value={"data": [1, 2, 3]})
        assert noiactl.BatchedRequest(func, max_payload_size=30)(
            body={"data": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]}, param="param"
        ) == {"data": [1, 2, 3, 1, 2, 3]}
        assert func.call_args_list == [
            mock.call(body={"data": [0, 1, 2, 3, 4]}, param="param"),
            mock.call(body={"data": [5, 6, 7, 8, 9]}, param="param"),
        ]

    def testBatchedRequestBodyFull(self):
        func = mock.Mock(return_value={"data": [1, 2, 3]})
        assert noiactl.BatchedRequest(func, max_payload_size=100)(
            body={"data": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]}, param="param"
        ) == {"data": [1, 2, 3]}
        assert func.call_args_list == [
            mock.call(body={"data": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]}, param="param"),
        ]

    def testBatchedRequestBodyEmptyResult(self):
        func = mock.Mock(return_value=None)
        assert noiactl.BatchedRequest(
            func, translator=noiactl._default_translator("smth"), max_payload_size=100
        )(body={"id": 123, "smth": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]}, param="param") == {
            "data": [None]
        }
        assert func.call_args_list == [
            mock.call(
                body={"id": 123, "smth": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]}, param="param"
            ),
        ]


class TestNoiaConfigureHappyPath(unittest.TestCase):
    """noia-cli yaml configuration happy path unit tests"""

    def setUp(self):
        self.networks = [
            {
                "network_id": 1,
                "network_name": "test1",
                "network_type": "POINT_TO_POINT",
                "network_disable_sdn_connections": False,
                "network_metadata": {
                    "network_type": "P2P",
                },
            },
            {
                "network_id": 2,
                "network_name": "test2",
                "network_type": "POINT_TO_POINT",
                "network_disable_sdn_connections": False,
                "network_metadata": {
                    "network_type": "P2M",
                },
            },
            {
                "network_id": 3,
                "network_name": "test3",
                "network_type": "POINT_TO_POINT",
                "network_disable_sdn_connections": False,
                "network_metadata": {
                    "network_type": "MESH",
                },
            },
        ]
        self.connections = [
            {
                "agent_connection_id": 0,
                "network_id": 1,
                "agent_1_id": 1,
                "agent_2_id": 2,
                "agent_1": {"agent_id": 1, "agent_name": "agent1"},
                "agent_2": {"agent_id": 2, "agent_name": "agent2"},
            },
            {
                "agent_connection_id": 1,
                "network_id": 2,
                "agent_1_id": 1,
                "agent_2_id": 2,
                "agent_1": {"agent_id": 1, "agent_name": "agent1"},
                "agent_2": {"agent_id": 2, "agent_name": "agent2"},
            },
            {
                "agent_connection_id": 2,
                "network_id": 2,
                "agent_1_id": 3,
                "agent_2_id": 4,
                "agent_1": {"agent_id": 3, "agent_name": "agent3"},
                "agent_2": {"agent_id": 4, "agent_name": "agent4"},
            },
            {
                "agent_connection_id": 3,
                "network_id": 123,
                "agent_1_id": 123,
                "agent_2_id": 321,
                "agent_1": {"agent_id": 123, "agent_name": "agent123"},
                "agent_2": {"agent_id": 321, "agent_name": "agent321"},
            },
            {
                "agent_connection_id": 4,
                "network_id": 3,
                "agent_1_id": 1,
                "agent_2_id": 2,
                "agent_1": {"agent_id": 1, "agent_name": "agent1"},
                "agent_2": {"agent_id": 2, "agent_name": "agent2"},
            },
            {
                "agent_connection_id": 5,
                "network_id": 3,
                "agent_1_id": 3,
                "agent_2_id": 4,
                "agent_1": {"agent_id": 3, "agent_name": "agent3"},
                "agent_2": {"agent_id": 4, "agent_name": "agent4"},
            },
            {
                "agent_connection_id": 6,
                "network_id": 3,
                "agent_1_id": 2,
                "agent_2_id": 3,
                "agent_1": {"agent_id": 2, "agent_name": "agent2"},
                "agent_2": {"agent_id": 3, "agent_name": "agent3"},
            },
        ]
        self.api = mock.Mock(spec=sdk.PlatformApi)
        self.api.index_networks = mock.Mock(
            spec=sdk.PlatformApi.index_networks, return_value={"data": self.networks}
        )
        self.api.index_connections = mock.Mock(
            spec=sdk.PlatformApi.index_connections,
            return_value={"data": self.connections},
        )
        self.api.create_network = mock.Mock(
            spec=sdk.PlatformApi.create_network,
            return_value={"data": {"network_id": 321}},
        )
        self.api.create_connections = mock.Mock(
            spec=sdk.PlatformApi.create_connections,
            return_value={"data": CREATED_CONNECTIONS},
        )
        self.api.delete_connection = mock.Mock(spec=sdk.PlatformApi.delete_connection)
        self.api.delete_networks = mock.Mock(spec=sdk.PlatformApi.delete_networks)
        self.api.index_agents = mock.Mock(
            spec=sdk.PlatformApi.index_agents, side_effect=index_agents_stub
        )
        self.api.get_connection_services = mock.Mock(
            spec=sdk.PlatformApi.get_connection_services,
            side_effect=connection_services_stub,
        )
        self.api.update_connection_services = mock.Mock(
            spec=sdk.PlatformApi.update_connection_services,
        )

    def tearDown(self):
        pass

    @parametrize(
        [
            [noiactl.ConnectionServices(9, 22, [], []), ((23, False), (24, False))],
            [
                noiactl.ConnectionServices(9, 22, ["nats-streaming"], []),
                ((21, True), (22, True), (23, False), (24, False)),
            ],
            [noiactl.ConnectionServices(9, 22, [], ["sdn-pgadmin"]), ((23, False),)],
            [
                noiactl.ConnectionServices(9, 22, ["sdn-bi"], ["streaming"]),
                ((24, False), (25, True)),
            ],
            [
                noiactl.ConnectionServices(9, 22, ["missing-subnet"], []),
                ((23, False), (24, False), (123, True)),
            ],
            [
                noiactl.ConnectionServices(9, 22, [], ["missing-subnet"]),
                ((23, False), (24, False)),
            ],
            [
                noiactl.ConnectionServices(
                    9, 22, ["no-such-service"], ["no-such-service"]
                ),
                ((23, False), (24, False)),
            ],
        ]
    )
    def testConfigureConnection(self, config, result):
        connection = {
            **CONNECTION_SERVICES,
            "agent_connection_subnets": AGENT_CONNECTION_SUBNETS_2,
        }
        assert noiactl.configure_connection(
            self.api, config, connection, silent=False
        ) == len(result)
        assert self.api.update_connection_services.call_args_list[-1] == mock.call(
            body={
                "connectionId": 169,
                "changes": [
                    {"agentServiceSubnetId": id, "isEnabled": en} for id, en in result
                ],
            }
        )

    def testConfigureNetworkCreate(self):
        config = {"name": "test", "state": "present"}
        with mock.patch(
            "noia_sdk.utils.configure_network_create",
            autospec=True,
            return_value="changed",
        ) as the_mock:
            assert (
                noiactl.configure_network(self.api, config, "False", silent="silent")
                == "changed"
            )
            the_mock.assert_called_once_with(self.api, config, "False", silent="silent")

    def testConfigureNetworkDelete(self):
        config = {"name": "test2", "state": "absent"}
        with mock.patch(
            "noia_sdk.utils.configure_network_delete",
            autospec=True,
            return_value="changed",
        ) as the_mock:
            assert (
                noiactl.configure_network(self.api, config, "False", silent="silent")
                == "changed"
            )
            the_mock.assert_called_once_with(
                self.api,
                {
                    "name": "test2",
                    "id": 2,
                    "topology": "P2M",
                    "use_sdn": True,
                    "state": "present",
                },
                "False",
                silent="silent",
            )

    def testConfigureNetworkUpdate(self):
        config = {"name": "test2", "state": "present"}
        with mock.patch(
            "noia_sdk.utils.configure_network_update",
            autospec=True,
            return_value="changed",
        ) as the_mock:
            assert (
                noiactl.configure_network(self.api, config, "False", silent="silent")
                == "changed"
            )
            the_mock.assert_called_once_with(
                self.api,
                noiactl.transform_network(self.networks[1]),
                config,
                "False",
                silent="silent",
            )

    def testCreateNetworkDry(self):
        config = {
            "name": "test",
            "topology": "P2P",
            "state": "present",
            "connections": {
                "agent-1": {
                    "type": "endpoint",
                    "connect_to": {
                        "agent-2": {
                            "type": "endpoint",
                        }
                    },
                },
            },
        }
        with mock.patch(
            "noia_sdk.utils.resolve_p2p_connections",
            autospec=True,
            return_value=[[1, 2], [3, 4], []],
        ) as the_mock:
            assert noiactl.configure_network_create(self.api, config, True) == False
            assert self.api.create_network.call_count == 0
            assert self.api.create_connections.call_count == 0

    def testCreateNetworkP2P(self):
        config = {
            "name": "test",
            "topology": "P2P",
            "state": "present",
            "connections": {
                "agent-1": {
                    "type": "endpoint",
                    "connect_to": {
                        "agent-2": {
                            "type": "endpoint",
                        }
                    },
                },
                "agent-3": {
                    "type": "endpoint",
                    "connect_to": {
                        "agent-4": {
                            "type": "endpoint",
                        }
                    },
                },
            },
        }
        with mock.patch(
            "noia_sdk.utils.resolve_p2p_connections",
            autospec=True,
            return_value=([[1, 2], [3, 4]], [], []),
        ) as the_mock:
            with mock.patch(
                "noia_sdk.utils.configure_connections",
                autospec=True,
                return_value=(1, 3),
            ) as config_mock:
                assert noiactl.configure_network_create(self.api, config, False) == True
                the_mock.assert_called_once()
                assert self.api.create_network.call_args_list == [
                    mock.call(
                        body={
                            "network_name": "test",
                            "network_type": "POINT_TO_POINT",
                            "network_disable_sdn_connections": True,
                            "network_metadata": {
                                "network_created_by": "CONFIG",
                                "network_type": "P2P",
                            },
                        }
                    )
                ]
                assert self.api.create_connections.call_args_list == [
                    mock.call(
                        body={
                            "network_id": 321,
                            "agent_ids": [[1, 2], [3, 4]],
                            "network_update_by": "CONFIG",
                        }
                    )
                ]

    def testCreateNetworkP2M(self):
        config = {
            "name": "test",
            "topology": "p2m",
            "state": "present",
            "connections": {
                "agent-1": {
                    "type": "endpoint",
                    "connect_to": {
                        "agent-2": {
                            "type": "endpoint",
                        },
                        "agent-4": {
                            "type": "endpoint",
                        },
                        "agent-3": {
                            "type": "endpoint",
                        },
                    },
                },
            },
        }
        with mock.patch(
            "noia_sdk.utils.resolve_p2m_connections",
            autospec=True,
            return_value=([[1, 2], [3, 4]], [], []),
        ) as the_mock:
            with mock.patch(
                "noia_sdk.utils.configure_connections",
                autospec=True,
                return_value=(1, 3),
            ) as config_mock:
                assert noiactl.configure_network_create(self.api, config, False) == True
                assert self.api.create_network.call_args_list == [
                    mock.call(
                        body={
                            "network_name": "test",
                            "network_type": "POINT_TO_POINT",
                            "network_disable_sdn_connections": True,
                            "network_metadata": {
                                "network_created_by": "CONFIG",
                                "network_type": "P2M",
                            },
                        }
                    )
                ]
                assert self.api.create_connections.call_args_list == [
                    mock.call(
                        body={
                            "network_id": 321,
                            "agent_ids": [[1, 2], [3, 4]],
                            "network_update_by": "CONFIG",
                        }
                    )
                ]

    def testCreateNetworkMesh(self):
        config = {
            "name": "test",
            "topology": "mesh",
            "state": "present",
            "connections": {
                "agent-2": {
                    "type": "endpoint",
                },
                "agent-4": {
                    "type": "endpoint",
                },
                "agent-3": {
                    "type": "endpoint",
                },
            },
        }
        with mock.patch(
            "noia_sdk.utils.resolve_mesh_connections",
            autospec=True,
            return_value=([[1, 2], [1, 4], [2, 4]], [], []),
        ) as the_mock:
            with mock.patch(
                "noia_sdk.utils.configure_connections",
                autospec=True,
                return_value=(1, 3),
            ) as config_mock:
                assert noiactl.configure_network_create(self.api, config, False) == True
                assert self.api.create_network.call_args_list == [
                    mock.call(
                        body={
                            "network_name": "test",
                            "network_type": "POINT_TO_POINT",
                            "network_disable_sdn_connections": True,
                            "network_metadata": {
                                "network_created_by": "CONFIG",
                                "network_type": "MESH",
                            },
                        }
                    )
                ]
                assert self.api.create_connections.call_args_list == [
                    mock.call(
                        body={
                            "network_id": 321,
                            "agent_ids": [[1, 2], [1, 4], [2, 4]],
                            "network_update_by": "CONFIG",
                        }
                    )
                ]

    def testDeleteNetworkDry(self):
        assert (
            noiactl.configure_network_delete(
                self.api, noiactl.transform_network(self.networks[1]), True
            )
            == False
        )
        assert self.api.delete_networks.call_count == 0
        assert self.api.delete_connection.call_count == 0

    def testDeleteNetwork(self):
        assert (
            noiactl.configure_network_delete(
                self.api, noiactl.transform_network(self.networks[1]), False
            )
            == True
        )
        assert self.api.delete_networks.call_args_list == [mock.call(2)]
        assert self.api.delete_connection.call_args_list == [
            mock.call(1),
            mock.call(2),
        ]

    def testUpdateNetworkDryP2P(self):
        config = {
            "name": "test1",
            "topology": "p2p",
            "state": "present",
            "connections": {
                "agent1": {
                    "connect_to": {
                        "agent2": {},
                    }
                },
                "agent3": {
                    "state": "absent",
                    "connect_to": {
                        "agent4": {},
                    },
                },
                "agent5": {"connect_to": {"agent6": {}}},
            },
        }
        assert (
            noiactl.configure_network_update(
                self.api, noiactl.transform_network(self.networks[0]), config, True
            )
            == False
        )
        assert self.api.index_connections.call_count == 1
        assert self.api.create_network.call_count == 0
        assert self.api.delete_connection.call_count == 0
        assert self.api.create_connections.call_count == 0

    def testUpdateNetworkP2MDry(self):
        config = {
            "name": "test2",
            "topology": "p2m",
            "state": "present",
            "connections": {
                "agent1": {
                    "connect_to": {
                        "agent2": {"state": "absent"},
                        "agent3": {},
                        "agent4": {},
                    }
                },
                "agent5": {"connect_to": {"agent6": {}}},
            },
        }
        assert (
            noiactl.configure_network_update(
                self.api, noiactl.transform_network(self.networks[1]), config, True
            )
            == False
        )
        assert self.api.index_connections.call_count == 1
        assert self.api.create_network.call_count == 0
        assert self.api.delete_connection.call_count == 0
        assert self.api.create_connections.call_count == 0

    def testUpdateNetworkMeshDry(self):
        config = {
            "name": "test3",
            "topology": "mesh",
            "state": "present",
            "connections": {
                "agent1": {
                    "state": "present",
                },
                "agent2": {
                    "state": "absent",
                },
                "agent3": {
                    "state": "present",
                },
                "agent4": {
                    "state": "present",
                },
            },
        }
        assert (
            noiactl.configure_network_update(
                self.api, noiactl.transform_network(self.networks[2]), config, True
            )
            == False
        )
        assert self.api.index_connections.call_count == 1
        assert self.api.create_network.call_count == 0
        assert self.api.delete_connection.call_count == 0
        assert self.api.create_connections.call_count == 0

    def testUpdateNetworkP2P(self):
        config = {
            "name": "test1",
            "topology": "p2p",
            "state": "present",
            "connections": {
                "agent1": {
                    "state": "absent",
                    "connect_to": {
                        "agent2": {},
                    },
                },
                "agent5": {"connect_to": {"agent6": {}}},
            },
        }
        with mock.patch(
            "noia_sdk.utils.configure_connections",
            autospec=True,
            return_value=(1, 3),
        ) as config_mock:
            assert (
                noiactl.configure_network_update(
                    self.api, noiactl.transform_network(self.networks[0]), config, False
                )
                == True
            )
            assert self.api.index_connections.call_count == 1
            assert self.api.create_network.call_count == 0
            assert self.api.delete_connection.call_args_list == [
                mock.call(0),
            ]
            assert self.api.create_connections.call_args_list == [
                mock.call(
                    body={
                        "network_id": 1,
                        "agent_ids": [[5, 6]],
                        "network_update_by": "CONFIG",
                    },
                    update_type=sdk.UpdateType.APPEND_NEW,
                )
            ]

    def testUpdateNetworkP2M(self):
        config = {
            "name": "test2",
            "topology": "p2m",
            "state": "present",
            "connections": {
                "agent1": {
                    "connect_to": {
                        "agent2": {"state": "absent"},
                        "agent3": {},
                        "agent4": {},
                    }
                },
                "agent5": {"connect_to": {"agent6": {}}},
            },
        }
        with mock.patch(
            "noia_sdk.utils.configure_connections",
            autospec=True,
            return_value=(1, 3),
        ) as config_mock:
            assert (
                noiactl.configure_network_update(
                    self.api, noiactl.transform_network(self.networks[1]), config, False
                )
                == True
            )
            assert self.api.index_connections.call_count == 1
            assert self.api.create_network.call_count == 0
            assert self.api.delete_connection.call_args_list == [
                mock.call(1),
            ]
            assert self.api.create_connections.call_args_list == [
                mock.call(
                    body={
                        "network_id": 2,
                        "agent_ids": [[1, 3], [1, 4], [5, 6]],
                        "network_update_by": "CONFIG",
                    },
                    update_type=sdk.UpdateType.APPEND_NEW,
                )
            ]

    def testUpdateNetworkMesh(self):
        config = {
            "name": "test3",
            "topology": "mesh",
            "state": "present",
            "connections": {
                "agent1": {
                    "state": "present",
                },
                "agent2": {
                    "state": "absent",
                },
                "agent3": {
                    "state": "present",
                },
                "agent5": {
                    "state": "present",
                },
            },
        }
        with mock.patch(
            "noia_sdk.utils.configure_connections",
            autospec=True,
            return_value=(1, 3),
        ) as config_mock:
            assert (
                noiactl.configure_network_update(
                    self.api, noiactl.transform_network(self.networks[2]), config, False
                )
                == True
            )
            assert self.api.index_connections.call_count == 1
            assert self.api.create_network.call_count == 0
            assert self.api.delete_connection.call_args_list == [
                mock.call(4),
                mock.call(6),
            ]
            assert self.api.create_connections.call_args_list == [
                mock.call(
                    body={
                        "network_id": 3,
                        "agent_ids": [[1, 5], [3, 5]],
                        "network_update_by": "CONFIG",
                    },
                    update_type=sdk.UpdateType.APPEND_NEW,
                )
            ]


class TestNetworkResolvers(unittest.TestCase):
    def setUp(self):
        self.api = mock.Mock(spec=sdk.PlatformApi)
        self.api.index_agents = mock.Mock(
            spec=sdk.PlatformApi.index_agents,
            side_effect=index_agents_stub,
        )
        self.api.get_connection_services = mock.Mock(
            spec=sdk.PlatformApi.get_connection_services,
            side_effect=connection_services_stub,
        )

    def testResolvePresentAbsent(self):
        agents = {f"agent {i}": i for i in range(5)}
        config_connections = list(CONFIG_CONNECTIONS.items())
        present = [
            (config_connections[0], config_connections[1]),
            (config_connections[0], config_connections[2]),
            (config_connections[3], config_connections[4]),
        ]
        absent = [
            (config_connections[0], config_connections[2]),
        ]
        assert noiactl.resolve_present_absent(agents, present, absent) == (
            [[0, 1], [3, 4]],
            [[0, 2]],
            [
                noiactl.ConnectionServices(0, 1, ["a", "b"], ["b", "c"]),
                noiactl.ConnectionServices(3, 4, ["f", "g"], ["h", "i"]),
            ],
        )

    def testResolvePresentAbsentNoServices(self):
        agents = {f"agent {i}": i for i in range(5)}
        present = [
            (
                ("agent 0", {}),
                ("agent 1", {"services": None}),
            ),
        ]
        absent = []
        assert noiactl.resolve_present_absent(agents, present, absent) == (
            [[0, 1]],
            [],
            [noiactl.ConnectionServices(0, 1, [], [])],
        )

    def testResolvePresentAbsentStrServices(self):
        agents = {f"agent {i}": i for i in range(5)}
        present = [
            (
                ("agent 0", {}),
                ("agent 1", {"services": "nginx"}),
            ),
        ]
        absent = []
        assert noiactl.resolve_present_absent(agents, present, absent) == (
            [[0, 1]],
            [],
            [noiactl.ConnectionServices(0, 1, [], ["nginx"])],
        )

    def testResolvePresentAbsentBadServices(self):
        agents = {f"agent {i}": i for i in range(5)}
        present = [
            (
                ("agent 0", {}),
                ("agent 1", {"services": {}}),
            ),
        ]
        absent = []
        with self.assertRaises(noiactl.ConfigureNetworkError):
            noiactl.resolve_present_absent(agents, present, absent)

    def testExpandAgentsTagsPresent(self):
        config = {
            "test": {
                "type": "tag",
                "state": "present",
            },
        }
        assert noiactl.expand_agents_tags(self.api, config) == {
            "filter - tags_names[]:test 0": {
                "type": "endpoint",
                "state": "present",
                "id": 170,
                "services": None,
            },
            "filter - tags_names[]:test 1": {
                "type": "endpoint",
                "state": "present",
                "id": 171,
                "services": None,
            },
            "filter - tags_names[]:test 2": {
                "type": "endpoint",
                "state": "present",
                "id": 172,
                "services": None,
            },
        }

    def testExpandAgentsTagsPresentServices(self):
        config = {
            "test": {
                "type": "tag",
                "state": "present",
                "services": ["a", "b"],
            },
        }
        assert noiactl.expand_agents_tags(self.api, config) == {
            "filter - tags_names[]:test 0": {
                "type": "endpoint",
                "state": "present",
                "id": 170,
                "services": ["a", "b"],
            },
            "filter - tags_names[]:test 1": {
                "type": "endpoint",
                "state": "present",
                "id": 171,
                "services": ["a", "b"],
            },
            "filter - tags_names[]:test 2": {
                "type": "endpoint",
                "state": "present",
                "id": 172,
                "services": ["a", "b"],
            },
        }

    def testExpandAgentsTagsExceptOne(self):
        config = {
            "test": {
                "type": "tag",
                "state": "present",
                "services": ["a", "b"],
            },
            "filter - tags_names[]:test 1": {
                "type": "endpoint",
                "state": "absent",
                "services": ["c", "d"],
            },
        }
        assert noiactl.expand_agents_tags(self.api, config) == {
            "filter - tags_names[]:test 0": {
                "type": "endpoint",
                "state": "present",
                "services": ["a", "b"],
                "id": 170,
            },
            "filter - tags_names[]:test 1": {
                "type": "endpoint",
                "state": "absent",
                "services": ["c", "d"],
            },
            "filter - tags_names[]:test 2": {
                "type": "endpoint",
                "state": "present",
                "services": ["a", "b"],
                "id": 172,
            },
        }

    def testExpandAgentsTagsExceptTag(self):
        config = {
            "test": {
                "type": "tag",
                "state": "present",
                "services": ["a", "b"],
            },
            "test1": {
                "type": "tag",
                "state": "absent",
                "services": ["c", "d"],
            },
        }

        def index_agents(filter=None, take=None):
            if "test1" in filter:
                return {
                    "data": [
                        {
                            "agent_name": f"test {i}",
                            "agent_id": i,
                        }
                        for i in range(3)
                    ]
                }
            else:
                return {
                    "data": [
                        {
                            "agent_name": f"test {i}",
                            "agent_id": i,
                        }
                        for i in range(2, 5)
                    ]
                }

        self.api.index_agents.side_effect = index_agents
        assert noiactl.expand_agents_tags(self.api, config) == {
            "test 0": {
                "type": "endpoint",
                "state": "absent",
                "id": 0,
                "services": ["c", "d"],
            },
            "test 1": {
                "type": "endpoint",
                "state": "absent",
                "id": 1,
                "services": ["c", "d"],
            },
            "test 2": {
                "type": "endpoint",
                "state": "absent",
                "id": 2,
                "services": ["c", "d"],
            },
            "test 3": {
                "type": "endpoint",
                "state": "present",
                "id": 3,
                "services": ["a", "b"],
            },
            "test 4": {
                "type": "endpoint",
                "state": "present",
                "id": 4,
                "services": ["a", "b"],
            },
        }

    def testResolveP2PConnections(self):
        connections = {
            "agent1": {
                "connect_to": {
                    "agent2": {},
                    "services": None,
                },
                "services": ["a", "b"],
            },
            "agent3": {"connect_to": {"4": {"type": "id", "services": "nginx"}}},
            "agent4": {"state": "absent", "connect_to": {"agent1": {}}},
            "2": {"type": "id", "connect_to": {"agent4": {"state": "absent"}}},
        }
        assert noiactl.resolve_p2p_connections(self.api, connections) == (
            [[1, 2], [3, 4]],
            [[4, 1], [2, 4]],
            [
                noiactl.ConnectionServices(1, 2, ["a", "b"], []),
                noiactl.ConnectionServices(3, 4, [], ["nginx"]),
            ],
        )

    def testResolveP2MConnections(self):
        connections = {
            "agent1": {
                "connect_to": {
                    "agent2": {"services": "postgre"},
                    "agent3": {},
                    "agent4": {"state": "absent"},
                },
                "services": "nginx",
            },
            "2": {
                "state": "absent",
                "type": "id",
                "connect_to": {
                    "agent5": {},
                    "6": {"type": "id"},
                },
            },
        }
        assert noiactl.resolve_p2m_connections(self.api, connections) == (
            [[1, 2], [1, 3]],
            [[1, 4], [2, 5], [2, 6]],
            [
                noiactl.ConnectionServices(1, 2, ["nginx"], ["postgre"]),
                noiactl.ConnectionServices(1, 3, ["nginx"], []),
            ],
        )

    def testResolveP2MConnectionsTags(self):
        connections = {
            "agent1": {
                "connect_to": {
                    "tag": {"type": "tag", "services": ["a", "b"]},
                },
                "services": "nginx",
            },
            "agent2": {
                "connect_to": {
                    "tag1": {"type": "tag", "state": "absent"},
                }
            },
        }
        assert noiactl.resolve_p2m_connections(self.api, connections) == (
            [[1, 160], [1, 161], [1, 162]],
            [[2, 170], [2, 171], [2, 172]],
            [
                noiactl.ConnectionServices(1, 160, ["nginx"], ["a", "b"]),
                noiactl.ConnectionServices(1, 161, ["nginx"], ["a", "b"]),
                noiactl.ConnectionServices(1, 162, ["nginx"], ["a", "b"]),
            ],
        )

    def testResolveP2MConnectionsTagsNotFound(self):
        connections = {
            "agent1": {
                "connect_to": {
                    "tag": {"type": "tag"},
                }
            },
            "agent2": {
                "connect_to": {
                    "tag1": {"type": "tag", "state": "absent"},
                }
            },
        }
        with mock.patch(
            "noia_sdk.utils.expand_agents_tags", autospec=True, return_value=None
        ) as the_mock:
            assert noiactl.resolve_p2m_connections(self.api, connections) == (
                [],
                [],
                [],
            )
            the_mock.assert_called_once()

    def testResolveMeshConnections(self):
        connections = {
            "agent1": {"services": "a"},
            "agent2": {"services": "b"},
            "3": {"type": "id", "services": "c"},
            "agent4": {"state": "absent"},
        }
        assert noiactl.resolve_mesh_connections(self.api, connections) == (
            [[1, 2], [1, 3], [2, 3]],
            [[1, 4], [2, 4], [3, 4]],
            [
                noiactl.ConnectionServices(1, 2, ["a"], ["b"]),
                noiactl.ConnectionServices(1, 3, ["a"], ["c"]),
                noiactl.ConnectionServices(2, 3, ["b"], ["c"]),
            ],
        )

    def testResolveMeshConnectionsTag(self):
        connections = {
            "tag1": {"type": "tag"},
            "iot": {"type": "tag"},
        }
        assert noiactl.resolve_mesh_connections(self.api, connections) == (
            [
                [170, 171],
                [170, 172],
                [170, 160],
                [170, 161],
                [170, 162],
                [171, 172],
                [171, 160],
                [171, 161],
                [171, 162],
                [172, 160],
                [172, 161],
                [172, 162],
                [160, 161],
                [160, 162],
                [161, 162],
            ],
            [],
            mock.ANY,
        )

    def testResolveMeshConnectionsTagsNotFound(self):
        connections = {
            "tag1": {"type": "tag"},
            "iot": {"type": "tag"},
        }
        with mock.patch(
            "noia_sdk.utils.expand_agents_tags", autospec=True, return_value=None
        ) as the_mock:
            assert noiactl.resolve_mesh_connections(self.api, connections) == (
                [],
                [],
                [],
            )
            the_mock.assert_called_once()


class TestNetworkTransformers(unittest.TestCase):
    def setUp(self):
        self.all_agents = {
            agent["agent_id"]: agent for agent in index_agents_stub()["data"]
        }

    def update_all_tags(self, connections):
        for i in connections:
            if "agent_tags" in i["agent_1"]:
                self.all_agents[i["agent_1"]["agent_id"]]["agent_tags"] = i["agent_1"][
                    "agent_tags"
                ]
            if "agent_tags" in i["agent_2"]:
                self.all_agents[i["agent_2"]["agent_id"]]["agent_tags"] = i["agent_2"][
                    "agent_tags"
                ]

    def testGetEnabledConnectionSubnets1(self):
        connection = {
            "agent_connection_services": {
                **CONNECTION_SERVICES,
                "agent_connection_subnets": AGENT_CONNECTION_SUBNETS_1,
            }
        }
        assert noiactl.get_enabled_connection_subnets(connection) == {21, 23, 24, 25}

    def testGetEnabledConnectionSubnets2(self):
        connection = {
            "agent_connection_services": {
                **CONNECTION_SERVICES,
                "agent_connection_subnets": AGENT_CONNECTION_SUBNETS_2,
            }
        }
        assert noiactl.get_enabled_connection_subnets(connection) == {23, 24}

    def testTransformConnectionServices(self):
        connection = {
            "agent_connection_services": {
                **CONNECTION_SERVICES,
                "agent_connection_subnets": AGENT_CONNECTION_SUBNETS_1,
            }
        }
        assert noiactl.transform_connection_services(connection) == (
            {"sdn-bi", "nats-streaming"},
            {"sdn-pgadmin", "streaming"},
        )

    def testTransformNetwork(self):
        assert noiactl.transform_network(INDEX_NETWORKS["data"][0]) == {
            "name": "skip",
            "id": 321,
            "topology": "P2P",
            "use_sdn": True,
            "state": "present",
        }

    def testTransformNetworkTopologyMesh(self):
        assert noiactl.transform_network(INDEX_NETWORKS["data"][1]) == {
            "name": "test",
            "id": 123,
            "topology": "MESH",
            "use_sdn": True,
            "state": "present",
        }

    def testTransformNetworkTypeMesh(self):
        assert noiactl.transform_network(INDEX_NETWORKS["data"][2]) == {
            "name": "test",
            "id": 456,
            "topology": "MESH",
            "use_sdn": True,
            "state": "present",
        }

    def testTransformConnectionsP2P(self):
        assert noiactl.transform_connections(
            self.all_agents, P2P_CONNECTIONS, "P2P"
        ) == {
            "de-hetzner-db01": {
                "type": "endpoint",
                "id": 1,
                "state": "present",
                "services": [],
                "connect_to": {
                    "de-aws-be01": {
                        "type": "endpoint",
                        "services": [],
                        "id": 2,
                    },
                },
            },
            "de-aws-lb01": {
                "type": "endpoint",
                "state": "present",
                "services": [],
                "id": 3,
                "connect_to": {
                    "kr-aws-dns01": {
                        "type": "endpoint",
                        "services": [],
                        "id": 4,
                    },
                },
            },
        }

    def testTransformConnectionsP2M(self):
        assert noiactl.transform_connections(
            self.all_agents, P2M_CONNECTIONS, "P2M"
        ) == {
            "auto gen 1": {
                "type": "endpoint",
                "id": 1,
                "state": "present",
                "services": [],
                "connect_to": {
                    "auto gen 4": {
                        "state": "present",
                        "id": 4,
                        "type": "endpoint",
                        "services": [],
                    },
                    "auto gen 5": {
                        "state": "present",
                        "id": 5,
                        "type": "endpoint",
                        "services": [],
                    },
                    "auto gen 6": {
                        "state": "present",
                        "id": 6,
                        "type": "endpoint",
                        "services": [],
                    },
                },
            },
        }

    def testTransformConnectionsP2MReversed(self):
        connections = [
            {
                **i,
                "agent_1": i["agent_2"],
                "agent_2": i["agent_1"],
            }
            for i in P2M_CONNECTIONS
        ]
        assert noiactl.transform_connections(self.all_agents, connections, "P2M") == {
            "auto gen 1": {
                "type": "endpoint",
                "id": 1,
                "state": "present",
                "services": [],
                "connect_to": {
                    "auto gen 4": {
                        "state": "present",
                        "id": 4,
                        "type": "endpoint",
                        "services": [],
                    },
                    "auto gen 5": {
                        "state": "present",
                        "id": 5,
                        "type": "endpoint",
                        "services": [],
                    },
                    "auto gen 6": {
                        "state": "present",
                        "id": 6,
                        "type": "endpoint",
                        "services": [],
                    },
                },
            },
        }

    def testTransformConnectionsP2MTagged(self):
        connections = [
            {
                **i,
                "agent_2": {
                    **i["agent_2"],
                    "agent_tags": [
                        {"agent_tag_name": "test"},
                    ],
                },
            }
            for i in P2M_CONNECTIONS
        ]
        self.update_all_tags(connections)
        assert noiactl.transform_connections(self.all_agents, connections, "P2M") == {
            "auto gen 1": {
                "type": "endpoint",
                "id": 1,
                "state": "present",
                "services": [],
                "connect_to": {
                    "test": {
                        "state": "present",
                        "type": "tag",
                        "services": [],
                    },
                },
            },
        }

    def testTransformConnectionsP2MTaggedMultiple(self):
        connections = [
            {
                **i,
                "agent_2": {
                    **i["agent_2"],
                    "agent_tags": [
                        {"agent_tag_name": "test"},
                        {"agent_tag_name": "TEST"},
                    ],
                },
            }
            for i in P2M_CONNECTIONS
        ]
        self.update_all_tags(connections)
        assert noiactl.transform_connections(self.all_agents, connections, "P2M") == {
            "auto gen 1": {
                "type": "endpoint",
                "id": 1,
                "state": "present",
                "services": [],
                "connect_to": {
                    "test": {
                        "state": "present",
                        "type": "tag",
                        "services": [],
                    },
                    "TEST": {
                        "state": "present",
                        "type": "tag",
                        "services": [],
                    },
                },
            },
        }

    def testTransformConnectionsMesh(self):
        assert noiactl.transform_connections(
            self.all_agents, MESH_CONNECTIONS, "MESH"
        ) == {
            "auto gen 10": {
                "type": "endpoint",
                "state": "present",
                "services": [],
                "id": 10,
            },
            "auto gen 11": {
                "type": "endpoint",
                "state": "present",
                "services": [],
                "id": 11,
            },
            "auto gen 12": {
                "type": "endpoint",
                "state": "present",
                "services": [],
                "id": 12,
            },
            "auto gen 13": {
                "type": "endpoint",
                "state": "present",
                "services": [],
                "id": 13,
            },
        }

    def testTransformConnectionsMeshTaggedMultiple(self):
        connections = [
            {
                **i,
                "agent_1": {
                    **i["agent_1"],
                    "agent_tags": [
                        {"agent_tag_name": "test"},
                        {"agent_tag_name": "TEST"},
                    ],
                },
                "agent_2": {
                    **i["agent_2"],
                    "agent_tags": [
                        {"agent_tag_name": "test"},
                        {"agent_tag_name": "TEST"},
                    ],
                },
            }
            for i in MESH_CONNECTIONS
        ]
        self.update_all_tags(connections)
        assert noiactl.transform_connections(self.all_agents, connections, "MESH") == {
            "test": {
                "type": "tag",
                "state": "present",
                "services": [],
            },
            "TEST": {
                "type": "tag",
                "state": "present",
                "services": [],
            },
        }

    def testGroupAgentsByTags(self):
        agents = {
            1: {
                "agent_id": 1,
                "agent_name": "a",
                "agent_tags": [{"agent_tag_id": 1, "agent_tag_name": "test"}],
            },
            2: {
                "agent_id": 2,
                "agent_name": "b",
                "agent_tags": [{"agent_tag_id": 1, "agent_tag_name": "test"}],
            },
            3: {
                "agent_id": 3,
                "agent_name": "c",
                "agent_tags": [
                    {"agent_tag_id": 1, "agent_tag_name": "test"},
                    {"agent_tag_id": 2, "agent_tag_name": "TEST"},
                ],
            },
            4: {
                "agent_id": 4,
                "agent_name": "d",
                "agent_tags": [{"agent_tag_id": 1, "agent_tag_name": "TEST"}],
            },
            5: {"agent_id": 5, "agent_name": "e", "agent_tags": []},
            6: {
                "agent_id": 6,
                "agent_name": "f",
                "agent_tags": [{"agent_tag_id": 1, "agent_tag_name": "TEST"}],
            },
        }
        endpoints = {
            "a": {"id": 1, "type": "endpoint", "services": ["a"]},
            "b": {"id": 2, "type": "endpoint", "services": ["b"]},
            "c": {"id": 3, "type": "endpoint", "services": ["c"]},
            "d": {"id": 4, "type": "endpoint"},
            "e": {"id": 5, "type": "endpoint", "services": ["d"]},
        }
        assert noiactl.group_agents_by_tags(agents, endpoints) == {
            "test": {
                "type": "tag",
                "state": "present",
                "services": EqualSets({"a", "b", "c"}),
            },
            "d": {
                "type": "endpoint",
                "id": 4,
                "state": "present",
                "services": [],
            },
            "e": {
                "type": "endpoint",
                "id": 5,
                "state": "present",
                "services": ["d"],
            },
        }


if __name__ == "__main__":
    unittest.main()
