# coding: utf-8

"""
    noia-controller

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import datetime
import os
import unittest
from unittest import mock

from click.testing import CliRunner

import noia_sdk as sdk
from noia_sdk import __main__ as noiactl
from noia_sdk.rest import ApiException

from .test_data import *


@mock.patch.dict(os.environ, {"NOIA_API_SERVER": "server"})
class TestNoiaCliHappyPath(unittest.TestCase):
    """noia-cli happy path unit tests"""

    def setUp(self):
        self.runner = CliRunner()
        # NOTE: Until swagger codegen releases the fix for this, we need to remove __del__
        # method for tests. Keep in mind that async calls might work in unexpected ways with this fix.
        self.api_del = noiactl.sdk.ApiClient.__del__
        noiactl.sdk.ApiClient.__del__ = lambda x: x

    def collect_endpoint_services(self):
        agent_services = [
            {"agent_service_name": "nginx"},
            {"agent_service_name": "postgre"},
        ]
        assert noiactl.collect_endpoint_services(agent_services) == "nginx, postgre"

    def collect_connection_services(self):
        connection_services = {
            "agent_connection_subnets": [
                {
                    "agent_connection_subnet_is_enabled": True,
                    "agent_service_subnet_id": 1,
                    "agent_connection_subnet_status": "PENDING",
                },
                {
                    "agent_connection_subnet_is_enabled": True,
                    "agent_service_subnet_id": 2,
                    "agent_connection_subnet_status": "WARNING",
                },
                {
                    "agent_connection_subnet_is_enabled": True,
                    "agent_service_subnet_id": 3,
                    "agent_connection_subnet_status": "ERROR",
                },
                {
                    "agent_connection_subnet_is_enabled": True,
                    "agent_service_subnet_id": 4,
                    "agent_connection_subnet_status": "CONNECTED",
                },
                {
                    "agent_connection_subnet_is_enabled": True,
                    "agent_service_subnet_id": 5,
                    "agent_connection_subnet_status": "OFFLINE",
                },
                {
                    "agent_connection_subnet_is_enabled": True,
                    "agent_service_subnet_id": 6,
                    "agent_connection_subnet_status": "something else",
                },
                {
                    "agent_connection_subnet_is_enabled": False,
                    "agent_service_subnet_id": 8,
                    "agent_connection_subnet_status": "PENDING",
                },
            ],
            "agent_1": {
                "agent_services": {
                    "agent_service_subnets": [
                        {"agent_service_subnet_id": 1, "agent_service_name": "a"},
                        {"agent_service_subnet_id": 2, "agent_service_name": "b"},
                        {"agent_service_subnet_id": 3, "agent_service_name": "c"},
                    ],
                },
            },
            "agent_2": {
                "agent_services": {
                    "agent_service_subnets": [
                        {"agent_service_subnet_id": 4, "agent_service_name": "d"},
                        {"agent_service_subnet_id": 5, "agent_service_name": "e"},
                        {"agent_service_subnet_id": 6, "agent_service_name": "f"},
                    ],
                },
            },
        }
        assert (
            noiactl.collect_connection_services(connection_services)
            == "a~, b*, c!, d^, e#, f?"
        )

    def testLogin(self):
        with mock.patch.object(
            noiactl.sdk.AuthApi,
            "local",
            autospec=True,
            return_value={"refresh_token": "token"},
        ) as the_mock:
            result = self.runner.invoke(noiactl.login, ["username", "password"])
            assert result.stdout.rstrip() == "token"
            the_mock.assert_called_once_with(
                mock.ANY,
                body={
                    "user_email": "username",
                    "user_password": "password",
                    "additionalProp1": {},
                },
            )

    def testGetApiKeys(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "index_api_key",
            autospec=True,
            return_value={"data": []},
        ) as index_mock:
            with mock.patch(
                "noia_sdk.__main__.print_table",
                autospec=True,
            ) as print_table_mock:
                self.runner.invoke(noiactl.get_api_keys)
                index_mock.assert_called_once()
                print_table_mock.assert_called_once()

    def testCreateApiKey(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "create_api_key",
            autospec=True,
            return_value={"data": {"api_key_id": 123}},
        ) as the_mock:
            self.runner.invoke(
                noiactl.create_api_key, ["name", "2021-10-11 20:20:21", "--suspended"]
            )
            the_mock.assert_called_once_with(
                mock.ANY,
                body={
                    "api_key_name": "name",
                    "api_key_is_suspended": True,
                    "api_key_valid_until": datetime.datetime(2021, 10, 11, 20, 20, 21),
                },
            )

    def testDeleteApiKeyById(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi, "delete_api_key", autospec=True
        ) as the_mock:
            self.runner.invoke(noiactl.delete_api_key, ["--id", "123"])
            the_mock.assert_called_once_with(mock.ANY, 123)

    def testDeleteApiKeyByName(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "index_api_key",
            autospec=True,
            return_value={
                "data": [
                    {"api_key_name": "skip", "api_key_id": 321},
                    {"api_key_name": "test", "api_key_id": 123},
                ]
            },
        ) as index_mock:
            with mock.patch.object(
                noiactl.sdk.PlatformApi, "delete_api_key", autospec=True
            ) as the_mock:
                self.runner.invoke(noiactl.delete_api_key, ["--name", "test"])
                the_mock.assert_called_once_with(mock.ANY, 123)
                index_mock.assert_called_once()

    def testGetEndpoints(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "index_agents",
            autospec=True,
            return_value={"data": []},
        ) as index_mock:
            with mock.patch(
                "noia_sdk.__main__.print_table",
                autospec=True,
            ) as print_table_mock:
                self.runner.invoke(noiactl.get_endpoints)
                index_mock.assert_called_once()
                print_table_mock.assert_called_once()

    def testGetEndpointsServices(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "index_agents",
            autospec=True,
            return_value={
                "data": [
                    {
                        "agent_id": 123,
                    }
                ]
            },
        ) as index_mock:
            with mock.patch.object(
                noiactl.sdk.PlatformApi,
                "get_agent_services_with_subnets",
                autospec=True,
                return_value={"data": []},
            ) as services_mock:
                with mock.patch(
                    "noia_sdk.__main__.print_table",
                    autospec=True,
                ) as print_table_mock:
                    self.runner.invoke(noiactl.get_endpoints, "--show-services")
                    index_mock.assert_called_once()
                    services_mock.assert_called_once_with(mock.ANY, [123])
                    print_table_mock.assert_called_once()

    def testGetTopology(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "topology_networks",
            autospec=True,
            return_value={"data": []},
        ) as index_mock:
            with mock.patch(
                "noia_sdk.__main__.print_table",
                autospec=True,
            ) as print_table_mock:
                self.runner.invoke(noiactl.get_topology)
                index_mock.assert_called_once()
                print_table_mock.assert_called_once()

    def testGetConnections(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "index_connections",
            autospec=True,
            return_value={"data": []},
        ) as index_mock:
            with mock.patch(
                "noia_sdk.__main__.print_table",
                autospec=True,
            ) as print_table_mock:
                self.runner.invoke(noiactl.get_connections)
                index_mock.assert_called_once()
                print_table_mock.assert_called_once()

    def testGetConnectionsServices(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "index_connections",
            autospec=True,
            return_value={"data": [{"agent_connection_id": 123}]},
        ) as index_mock:
            with mock.patch.object(
                noiactl.sdk.PlatformApi,
                "get_connection_services",
                autospec=True,
                return_value={"data": [{"agent_connection_id": 123}]},
            ) as services_mock:
                with mock.patch(
                    "noia_sdk.__main__.print_table",
                    autospec=True,
                ) as print_table_mock:
                    self.runner.invoke(noiactl.get_connections, "--show-services")
                    index_mock.assert_called_once()
                    services_mock.assert_called_once_with(mock.ANY, [123])
                    print_table_mock.assert_called_once()

    def testCreateConnectionsP2P(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "index_networks",
            autospec=True,
            return_value={
                "data": [{"network_id": 123, "network_type": "POINT_TO_POINT"}]
            },
        ) as index_mock:
            with mock.patch.object(
                noiactl.sdk.PlatformApi,
                "create_connections",
                autospec=True,
                return_value={"data": []},
            ) as the_mock:
                with mock.patch(
                    "noia_sdk.__main__.print_table",
                    autospec=True,
                ) as print_table_mock:
                    self.runner.invoke(
                        noiactl.create_connections, ["123", "1", "2", "3", "4"]
                    )
                    index_mock.assert_called_once()
                    the_mock.assert_called_once_with(
                        mock.ANY,
                        body={
                            "network_id": 123,
                            "agent_ids": [(1, 2), (3, 4)],
                            "network_update_by": sdk.NetworkGenesisType.SDK,
                        },
                    )
                    print_table_mock.assert_called_once()

    def testCreateConnectionsMesh(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "index_networks",
            autospec=True,
            return_value={"data": [{"network_id": 123, "network_type": "MESH"}]},
        ) as index_mock:
            with mock.patch.object(
                noiactl.sdk.PlatformApi,
                "create_connections",
                autospec=True,
                return_value={"data": []},
            ) as the_mock:
                with mock.patch(
                    "noia_sdk.__main__.print_table",
                    autospec=True,
                ) as print_table_mock:
                    self.runner.invoke(
                        noiactl.create_connections, ["123", "1", "2", "3", "4"]
                    )
                    index_mock.assert_called_once()
                    the_mock.assert_called_once_with(
                        mock.ANY,
                        body={
                            "network_id": 123,
                            "agent_ids": [1, 2, 3, 4],
                            "network_update_by": sdk.NetworkGenesisType.SDK,
                        },
                    )
                    print_table_mock.assert_called_once()

    def testCreateConnectionsP2PByName(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "index_networks",
            autospec=True,
            return_value={
                "data": [
                    {
                        "network_id": 123,
                        "network_name": "test",
                        "network_type": "POINT_TO_POINT",
                    }
                ]
            },
        ) as index_mock:
            with mock.patch.object(
                noiactl.sdk.PlatformApi,
                "index_agents",
                autospec=True,
                return_value={
                    "data": [
                        {"agent_id": 1, "agent_name": "a"},
                        {"agent_id": 2, "agent_name": "b"},
                    ]
                },
            ) as index_mock:
                with mock.patch.object(
                    noiactl.sdk.PlatformApi,
                    "create_connections",
                    autospec=True,
                    return_value={"data": []},
                ) as the_mock:
                    with mock.patch(
                        "noia_sdk.__main__.print_table",
                        autospec=True,
                    ) as print_table_mock:
                        self.runner.invoke(
                            noiactl.create_connections,
                            ["--use-names", "test", "a", "b"],
                        )
                        index_mock.assert_called_once()
                        the_mock.assert_called_once_with(
                            mock.ANY,
                            body={
                                "network_id": 123,
                                "agent_ids": [(1, 2)],
                                "network_update_by": sdk.NetworkGenesisType.SDK,
                            },
                        )
                        print_table_mock.assert_called_once()

    def testDeleteConnection(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi, "delete_connection", autospec=True
        ) as the_mock:
            self.runner.invoke(noiactl.delete_connection, ["123"])
            the_mock.assert_called_once_with(mock.ANY, 123)

    def testGetNetworks(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "index_networks",
            autospec=True,
            return_value={"data": []},
        ) as index_mock:
            with mock.patch(
                "noia_sdk.__main__.print_table",
                autospec=True,
            ) as print_table_mock:
                self.runner.invoke(noiactl.get_networks)
                index_mock.assert_called_once()
                print_table_mock.assert_called_once()

    @parametrize(
        [
            ("P2P",),
            ("P2M",),
            ("MESH",),
        ]
    )
    @parametrize(
        [
            ("POINT_TO_POINT",),
            ("MESH",),
            ("GATEWAY",),
        ]
    )
    def testCreateNetwork(self, topology, network_type):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "create_network",
            autospec=True,
            return_value={"data": {"network_id": 123}},
        ) as the_mock:
            self.runner.invoke(
                noiactl.create_network,
                [
                    "name",
                    "--network-type",
                    network_type,
                    "--topology",
                    topology,
                    "--gateway-id",
                    "123",
                ],
            )
            the_mock.assert_called_once_with(
                mock.ANY,
                body={
                    "network_name": "name",
                    "network_type": network_type,
                    "agent_gateway_id": 123,
                    "network_disable_sdn_connections": True,
                    "network_metadata": {
                        "network_type": topology,
                        "network_created_by": "SDK",
                    },
                },
            )

    def testCreateNetworkDefault(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "create_network",
            autospec=True,
            return_value={"data": {"network_id": 123}},
        ) as the_mock:
            self.runner.invoke(
                noiactl.create_network,
                [
                    "name",
                ],
            )
            the_mock.assert_called_once_with(
                mock.ANY,
                body={
                    "network_name": "name",
                    "network_type": "POINT_TO_POINT",
                    "agent_gateway_id": 0,
                    "network_disable_sdn_connections": True,
                    "network_metadata": {
                        "network_type": "P2P",
                        "network_created_by": "SDK",
                    },
                },
            )

    def testDeleteNetworkMultiple(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "index_networks",
            autospec=True,
            return_value={
                "data": [
                    {"network_name": "test", "network_id": 321},
                    {"network_name": "test", "network_id": 123},
                ]
            },
        ) as index_mock:
            with mock.patch.object(
                noiactl.sdk.PlatformApi, "delete_networks", autospec=True
            ) as the_mock:
                self.runner.invoke(noiactl.delete_network, ["test"])
                assert the_mock.call_args_list == [
                    mock.call(mock.ANY, 321),
                    mock.call(mock.ANY, 123),
                ]
                index_mock.assert_called_once_with(mock.ANY, filter="id|name:test")

    def testConfigure(self):
        with mock.patch(
            "noia_sdk.__main__.configure_network", autospec=True
        ) as the_mock:
            with self.runner.isolated_filesystem():
                with open("test.yaml", "w") as f:
                    f.write(TEST_YAML)

                result = self.runner.invoke(noiactl.configure_networks, ["test.yaml"])
                the_mock.assert_called_once_with(
                    mock.ANY,
                    {
                        "name": "edge_to_lb",
                        "state": "present",
                        "use_sdn": True,
                        "use_public": False,
                        "sdn_path_count": 3,
                        "latency_threshold": 10,
                        "pl_threshold": 1,
                        "topology": "p2m",
                        "connections": {
                            "de-aws-lb01": {
                                "type": "endpoint",
                                "services": ["haproxy", "mqtt"],
                                "connect_to": {
                                    "iot_device": {"type": "tag", "services": "ssh"}
                                },
                            }
                        },
                    },
                    False,
                )

    def testConfigureDry(self):
        with mock.patch(
            "noia_sdk.__main__.configure_network", autospec=True
        ) as the_mock:
            with self.runner.isolated_filesystem() as fs:
                with open("test.yaml", "w") as f:
                    f.write(TEST_YAML)

                self.runner.invoke(
                    noiactl.configure_networks, ["--dry-run", "test.yaml"]
                )
                the_mock.assert_called_once_with(
                    mock.ANY,
                    {
                        "name": "edge_to_lb",
                        "state": "present",
                        "use_sdn": True,
                        "use_public": False,
                        "sdn_path_count": 3,
                        "latency_threshold": 10,
                        "pl_threshold": 1,
                        "topology": "p2m",
                        "connections": {
                            "de-aws-lb01": {
                                "type": "endpoint",
                                "services": ["haproxy", "mqtt"],
                                "connect_to": {
                                    "iot_device": {"type": "tag", "services": "ssh"}
                                },
                            }
                        },
                    },
                    True,
                )

    def testExportNetworks(self):
        with mock.patch.object(
            noiactl.sdk.PlatformApi,
            "index_networks",
            autospec=True,
            return_value=INDEX_NETWORKS,
        ) as index_net, mock.patch.object(
            noiactl.sdk.PlatformApi,
            "index_connections",
            autospec=True,
            return_value={"data": P2P_CONNECTIONS},
        ) as index_conn, mock.patch.object(
            noiactl.sdk.PlatformApi,
            "index_agents",
            autospec=True,
            return_value=INDEX_AGENTS_EX,
        ) as index_ag, mock.patch.object(
            noiactl.sdk.PlatformApi,
            "get_connection_services",
            autospec=True,
            return_value={"data": P2P_CONNECTIONS_SERVICES},
        ) as services_mock:
            result = self.runner.invoke(noiactl.export_networks)
            assert "skip" in result.output
            assert "test" in result.output
            assert "nats-streaming" in result.output


if __name__ == "__main__":
    unittest.main()
