# NOIA-SDK
NOIA Platform SDK allows you to manage NOIA networks. 

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.1.0
- Package version: 0.1.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 3.6+

## Installation & Usage
### pip install

The latest package can be installed from PyPi:

```sh
pip install noia-sdk
```

Then import the package:
```python
import noia_sdk 
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import noia_sdk
from noia_sdk.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
code = 'code_example' # str | Account deletion code (received by mail).

try:
    api_response = api_instance.delete_account(code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->delete_account: %s\n" % e)

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | Email verification code (received by mail).

try:
    api_response = api_instance.deprecated_verify_email(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->deprecated_verify_email: %s\n" % e)

# Configure API key authorization: jwt
configuration = noia_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
ip = 'ip_example' # str | 

try:
    api_response = api_instance.geo_ip(ip)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->geo_ip: %s\n" % e)

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.local(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->local: %s\n" % e)

# Configure API key authorization: jwt
configuration = noia_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.pair_latency_test_report(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->pair_latency_test_report: %s\n" % e)

# Configure API key authorization: jwt
configuration = noia_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = [noia_sdk.UserPairLatencyTestReportObject()] # list[UserPairLatencyTestReportObject] | 

try:
    api_response = api_instance.pair_latency_test_report_bulk(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->pair_latency_test_report_bulk: %s\n" % e)

# Configure API key authorization: jwt
configuration = noia_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.pair_speedtest_report(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->pair_speedtest_report: %s\n" % e)

# Configure API key authorization: jwt
configuration = noia_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.provider_attach(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->provider_attach: %s\n" % e)

# Configure API key authorization: jwt
configuration = noia_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.provider_detach(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->provider_detach: %s\n" % e)

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.provider_login(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->provider_login: %s\n" % e)

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 
attach = noia_sdk.AutoAttach() # AutoAttach |  (optional)

try:
    api_response = api_instance.provider_register(body, attach=attach)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->provider_register: %s\n" % e)

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
refresh_token = 'refresh_token_example' # str | 

try:
    api_response = api_instance.refresh(refresh_token)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->refresh: %s\n" % e)

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 
ref = noia_sdk.MailBodyTemplates() # MailBodyTemplates |  (optional)

try:
    api_response = api_instance.register(body, ref=ref)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->register: %s\n" % e)

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.reset_password(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->reset_password: %s\n" % e)

# Configure API key authorization: jwt
configuration = noia_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
ref = noia_sdk.MailBodyTemplates() # MailBodyTemplates |  (optional)

try:
    api_response = api_instance.set_delete_account_code(ref=ref)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->set_delete_account_code: %s\n" % e)

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 
ref = noia_sdk.MailBodyTemplates() # MailBodyTemplates |  (optional)

try:
    api_response = api_instance.set_reset_password_code(body, ref=ref)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->set_reset_password_code: %s\n" % e)

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 
ref = noia_sdk.MailBodyTemplates() # MailBodyTemplates |  (optional)

try:
    api_response = api_instance.set_verify_email_code(body, ref=ref)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->set_verify_email_code: %s\n" % e)

# Configure API key authorization: jwt
configuration = noia_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.speedtest_report(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->speedtest_report: %s\n" % e)

# Configure API key authorization: jwt
configuration = noia_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))

try:
    api_response = api_instance.user()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->user: %s\n" % e)

# Configure API key authorization: jwt
configuration = noia_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 
ref = noia_sdk.MailBodyTemplates() # MailBodyTemplates |  (optional)

try:
    api_response = api_instance.user_change_email(body, ref=ref)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->user_change_email: %s\n" % e)

# Configure API key authorization: jwt
configuration = noia_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_instance.user_change_password(body)
except ApiException as e:
    print("Exception when calling AuthApi->user_change_password: %s\n" % e)

# Configure API key authorization: jwt
configuration = noia_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_instance.user_destroy(body)
except ApiException as e:
    print("Exception when calling AuthApi->user_destroy: %s\n" % e)

# Configure API key authorization: jwt
configuration = noia_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.user_hosts_create(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->user_hosts_create: %s\n" % e)

# Configure API key authorization: jwt
configuration = noia_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
id = 1.2 # float | 

try:
    api_response = api_instance.user_hosts_destroy(id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->user_hosts_destroy: %s\n" % e)

# Configure API key authorization: jwt
configuration = noia_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))

try:
    api_response = api_instance.user_hosts_index()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->user_hosts_index: %s\n" % e)

# create an instance of the API class
api_instance = noia_sdk.AuthApi(noia_sdk.ApiClient(configuration))
code = 'code_example' # str | Email verification code (received by mail).

try:
    api_response = api_instance.verify_email(code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->verify_email: %s\n" % e)
```

## Command line tool usage

In order to be able to perform operations with platform API keys, networks, connections or edges you can use `noiactl` utility.
First you must set proper environment variables:

```sh
$ export NOIA_API_SERVER={NOIA API URL}
$ export NOIA_TOKEN={the API authorization token}
```

In case you have a registered user on the platform you can retrieve the API token using this command(deprecated):

```sh
$ noiactl login {user name} {password}
{your API authorization token}
```

You can omit `{password}` on the command line, then the utility will ask you to type the password.

In case you are using SSO to login to the platform the API authorization token can be retrieved from the Platform itself.

Or you can set the `NOIA_TOKEN` environment variable like this(Set `NOIA_API_SERVER` to the server address and `NOIA_TOKEN` to empty value before that):

```sh
export NOIA_TOKEN=`noiactl login {user name} {password}`
```

You can learn about the types of actions this utility can perform by running:

```sh
$ noiactl --help
Usage: noiactl [OPTIONS] COMMAND [ARGS]...

  NOIA NETWORKS cli tool

Options:
  --help  Show this message and exit.

Commands:
  configure-networks  Configure networks using a configuration YAML file.
  create-api-key      Create a API key
  create-connections  Create connections between endpoints.
  create-network      Create a network.
  delete-api-key      Delete API key either by name or by id.
  delete-connection   Deletes a connection
  delete-network      Deletes a NOIA network.
  export-networks     Exports existing networks to configuration YAML file.
  get-api-keys        List all API keys
  get-connections     Retrieves network connections
  get-endpoints       List all endpoints
  get-networks        List all networks
  get-topology        Retrieves networks topology
  login               Login with username and password.
```

## Exporting and configuring networks

It is possible to export existing networks using `noiactl export-networks` command which will output existing networks configuration to stdout
in a YAML format.
This configuration can be passed to `noiactl configure-networks {infrastructure.yaml}` to create networks and connections.

Below you can find a sample configuration file for different types of networks:

```yaml
---
# Create point-to-point connections
name: interconnect
# Network topology is mandaroty. Values: P2P, P2M, MESH
topology: p2p
# Network state is mandatory. Values: present, absent
state: present
use_sdn: false
# Connections to create
connections:
  # Endpoint can be refferred to by name and by id
  endpoint-1:
    # state is present by default
    state: present
    # type is endpoint by default. Values: endpoint, tag, id
    type: endpoint
    # services specifies what services to enable for given endpoint
    services: 
    - nginx
    # id has precedence before name when type is endpoint
    id: 123
    connect_to:
      endpoint-2:
        type: endpoint
        services: 
        - postgre
  3:
    connect_to:
      endpoint-4:
        type: endpoint
    state: present
    type: id
  endpoint-5:
    connect_to:
      6:
        type: id
    state: absent
    type: endpoint

---
# Connect mqtt server with iot devices 
name: iot-network
state: present
use_sdn: false
topology: p2m
connections:
  mqtt-server-name.com:
    type: endpoint
    connect_to:
      # Will connect mqtt server with all the endpoints tagged as "iot-devices"
      iot-devices:
        state: present
        type: tag

---
# Create DNS servers mesh network 
name: dns-mesh
state: present
use_sdn: true
topology: mesh
connections:
  # Will create a mesh network using endpoints tagged as "dns-servers"
  dns-servers:
    state: present
    type: tag

---
# Delete a network
name: old-iot-network
topology: mesh
state: absent
```

## Documentation for API Endpoints

All URIs are relative to */*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthApi* | [**delete_account**](docs/AuthApi.md#delete_account) | **GET** /api/auth/delete-account/{code} | 
*AuthApi* | [**deprecated_verify_email**](docs/AuthApi.md#deprecated_verify_email) | **POST** /api/auth/verify-email | 
*AuthApi* | [**geo_ip**](docs/AuthApi.md#geo_ip) | **GET** /api/auth/{ip}/geoip | 
*AuthApi* | [**local**](docs/AuthApi.md#local) | **POST** /api/auth/local/login | 
*AuthApi* | [**pair_latency_test_report**](docs/AuthApi.md#pair_latency_test_report) | **POST** /api/auth/pair-latency-test-report | 
*AuthApi* | [**pair_latency_test_report_bulk**](docs/AuthApi.md#pair_latency_test_report_bulk) | **POST** /api/auth/pair-latency-test-report/bulk | 
*AuthApi* | [**pair_speedtest_report**](docs/AuthApi.md#pair_speedtest_report) | **POST** /api/auth/pair-speedtest-report | 
*AuthApi* | [**provider_attach**](docs/AuthApi.md#provider_attach) | **POST** /api/auth/provider/attach | 
*AuthApi* | [**provider_detach**](docs/AuthApi.md#provider_detach) | **POST** /api/auth/provider/detach | 
*AuthApi* | [**provider_login**](docs/AuthApi.md#provider_login) | **POST** /api/auth/provider/login | 
*AuthApi* | [**provider_register**](docs/AuthApi.md#provider_register) | **POST** /api/auth/provider/register | 
*AuthApi* | [**refresh**](docs/AuthApi.md#refresh) | **POST** /api/auth/refresh-token | 
*AuthApi* | [**register**](docs/AuthApi.md#register) | **POST** /api/auth/register | 
*AuthApi* | [**reset_password**](docs/AuthApi.md#reset_password) | **POST** /api/auth/reset-password | 
*AuthApi* | [**set_delete_account_code**](docs/AuthApi.md#set_delete_account_code) | **POST** /api/auth/send-delete-account-link | 
*AuthApi* | [**set_reset_password_code**](docs/AuthApi.md#set_reset_password_code) | **POST** /api/auth/send-reset-password-link | 
*AuthApi* | [**set_verify_email_code**](docs/AuthApi.md#set_verify_email_code) | **POST** /api/auth/send-verify-email-link | 
*AuthApi* | [**speedtest_report**](docs/AuthApi.md#speedtest_report) | **POST** /api/auth/speedtest-report | 
*AuthApi* | [**user**](docs/AuthApi.md#user) | **GET** /api/auth/user | 
*AuthApi* | [**user_change_email**](docs/AuthApi.md#user_change_email) | **POST** /api/auth/user/change-email | 
*AuthApi* | [**user_change_password**](docs/AuthApi.md#user_change_password) | **POST** /api/auth/user/change-password | 
*AuthApi* | [**user_destroy**](docs/AuthApi.md#user_destroy) | **POST** /api/auth/user/delete | 
*AuthApi* | [**user_hosts_create**](docs/AuthApi.md#user_hosts_create) | **POST** /api/auth/user/hosts | 
*AuthApi* | [**user_hosts_destroy**](docs/AuthApi.md#user_hosts_destroy) | **DELETE** /api/auth/user/hosts/{id} | 
*AuthApi* | [**user_hosts_index**](docs/AuthApi.md#user_hosts_index) | **GET** /api/auth/user/hosts | 
*AuthApi* | [**verify_email**](docs/AuthApi.md#verify_email) | **GET** /api/auth/verify-email/{code} | 
*PlatformApi* | [**config**](docs/PlatformApi.md#config) | **GET** /api/platform/admin/agent/{agent_id}/config | 
*PlatformApi* | [**create_agent_group**](docs/PlatformApi.md#create_agent_group) | **POST** /api/platform/network/{network_id}/agent-groups/{group_name} | 
*PlatformApi* | [**create_api_key**](docs/PlatformApi.md#create_api_key) | **POST** /api/platform/api-keys | 
*PlatformApi* | [**create_connections**](docs/PlatformApi.md#create_connections) | **POST** /api/platform/connections | 
*PlatformApi* | [**create_network**](docs/PlatformApi.md#create_network) | **POST** /api/platform/networks | 
*PlatformApi* | [**create_network_agents**](docs/PlatformApi.md#create_network_agents) | **POST** /api/platform/network/{network_id}/agents | 
*PlatformApi* | [**delete_agents**](docs/PlatformApi.md#delete_agents) | **DELETE** /api/platform/agents/{agent_id} | 
*PlatformApi* | [**delete_api_key**](docs/PlatformApi.md#delete_api_key) | **DELETE** /api/platform/api-keys/{api_key_id} | 
*PlatformApi* | [**delete_connection**](docs/PlatformApi.md#delete_connection) | **DELETE** /api/platform/connections/{connection_id} | 
*PlatformApi* | [**delete_networks**](docs/PlatformApi.md#delete_networks) | **DELETE** /api/platform/networks/{network_id} | 
*PlatformApi* | [**delete_networks_agent**](docs/PlatformApi.md#delete_networks_agent) | **DELETE** /api/platform/networks/{network_id}/agents/{agent_id} | 
*PlatformApi* | [**find_all_name_id_pairs_by_user_id**](docs/PlatformApi.md#find_all_name_id_pairs_by_user_id) | **GET** /api/platform/agents/id-name-pairs | 
*PlatformApi* | [**get_agent_services_with_subnets**](docs/PlatformApi.md#get_agent_services_with_subnets) | **GET** /api/platform/agent-services | 
*PlatformApi* | [**get_connection_services**](docs/PlatformApi.md#get_connection_services) | **GET** /api/platform/connection-services | 
*PlatformApi* | [**get_network_info**](docs/PlatformApi.md#get_network_info) | **GET** /api/platform/network/{network_id}/info | 
*PlatformApi* | [**index_agents**](docs/PlatformApi.md#index_agents) | **GET** /api/platform/agents | 
*PlatformApi* | [**index_api_key**](docs/PlatformApi.md#index_api_key) | **GET** /api/platform/api-keys | 
*PlatformApi* | [**index_connections**](docs/PlatformApi.md#index_connections) | **GET** /api/platform/connections | 
*PlatformApi* | [**index_networks**](docs/PlatformApi.md#index_networks) | **GET** /api/platform/networks | 
*PlatformApi* | [**patch_agents**](docs/PlatformApi.md#patch_agents) | **PATCH** /api/platform/agents/{agent_id} | 
*PlatformApi* | [**remove_agent_group**](docs/PlatformApi.md#remove_agent_group) | **DELETE** /api/platform/network/agent-groups/{group_id} | 
*PlatformApi* | [**remove_network_agents**](docs/PlatformApi.md#remove_network_agents) | **DELETE** /api/platform/network/{network_id}/agents | 
*PlatformApi* | [**save_logs_read_timestamp**](docs/PlatformApi.md#save_logs_read_timestamp) | **POST** /api/platform/logs-reads-timestamp | 
*PlatformApi* | [**topology_networks**](docs/PlatformApi.md#topology_networks) | **GET** /api/platform/networks/topology | 
*PlatformApi* | [**update_agent_group**](docs/PlatformApi.md#update_agent_group) | **PUT** /api/platform/network/agent-groups/{group_id} | 
*PlatformApi* | [**update_agent_services_subnets_status**](docs/PlatformApi.md#update_agent_services_subnets_status) | **POST** /api/platform/agent-services-subnets | 
*PlatformApi* | [**update_api_key**](docs/PlatformApi.md#update_api_key) | **PATCH** /api/platform/api-keys/{api_key_id} | 
*PlatformApi* | [**update_connection_services**](docs/PlatformApi.md#update_connection_services) | **POST** /api/platform/connection-services | 


## Documentation For Authorization


## jwt

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author


