// *WARNING* This file has been automatically generated by TPP do not edit directly.
/*
 * This file is part of TiPi (a Toolkit for Inverse Problems and Imaging)
 * developed by the MitiV project.
 *
 * Copyright (c) 2014 the MiTiV project, http://mitiv.univ-lyon1.fr/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

package org.mitiv.TiPi.array;
import org.mitiv.TiPi.base.Shape;
import org.mitiv.TiPi.base.Shaped;
import org.mitiv.TiPi.base.indexing.Range;


/**
 * Define abstract class for multi-dimensional arrays of rank 3.
 *
 * @author Éric Thiébaut.
 */
public abstract class Array3D implements ShapedArray {
    final protected Shape shape;
    final protected  int number;
    final protected int dim1;
    final protected int dim2;
    final protected int dim3;

    /*
     * The following constructors make this class non instantiable, but still
     * let others inherit from this class.
     */
    protected Array3D(int dim1, int dim2, int dim3) {
        shape = new Shape(dim1, dim2, dim3);
        if (shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        number = (int)shape.number();
        this.dim1 = dim1;
        this.dim2 = dim2;
        this.dim3 = dim3;
    }

    protected Array3D(int[] dims) {
        this(new Shape(dims));
    }

    protected Array3D(Shape shape) {
        if (shape.rank() != 3) {
            throw new IllegalArgumentException("Bad number of dimensions for 3-D array");
        }
        if (shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)shape.number();
        this.shape = shape;
        this.dim1 = shape.dimension(0);
        this.dim2 = shape.dimension(1);
        this.dim3 = shape.dimension(2);
    }

    @Override
    public final int getRank() {
        return 3;
    }

    @Override
    public final Shape getShape() {
        return shape;
    }

    @Override
    public final int getNumber() {
        return number;
    }

    @Override
    public final int getDimension(int k) {
        return shape.dimension(k);
    }
    
   /**
     * Return a new array with the same  number of elements but a different shape.
     *
     * @param shape         The new shape.
     * @return              The reshaped array
     */
    public final  Array3D  reshape(Shape shape) {
    if (this.number == (int)shape.number()){
        return ( Array3D) ArrayFactory.wrap(this.getData(), shape);
    }else{
        throw new IllegalArgumentException("The new shape is not commensurate with the old shape");
        }
    }

   /**
 * Create a copy of the array with the dimension initpos at the position finalpos
 * @param initpos       initial position of the dimension
 * @param finalpos      final position
 * @return              the new array
 */
   public final Array3D movedims( int initpos, int finalpos){
     

        if ((finalpos > 3-1)||(initpos > 3-1)){
            throw new IllegalArgumentException("The permutation should not change the rank");
        }
        if (initpos==finalpos){
            return this.copy();
        }
        int[] newdims =  new int[3];
        if (initpos<finalpos){
            for (int k = 0; k <initpos; ++k) {
                newdims[k] = shape.dimension(k);
            }
            for (int k = initpos; k <finalpos; ++k) {
                newdims[k] = shape.dimension(k+1);
            }
            newdims[finalpos] = shape.dimension(initpos);
            for (int k = finalpos+1; k <3; ++k) {
                newdims[k] = shape.dimension(k);
            }
        }else{
            for (int k = 0; k <finalpos; ++k) {
                newdims[k] = shape.dimension(k);
            }
            newdims[finalpos] = shape.dimension(initpos);
            for (int k = finalpos+1; k <initpos+1; ++k) {
                newdims[k] = shape.dimension(k-1);
            }
            for (int k = initpos+1; k <3; ++k) {
                newdims[k] = shape.dimension(k);
            }
        }
        Array3D newArray = (Array3D) ArrayFactory.create(this.getType(), newdims);
        for(int n=0; n<   shape.dimension(initpos);++n){
            newArray.slice(n,finalpos).assign(this.slice(n, initpos));
        }

        return newArray;

    }
    
    @Override
    public abstract Array3D copy();

    /**
     * Get a slice of the array.
     *
     * @param idx
     *        The index of the slice along the last dimension of the array.
     *        The same indexing rules as for {@link mitiv.base.indexing.Range}
     *        apply for negative index: 0 for the first, 1 for the second, -1
     *        for the last, -2 for penultimate, <i>etc.</i>
     *
     * @return A Array2D view on the given slice of the array.
     */
    public abstract Array2D slice(int idx);

    /**
     * Get a slice of the array.
     *
     * @param idx
     *        The index of the slice along the dimension {@code dim} of the
     *        array.
     *
     * @param dim
     *        The dimension to slice.  For these two arguments, the same
     *        indexing rules as for {@link mitiv.base.indexing.Range} apply for
     *        negative index: 0 for the first, 1 for the second, -1 for the
     *        last, -2 for penultimate, <i>etc.</i>
     *
     * @return A Array2D view on the given slice of the array.
     */
    public abstract Array2D slice(int idx, int dim);

    /**
     * Get a view of the array for given ranges of indices.
     *
     * @param rng1
     *        The range of indices to select along 1st dimension (or {@code
     *        null} to select all).
     *
     * @param rng2
     *        The range of indices to select along 2nd dimension (or {@code
     *        null} to select all).
     *
     * @param rng3
     *        The range of indices to select along 3rd dimension (or {@code
     *        null} to select all).
     *
     * @return A Array3D view for the given ranges of the array.
     */
    public abstract Array3D view(Range rng1, Range rng2, Range rng3);

    /**
     * Get a view of the array for given ranges of indices.
     *
     * @param idx1
     *        The list of indices to select along 1st dimension (or {@code
     *        null} to select all).
     *
     * @param idx2
     *        The list of indices to select along 2nd dimension (or {@code
     *        null} to select all).
     *
     * @param idx3
     *        The list of indices to select along 3rd dimension (or {@code
     *        null} to select all).
     *
     * @return A Array3D view for the given index selections of the
     *         array.
     */
    public abstract Array3D view(int[] idx1, int[] idx2, int[] idx3);

    /**
     * Get a view of the array as a 1D array.
     *
     * @return A 1D view of the array.
     */
    public abstract Array1D as1D();

    /**
     * Check the parameters of a 3D view with strides and get ordering.
     *
     * @param number    The number of elements in the wrapped array.
     * @param dim1      The 1st dimension of the 3D view.
     * @param dim2      The 2nd dimension of the 3D view.
     * @param dim3      The 3rd dimension of the 3D view.
     * @param offset    The offset of element (0,0,0) of the 3D view.
     * @param stride1   The stride along the 1st dimension.
     * @param stride2   The stride along the 2nd dimension.
     * @param stride3   The stride along the 3rd dimension.
     *
     * @return The ordering: {@link Shaped#COLUMN_MAJOR},
     *         {@link Shaped#ROW_MAJOR}, or {@link Shaped#NONSPECIFIC_ORDER}.
     *
     * @throws IndexOutOfBoundsException
     */
    public static int checkViewStrides(int number, int offset,
                                       int stride1, int stride2, int stride3,
                                       int dim1, int dim2, int dim3) {
        int imin, imax, itmp;
        itmp = (dim1 - 1)*stride1;
        if (itmp >= 0) {
            imin = offset;
            imax = offset + itmp;
        } else {
            imin = offset + itmp;
            imax = offset;
        }
        itmp = (dim2 - 1)*stride2;
        if (itmp >= 0) {
            imax += itmp;
        } else {
            imin += itmp;
        }
        itmp = (dim3 - 1)*stride3;
        if (itmp >= 0) {
            imax += itmp;
        } else {
            imin += itmp;
        }
        if (imin < 0 || imax >= number) {
            throw new IndexOutOfBoundsException("3D view is not within available space");
        }
        int s1 = Math.abs(stride1);
        int s2 = Math.abs(stride2);
        int s3 = Math.abs(stride3);
        if (s1 <= s2 && s2 <= s3) {
            return COLUMN_MAJOR;
        } else if (s1 >= s2 && s2 >= s3) {
            return ROW_MAJOR;
        } else {
            return NONSPECIFIC_ORDER;
        }
    }

}
