# TiPi framework for solving inverse problems

TiPi is a Java *Toolkit for Inverse Problems and Imaging* developed as part the
[MiTiV](http://mitiv.univ-lyon1.fr/) project and supported by the **Magnum2**
project.  The objective of TiPi is to provide a framework for developping fast
algorithms for solving inverse problems in particular in the domain of imaging.
TiPi has a number of applications, for instance:

* **Astronomy**: TiPi is used for the deblurring and denoising of astronomical
  images.

* **Magnum2** project: TiPi is used to repair (inpainting) and enhance
  (deblurring and denoising) images of license plates before automatic OCR.

* **Microscopy**: TiPi is exploited to implement the
  [Icy](http://icy.bioimageanalysis.org/) plugins for *deconvolution* and
  *blind deconvolution* of 3D images.


## Contents

TiPi provides:

* Classes and methods to manage multi-dimensional arrays, so-called [*shaped
  arrays*](shaped-arrays.md), in a flexible way.

* Classes and methods to deal with so-called [*vectors*](vectors.md) which
  stores values in an efficient way.  These vectors are needed by iterative
  optimization methods and are typically used to store the data, theirs weights
  and the variables of the inverse problem.

* Limited memory optimization algorithms to deal with large scale non-linear
  problems possibly with constraints.

* Building-block classes to encode objective functions (likelihood,
  regularization, *etc.*).

* Utilities for reading or writing data files, *etc.*


## Rationale and performances issues

In TiPi, data and variable are stored in objects called [vectors](vectors.md)
which intentionally have a limited set of methods.  These methods are just
those which are needed by optimization algorithms and merely correspond to the
properties of vectors in the conventional
[*linear algebra sense*](http://en.wikipedia.org/wiki/Vector_space).  Hence the
name of these objects in TiPi.

Thanks to these restrictions, *vectors* can be implemented in forms suitable
for performances (non-conventional or distributed memory, *etc.*) and a
particular implementation is simplified by the fact that only few methods have
to be exposed (see [*Creating new vector types*](new-vector-types.md)).

However, *vectors* are not really adapted for the many manipulations required
to prepare the inputs of the algorithms (*e.g.*, reading images, converting
types, perform zero-padding, recentering, etc.) and to save the result (e.g.,
extracting parts, rescaling, writing to a file, *etc.*).  This is why TiPi
provides another type of objects: the [*shaped arrays*](shaped-arrays.md).
These objects are much more versatile and use conventional memory.  We were
careful so that their manipulation should be very flexible but, as far as
possible, not to the sacrifice of performances.

Typically, an algorithm written in the TiPi framework starts with shaped
arrays, does some pre-processing, then creates vectors from the input arrays,
runs the iterative method, copies the result into a shaped array, displays
and/or saves the shaped array, perhaps after some post-processing.


## A caveat for developpers

Many classes in TiPi only differ by the type or rank of the shaped objects
which they implement.  To avoid tedious edition and management of many similar
source files, TiPi has its own pre-processor named `tpp`
([*the TiPi Pre-processor*](tpp.md)).  The Java code is generated from source
files which have (by convention) the extension `.javax` and which are stored in
the directory `tpp`.  If you want to modify an autogenerated class,
first edit the corresponding `.javax` source and then run the command:

```sh
cd tpp                         # move to tpp directory
./tpp <Makefile.x >Makefile    # generate Makefile if Makefile.x has changed
make all                       # make all targets
```

in the directory `tpp`.
