import * as iam from 'aws-cdk-lib/aws-iam';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as sfn from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
export interface TextractAsyncToJSONProps {
    /** Bucketname to output data to */
    readonly s3OutputBucket: string;
    /** The prefix to use for the output files */
    readonly s3OutputPrefix: string;
    /** memory of Lambda function (may need to increase for larger documents), set to 10240 (max) atm, decrease for smaller workloads */
    readonly lambdaMemoryMB?: number;
    /** memory of Lambda function (may need to increase for larger documents) */
    readonly lambdaTimeout?: number;
    /** log level for Lambda function, supports DEBUG|INFO|WARNING|ERROR|FATAL */
    readonly lambdaLogLevel?: 'DEBUG' | 'INFO' | 'WARNING' | 'ERROR' | 'FATAL';
    /** Which Textract API was used to create the OutputConfig?
     * GENERIC and LENDING are supported.
     *
     * @default - GENERIC */
    readonly textractAPI?: 'GENERIC' | 'LENDING';
    /** location of input S3 objects - if left empty will generate rule for s3 access to all [*] */
    readonly s3InputBucket?: string;
    /** prefix for input S3 objects - if left empty will generate rule for s3 access to all in bucket */
    readonly s3InputPrefix?: string;
    /** List of PolicyStatements to attach to the Lambda function.  */
    readonly inputPolicyStatements?: [iam.PolicyStatement];
    /** List of PolicyStatements to attach to the Lambda function.  */
    readonly outputPolicyStatements?: [iam.PolicyStatement];
}
/**
 * combines the potentially paginated response from async Textract calls and stores as one combines JSON.
 *
 * This construct is not memory optimzed (yet) and will combine all JSON by loading them to memory.
 * Large responses could exceed the memory potentially, the memory size is set to Lambda max.
 *
 * Reduce the memory size to your needs if your processing does not yield large responses to save Lamda cost.
 *
 *
 * Input: "textract_result"."TextractTempOutputJsonPath"
 * Output: "TextractOutputJsonPath"
 *
 * Example (Python)
 * ```python
    textract_async_to_json = tcdk.TextractAsyncToJSON(
        self,
        "TextractAsyncToJSON2",
        s3_output_prefix=s3_output_prefix,
        s3_output_bucket=s3_output_bucket)
  ```
 */
export declare class TextractAsyncToJSON extends sfn.StateMachineFragment {
    readonly startState: sfn.State;
    readonly endStates: sfn.INextable[];
    readonly asyncToJSONFunction: lambda.IFunction;
    constructor(parent: Construct, id: string, props: TextractAsyncToJSONProps);
}
