"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractPOCDecider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
/**
 * This construct takes in a manifest definition or a plain JSON with a s3Path:
 *
 * example s3Path:
 * {"s3Path": "s3://bucketname/prefix/image.png"}
 *
 *
 * Then it generated the numberOfPages attribute and the mime on the context.
 * The mime types checked against the supported mime types for Textract and if fails, will raise an Exception failing the workflow.
 *
 * Example (Python)
 * ```python
   decider_task_id = tcdk.TextractPOCDecider(
        self,
        f"InsuranceDecider",
   )
  ```

 *
 */
class TextractPOCDecider extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        var lambdaMemoryMB = props.lambdaMemoryMB === undefined ? 1024 : props.lambdaMemoryMB;
        var lambdaTimeout = props.lambdaTimeout === undefined ? 900 : props.lambdaTimeout;
        var s3InputPrefix = props.s3InputPrefix === undefined ? '' : props.s3InputPrefix;
        this.deciderFunction = new lambda.DockerImageFunction(this, 'TextractDecider', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/decider/')),
            architecture: lambda.Architecture.X86_64,
            memorySize: lambdaMemoryMB,
            timeout: aws_cdk_lib_1.Duration.seconds(lambdaTimeout),
        });
        if (props.inputPolicyStatements === undefined) {
            if (props.s3InputBucket === undefined) {
                this.deciderFunction.addToRolePolicy(new iam.PolicyStatement({
                    actions: ['s3:GetObject', 's3:ListBucket'],
                    resources: ['*'],
                }));
            }
            else {
                this.deciderFunction.addToRolePolicy(new iam.PolicyStatement({
                    actions: ['s3:GetObject', 's3:ListBucket'],
                    resources: [
                        path.join(`arn:aws:s3:::${props.s3InputBucket}`, s3InputPrefix, '/'),
                        path.join(`arn:aws:s3:::${props.s3InputBucket}`, s3InputPrefix, '/*'),
                    ],
                }));
            }
        }
        else {
            for (var policyStatement of props.inputPolicyStatements) {
                this.deciderFunction.addToRolePolicy(policyStatement);
            }
        }
        const deciderLambdaInvoke = new tasks.LambdaInvoke(this, id, {
            lambdaFunction: this.deciderFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(100),
            outputPath: '$.Payload',
        });
        this.startState = deciderLambdaInvoke;
        this.endStates = [deciderLambdaInvoke];
    }
}
exports.TextractPOCDecider = TextractPOCDecider;
_a = JSII_RTTI_SYMBOL_1;
TextractPOCDecider[_a] = { fqn: "amazon-textract-idp-cdk-constructs.TextractPOCDecider", version: "0.0.16" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGV4dHJhY3REZWNpZGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3RleHRyYWN0RGVjaWRlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZCQUE2QjtBQUM3Qiw2Q0FBdUM7QUFDdkMsMkNBQTJDO0FBQzNDLGlEQUFpRDtBQUNqRCxxREFBcUQ7QUFDckQsNkRBQTZEO0FBYzdEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBbUJHO0FBQ0gsTUFBYSxrQkFBbUIsU0FBUSxHQUFHLENBQUMsb0JBQW9CO0lBSzlELFlBQVksTUFBaUIsRUFBRSxFQUFVLEVBQUUsS0FBZ0M7UUFDekUsS0FBSyxDQUFDLE1BQU0sRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVsQixJQUFJLGNBQWMsR0FDaEIsS0FBSyxDQUFDLGNBQWMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUNuRSxJQUFJLGFBQWEsR0FDZixLQUFLLENBQUMsYUFBYSxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDO1FBQ2hFLElBQUksYUFBYSxHQUNmLEtBQUssQ0FBQyxhQUFhLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUM7UUFFL0QsSUFBSSxDQUFDLGVBQWUsR0FBRyxJQUFJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FDbkQsSUFBSSxFQUNKLGlCQUFpQixFQUNqQjtZQUNFLElBQUksRUFBRSxNQUFNLENBQUMsZUFBZSxDQUFDLGNBQWMsQ0FDekMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsb0JBQW9CLENBQUMsQ0FDM0M7WUFDRCxZQUFZLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNO1lBQ3hDLFVBQVUsRUFBRSxjQUFjO1lBQzFCLE9BQU8sRUFBRSxzQkFBUSxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUM7U0FDekMsQ0FDRixDQUFDO1FBRUYsSUFBSSxLQUFLLENBQUMscUJBQXFCLEtBQUssU0FBUyxFQUFFO1lBQzdDLElBQUksS0FBSyxDQUFDLGFBQWEsS0FBSyxTQUFTLEVBQUU7Z0JBQ3JDLElBQUksQ0FBQyxlQUFlLENBQUMsZUFBZSxDQUNsQyxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUM7b0JBQ3RCLE9BQU8sRUFBRSxDQUFDLGNBQWMsRUFBRSxlQUFlLENBQUM7b0JBQzFDLFNBQVMsRUFBRSxDQUFDLEdBQUcsQ0FBQztpQkFDakIsQ0FBQyxDQUNILENBQUM7YUFDSDtpQkFBTTtnQkFDTCxJQUFJLENBQUMsZUFBZSxDQUFDLGVBQWUsQ0FDbEMsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO29CQUN0QixPQUFPLEVBQUUsQ0FBQyxjQUFjLEVBQUUsZUFBZSxDQUFDO29CQUMxQyxTQUFTLEVBQUU7d0JBQ1QsSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsS0FBSyxDQUFDLGFBQWEsRUFBRSxFQUFFLGFBQWEsRUFBRSxHQUFHLENBQUM7d0JBQ3BFLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLEtBQUssQ0FBQyxhQUFhLEVBQUUsRUFBRSxhQUFhLEVBQUUsSUFBSSxDQUFDO3FCQUN0RTtpQkFDRixDQUFDLENBQ0gsQ0FBQzthQUNIO1NBQ0Y7YUFBTTtZQUNMLEtBQUssSUFBSSxlQUFlLElBQUksS0FBSyxDQUFDLHFCQUFxQixFQUFFO2dCQUN2RCxJQUFJLENBQUMsZUFBZSxDQUFDLGVBQWUsQ0FBQyxlQUFlLENBQUMsQ0FBQzthQUN2RDtTQUNGO1FBQ0QsTUFBTSxtQkFBbUIsR0FBRyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRTtZQUMzRCxjQUFjLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDcEMsT0FBTyxFQUFFLHNCQUFRLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQztZQUM5QixVQUFVLEVBQUUsV0FBVztTQUN4QixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsVUFBVSxHQUFHLG1CQUFtQixDQUFDO1FBQ3RDLElBQUksQ0FBQyxTQUFTLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7O0FBM0RILGdEQTREQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBEdXJhdGlvbiB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIHNmbiBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtc3RlcGZ1bmN0aW9ucyc7XG5pbXBvcnQgKiBhcyB0YXNrcyBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtc3RlcGZ1bmN0aW9ucy10YXNrcyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuZXhwb3J0IGludGVyZmFjZSBUZXh0cmFjdERQUE9DRGVjaWRlclByb3BzIHtcbiAgLyoqIG1lbW9yeSBvZiBMYW1iZGEgZnVuY3Rpb24gKG1heSBuZWVkIHRvIGluY3JlYXNlIGZvciBsYXJnZXIgZG9jdW1lbnRzKSAqL1xuICByZWFkb25seSBsYW1iZGFNZW1vcnlNQj86IG51bWJlcjtcbiAgcmVhZG9ubHkgbGFtYmRhVGltZW91dD86IG51bWJlcjtcbiAgcmVhZG9ubHkgZGVjaWRlckZ1bmN0aW9uPzogbGFtYmRhLklGdW5jdGlvbjtcbiAgcmVhZG9ubHkgczNJbnB1dEJ1Y2tldD86IHN0cmluZztcbiAgLyoqIHByZWZpeCBmb3IgdGhlIGluY29taW5nIGRvY3VtZW50LiBXaWxsIGJlIHVzZWQgdG8gY3JlYXRlIHJvbGUgKi9cbiAgcmVhZG9ubHkgczNJbnB1dFByZWZpeD86IHN0cmluZztcbiAgLyoqIExpc3Qgb2YgUG9saWN5U3RhdGVtZW50cyB0byBhdHRhY2ggdG8gdGhlIExhbWJkYSBmdW5jdGlvbiBmb3IgUzMgR0VUIGFuZCBMSVNULiAqL1xuICByZWFkb25seSBpbnB1dFBvbGljeVN0YXRlbWVudHM/OiBbaWFtLlBvbGljeVN0YXRlbWVudF07XG59XG4vKipcbiAqIFRoaXMgY29uc3RydWN0IHRha2VzIGluIGEgbWFuaWZlc3QgZGVmaW5pdGlvbiBvciBhIHBsYWluIEpTT04gd2l0aCBhIHMzUGF0aDpcbiAqXG4gKiBleGFtcGxlIHMzUGF0aDpcbiAqIHtcInMzUGF0aFwiOiBcInMzOi8vYnVja2V0bmFtZS9wcmVmaXgvaW1hZ2UucG5nXCJ9XG4gKlxuICpcbiAqIFRoZW4gaXQgZ2VuZXJhdGVkIHRoZSBudW1iZXJPZlBhZ2VzIGF0dHJpYnV0ZSBhbmQgdGhlIG1pbWUgb24gdGhlIGNvbnRleHQuXG4gKiBUaGUgbWltZSB0eXBlcyBjaGVja2VkIGFnYWluc3QgdGhlIHN1cHBvcnRlZCBtaW1lIHR5cGVzIGZvciBUZXh0cmFjdCBhbmQgaWYgZmFpbHMsIHdpbGwgcmFpc2UgYW4gRXhjZXB0aW9uIGZhaWxpbmcgdGhlIHdvcmtmbG93LlxuICpcbiAqIEV4YW1wbGUgKFB5dGhvbilcbiAqIGBgYHB5dGhvblxuICAgZGVjaWRlcl90YXNrX2lkID0gdGNkay5UZXh0cmFjdFBPQ0RlY2lkZXIoXG4gICAgICAgIHNlbGYsXG4gICAgICAgIGZcIkluc3VyYW5jZURlY2lkZXJcIixcbiAgIClcbiAgYGBgXG5cbiAqXG4gKi9cbmV4cG9ydCBjbGFzcyBUZXh0cmFjdFBPQ0RlY2lkZXIgZXh0ZW5kcyBzZm4uU3RhdGVNYWNoaW5lRnJhZ21lbnQge1xuICBwdWJsaWMgcmVhZG9ubHkgc3RhcnRTdGF0ZTogc2ZuLlN0YXRlO1xuICBwdWJsaWMgcmVhZG9ubHkgZW5kU3RhdGVzOiBzZm4uSU5leHRhYmxlW107XG4gIHB1YmxpYyByZWFkb25seSBkZWNpZGVyRnVuY3Rpb246IGxhbWJkYS5JRnVuY3Rpb247XG5cbiAgY29uc3RydWN0b3IocGFyZW50OiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBUZXh0cmFjdERQUE9DRGVjaWRlclByb3BzKSB7XG4gICAgc3VwZXIocGFyZW50LCBpZCk7XG5cbiAgICB2YXIgbGFtYmRhTWVtb3J5TUIgPVxuICAgICAgcHJvcHMubGFtYmRhTWVtb3J5TUIgPT09IHVuZGVmaW5lZCA/IDEwMjQgOiBwcm9wcy5sYW1iZGFNZW1vcnlNQjtcbiAgICB2YXIgbGFtYmRhVGltZW91dCA9XG4gICAgICBwcm9wcy5sYW1iZGFUaW1lb3V0ID09PSB1bmRlZmluZWQgPyA5MDAgOiBwcm9wcy5sYW1iZGFUaW1lb3V0O1xuICAgIHZhciBzM0lucHV0UHJlZml4ID1cbiAgICAgIHByb3BzLnMzSW5wdXRQcmVmaXggPT09IHVuZGVmaW5lZCA/ICcnIDogcHJvcHMuczNJbnB1dFByZWZpeDtcblxuICAgIHRoaXMuZGVjaWRlckZ1bmN0aW9uID0gbmV3IGxhbWJkYS5Eb2NrZXJJbWFnZUZ1bmN0aW9uKFxuICAgICAgdGhpcyxcbiAgICAgICdUZXh0cmFjdERlY2lkZXInLFxuICAgICAge1xuICAgICAgICBjb2RlOiBsYW1iZGEuRG9ja2VySW1hZ2VDb2RlLmZyb21JbWFnZUFzc2V0KFxuICAgICAgICAgIHBhdGguam9pbihfX2Rpcm5hbWUsICcuLi9sYW1iZGEvZGVjaWRlci8nKSxcbiAgICAgICAgKSxcbiAgICAgICAgYXJjaGl0ZWN0dXJlOiBsYW1iZGEuQXJjaGl0ZWN0dXJlLlg4Nl82NCxcbiAgICAgICAgbWVtb3J5U2l6ZTogbGFtYmRhTWVtb3J5TUIsXG4gICAgICAgIHRpbWVvdXQ6IER1cmF0aW9uLnNlY29uZHMobGFtYmRhVGltZW91dCksXG4gICAgICB9LFxuICAgICk7XG5cbiAgICBpZiAocHJvcHMuaW5wdXRQb2xpY3lTdGF0ZW1lbnRzID09PSB1bmRlZmluZWQpIHtcbiAgICAgIGlmIChwcm9wcy5zM0lucHV0QnVja2V0ID09PSB1bmRlZmluZWQpIHtcbiAgICAgICAgdGhpcy5kZWNpZGVyRnVuY3Rpb24uYWRkVG9Sb2xlUG9saWN5KFxuICAgICAgICAgIG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICAgIGFjdGlvbnM6IFsnczM6R2V0T2JqZWN0JywgJ3MzOkxpc3RCdWNrZXQnXSxcbiAgICAgICAgICAgIHJlc291cmNlczogWycqJ10sXG4gICAgICAgICAgfSksXG4gICAgICAgICk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICB0aGlzLmRlY2lkZXJGdW5jdGlvbi5hZGRUb1JvbGVQb2xpY3koXG4gICAgICAgICAgbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICAgICAgYWN0aW9uczogWydzMzpHZXRPYmplY3QnLCAnczM6TGlzdEJ1Y2tldCddLFxuICAgICAgICAgICAgcmVzb3VyY2VzOiBbXG4gICAgICAgICAgICAgIHBhdGguam9pbihgYXJuOmF3czpzMzo6OiR7cHJvcHMuczNJbnB1dEJ1Y2tldH1gLCBzM0lucHV0UHJlZml4LCAnLycpLFxuICAgICAgICAgICAgICBwYXRoLmpvaW4oYGFybjphd3M6czM6Ojoke3Byb3BzLnMzSW5wdXRCdWNrZXR9YCwgczNJbnB1dFByZWZpeCwgJy8qJyksXG4gICAgICAgICAgICBdLFxuICAgICAgICAgIH0pLFxuICAgICAgICApO1xuICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICBmb3IgKHZhciBwb2xpY3lTdGF0ZW1lbnQgb2YgcHJvcHMuaW5wdXRQb2xpY3lTdGF0ZW1lbnRzKSB7XG4gICAgICAgIHRoaXMuZGVjaWRlckZ1bmN0aW9uLmFkZFRvUm9sZVBvbGljeShwb2xpY3lTdGF0ZW1lbnQpO1xuICAgICAgfVxuICAgIH1cbiAgICBjb25zdCBkZWNpZGVyTGFtYmRhSW52b2tlID0gbmV3IHRhc2tzLkxhbWJkYUludm9rZSh0aGlzLCBpZCwge1xuICAgICAgbGFtYmRhRnVuY3Rpb246IHRoaXMuZGVjaWRlckZ1bmN0aW9uLFxuICAgICAgdGltZW91dDogRHVyYXRpb24uc2Vjb25kcygxMDApLFxuICAgICAgb3V0cHV0UGF0aDogJyQuUGF5bG9hZCcsXG4gICAgfSk7XG4gICAgdGhpcy5zdGFydFN0YXRlID0gZGVjaWRlckxhbWJkYUludm9rZTtcbiAgICB0aGlzLmVuZFN0YXRlcyA9IFtkZWNpZGVyTGFtYmRhSW52b2tlXTtcbiAgfVxufVxuIl19