import * as iam from 'aws-cdk-lib/aws-iam';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as sfn from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
export interface TextractDPPOCDeciderProps {
    /** memory of Lambda function (may need to increase for larger documents) */
    readonly lambdaMemoryMB?: number;
    readonly lambdaTimeout?: number;
    readonly deciderFunction?: lambda.IFunction;
    readonly s3InputBucket?: string;
    /** prefix for the incoming document. Will be used to create role */
    readonly s3InputPrefix?: string;
    /** List of PolicyStatements to attach to the Lambda function for S3 GET and LIST. */
    readonly inputPolicyStatements?: [iam.PolicyStatement];
}
/**
 * This construct takes in a manifest definition or a plain JSON with a s3Path:
 *
 * example s3Path:
 * {"s3Path": "s3://bucketname/prefix/image.png"}
 *
 *
 * Then it generated the numberOfPages attribute and the mime on the context.
 * The mime types checked against the supported mime types for Textract and if fails, will raise an Exception failing the workflow.
 *
 * Example (Python)
 * ```python
   decider_task_id = tcdk.TextractPOCDecider(
        self,
        f"InsuranceDecider",
   )
  ```

 *
 */
export declare class TextractPOCDecider extends sfn.StateMachineFragment {
    readonly startState: sfn.State;
    readonly endStates: sfn.INextable[];
    readonly deciderFunction: lambda.IFunction;
    constructor(parent: Construct, id: string, props: TextractDPPOCDeciderProps);
}
