import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as iam from 'aws-cdk-lib/aws-iam';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as rds from 'aws-cdk-lib/aws-rds';
import * as sfn from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
export declare function validatePatternSupported(integrationPattern: sfn.IntegrationPattern, supportedPatterns: sfn.IntegrationPattern[]): void;
export declare function integrationResourceArn(service: string, api: string, integrationPattern?: sfn.IntegrationPattern): string;
export interface CSVToAuroraTaskProps extends sfn.TaskStateBaseProps {
    /** VPC to install the database into, optional if dbCluster is passed in */
    readonly vpc?: ec2.IVpc;
    readonly textractStateMachineTimeoutMinutes?: number;
    readonly lambdaLogLevel?: 'DEBUG' | 'INFO' | 'WARNING' | 'ERROR' | 'FATAL';
    /** Lambda Function Timeout in seconds, default 300 */
    readonly lambdaTimeout?: number;
    /** Memory allocated to Lambda function, default 512 */
    readonly lambdaMemory?: number;
    readonly csvToAuroraMaxRetries?: number;
    /**default is 1.1 */
    readonly csvToAuroraBackoffRate?: number;
    /**default is 1 */
    readonly csvToAuroraInterval?: number;
    /** enable CloudWatch Metrics and Dashboard
         * @default - false
         */
    readonly enableCloudWatchMetricsAndDashboard?: boolean;
    /** DBCluster to import into */
    readonly dbCluster?: rds.IServerlessCluster;
    /** lambdaSecurity Group for Cluster */
    readonly lambdaSecurityGroup?: ec2.ISecurityGroup;
    /** auroraSecurity Group for Cluster */
    readonly auroraSecurityGroup?: ec2.ISecurityGroup;
    /**
           * The JSON input for the execution, same as that of StartExecution.
           *
           * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
           *
           * @default - The state input (JSON path '$')
           */
    readonly input?: sfn.TaskInput;
    /**
            * The name of the execution, same as that of StartExecution.
            *
            * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
            *
            * @default - None
            */
    readonly name?: string;
    /**
            * Pass the execution ID from the context object to the execution input.
            * This allows the Step Functions UI to link child executions from parent executions, making it easier to trace execution flow across state machines.
            *
            * If you set this property to `true`, the `input` property must be an object (provided by `sfn.TaskInput.fromObject`) or omitted entirely.
            *
            * @see https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid
            *
            * @default - false
            */
    readonly associateWithParent?: boolean;
}
/**
 * CSVToAuroraTask is a demo construct to show import into a serverless Aurora DB.
 * At the moment it also creates the Aurora Serverless RDS DB, initializes a table structure the matches the output of the GenerateCSV construct.
 * The Step Functions flow expect a pointer to a CSV at "csv_output_location"."TextractOutputCSVPath" and uses that to execute a batch insert statement command.
 *
 * Example:
 * ```python
*  csv_to_aurora_task = tcdk.CSVToAuroraTask(
    self,
    "CsvToAurora",
    vpc=vpc,
    integration_pattern=sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
    lambda_log_level="DEBUG",
    timeout=Duration.hours(24),
    input=sfn.TaskInput.from_object({
      "Token":
      sfn.JsonPath.task_token,
      "ExecutionId":
      sfn.JsonPath.string_at('$$.Execution.Id'),
      "Payload":
      sfn.JsonPath.entire_payload
    }),
    result_path="$.textract_result")
  ```
 *
 * Input: "csv_output_location"."TextractOutputCSVPath"
 * Output: CSV in Aurora Serverless DB, table name 'textractcsvimport"
 */
export declare class CSVToAuroraTask extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    stateMachine: sfn.IStateMachine;
    version: string;
    csvToAuroraFunction: lambda.IFunction;
    csvToAuroraNumberRowsInsertedMetric?: cloudwatch.IMetric;
    dbCluster: rds.IServerlessCluster;
    auroraSecurityGroup: ec2.ISecurityGroup;
    lambdaSecurityGroup: ec2.ISecurityGroup;
    constructor(scope: Construct, id: string, props: CSVToAuroraTaskProps);
    /**
           * @internal
           */
    protected _renderTask(): any;
    /**
           * As StateMachineArn is extracted automatically from the state machine object included in the constructor,
           *
           * the scoped access policy should be generated accordingly.
           *
           * This means the action of StartExecution should be restricted on the given state machine, instead of being granted to all the resources (*).
           */
    private createScopedAccessPolicy;
}
