# python-sdf-timing

[![Build Status](https://travis-ci.com/SymbiFlow/python-sdf-timing.svg?branch=master)](https://travis-ci.com/SymbiFlow/python-sdf-timing)

Python library for working Standard Delay Format (SDF) Timing Annotation files.


# [Standard Delay Format](https://en.wikipedia.org/wiki/Standard_Delay_Format)

From Wikipedia;

> Standard Delay Format (SDF) is an IEEE standard for the representation and
> interpretation of timing data for use at any stage of an electronic design
> process. It finds wide applicability in design flows, and forms an efficient
> bridge between
> [Dynamic timing verification](https://en.wikipedia.org/wiki/Dynamic_timing_verification) and
> [Static timing analysis](https://en.wikipedia.org/wiki/Dynamic_timing_verification).
>
> ...
>
> It is an ASCII format that is represented in a tool and language independent
> way and includes path delays, timing constraint values, interconnect delays
> and high level technology parameters.
>
> It has usually two sections: one for interconnect delays and the other for
> cell delays.
>
> SDF format can be used for back-annotation as well as forward-annotation.

# Links

 * [python-sdf-timing GitHub Repository](https://github.com/SymbiFlow/python-sdf-timing)
 * [SDF Parser written in C++](https://github.com/kmurray/libsdcparse) -
 * [Verilog To Routing](https://docs.verilogtorouting.org/en/latest/tutorials/timing_simulation/#post-imp-sdf) -
   Verilog to Routing can generate an SDF file for doing post implementation timing simulation.

