import cdk = require('aws-cdk-lib');
import iam = require('aws-cdk-lib/aws-iam');
import kms = require('aws-cdk-lib/aws-kms');
import lambda = require('aws-cdk-lib/aws-lambda');
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export declare enum PublicKeyFormat {
    /**
     * @stability stable
     */
    OPENSSH = "OPENSSH",
    /**
     * @stability stable
     */
    PEM = "PEM"
}
/**
 * Definition of EC2 Key Pair.
 *
 * @stability stable
 */
export interface KeyPairProps extends cdk.ResourceProps {
    /**
     * Name of the Key Pair.
     *
     * In AWS Secrets Manager the key will be prefixed with `ec2-ssh-key/`.
     *
     * The name can be up to 255 characters long. Valid characters include _, -, a-z, A-Z, and 0-9.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The description for the key in AWS Secrets Manager.
     *
     * @default - ''
     * @stability stable
     */
    readonly description?: string;
    /**
     * The KMS key used to encrypt the Secrets Manager secrets with.
     *
     * This needs to be a key created in the same stack. You cannot use a key imported via ARN, because the keys access policy will need to be modified.
     *
     * @default - `alias/aws/secretsmanager`
     * @stability stable
     */
    readonly kms?: kms.Key;
    /**
     * The KMS key to use to encrypt the private key with.
     *
     * This needs to be a key created in the same stack. You cannot use a key imported via ARN, because the keys access policy will need to be modified.
     *
     * If no value is provided, the property `kms` will be used instead.
     *
     * @default - `this.kms`
     * @stability stable
     */
    readonly kmsPrivateKey?: kms.Key;
    /**
     * The KMS key to use to encrypt the public key with.
     *
     * This needs to be a key created in the same stack. You cannot use a key imported via ARN, because the keys access policy will need to be modified.
     *
     * If no value is provided, the property `kms` will be used instead.
     *
     * @default - `this.kms`
     * @stability stable
     */
    readonly kmsPublicKey?: kms.Key;
    /**
     * Store the public key as a secret.
     *
     * @default - false
     * @stability stable
     */
    readonly storePublicKey?: boolean;
    /**
     * Expose the public key as property `publicKeyValue`.
     *
     * @default - false
     * @stability stable
     */
    readonly exposePublicKey?: boolean;
    /**
     * Format for public key.
     *
     * Relevant only if the public key is stored and/or exposed.
     *
     * @default - OPENSSH
     * @stability stable
     */
    readonly publicKeyFormat?: PublicKeyFormat;
    /**
     * When the resource is destroyed, after how many days the private and public key in the AWS Secrets Manager should be deleted.
     *
     * Valid values are 0 and 7 to 30
     *
     * @default 0
     * @stability stable
     */
    readonly removeKeySecretsAfterDays?: number;
    /**
     * Prefix for the secret in AWS Secrets Manager.
     *
     * @default `ec2-ssh-key/`
     * @stability stable
     */
    readonly secretPrefix?: string;
    /**
     * A prefix for all resource names.
     *
     * By default all resources are prefixed with the stack name to avoid collisions with other stacks. This might cause problems when you work with long stack names and can be overridden through this parameter.
     *
     * @default Name of the stack
     * @stability stable
     */
    readonly resourcePrefix?: string;
}
/**
 * An EC2 Key Pair.
 *
 * @stability stable
 */
export declare class KeyPair extends Construct implements cdk.ITaggable {
    /**
     * The lambda function that is created.
     *
     * @stability stable
     */
    readonly lambda: lambda.IFunction;
    /**
     * ARN of the private key in AWS Secrets Manager.
     *
     * @stability stable
     */
    readonly privateKeyArn: string;
    /**
     * ARN of the public key in AWS Secrets Manager.
     *
     * @stability stable
     */
    readonly publicKeyArn: string;
    /**
     * The public key.
     *
     * Only filled, when `exposePublicKey = true`
     *
     * @stability stable
     */
    readonly publicKeyValue: string;
    /**
     * Name of the Key Pair.
     *
     * @stability stable
     */
    readonly keyPairName: string;
    /**
     * ID of the Key Pair.
     *
     * @stability stable
     */
    readonly keyPairID: string;
    /**
     * Resource tags.
     *
     * @stability stable
     */
    readonly tags: cdk.TagManager;
    /**
     * @stability stable
     */
    readonly prefix: string;
    /**
     * Defines a new EC2 Key Pair.
     *
     * The private key will be stored in AWS Secrets Manager
     *
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: KeyPairProps);
    private ensureLambda;
    /**
     * Grants read access to the private key in AWS Secrets Manager.
     *
     * @stability stable
     */
    grantReadOnPrivateKey(grantee: iam.IGrantable): cdk.aws_iam.Grant;
    /**
     * Grants read access to the public key in AWS Secrets Manager.
     *
     * @stability stable
     */
    grantReadOnPublicKey(grantee: iam.IGrantable): cdk.aws_iam.Grant;
    private grantRead;
}
