from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.video.v1.room.room_participant.room_participant_published_track import PublishedTrackList as PublishedTrackList
from twilio.rest.video.v1.room.room_participant.room_participant_subscribe_rule import SubscribeRulesList as SubscribeRulesList
from twilio.rest.video.v1.room.room_participant.room_participant_subscribed_track import SubscribedTrackList as SubscribedTrackList
from typing import Any, Optional

class ParticipantList(ListResource):
    def __init__(self, version: Any, room_sid: Any) -> None: ...
    def stream(self, status: Any = ..., identity: Any = ..., date_created_after: Any = ..., date_created_before: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, status: Any = ..., identity: Any = ..., date_created_after: Any = ..., date_created_before: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, status: Any = ..., identity: Any = ..., date_created_after: Any = ..., date_created_before: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class ParticipantPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class ParticipantContext(InstanceContext):
    def __init__(self, version: Any, room_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, status: Any = ...): ...
    @property
    def published_tracks(self): ...
    @property
    def subscribed_tracks(self): ...
    @property
    def subscribe_rules(self): ...

class ParticipantInstance(InstanceResource):
    class Status:
        CONNECTED: str = ...
        DISCONNECTED: str = ...
    def __init__(self, version: Any, payload: Any, room_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def room_sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def status(self): ...
    @property
    def identity(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def start_time(self): ...
    @property
    def end_time(self): ...
    @property
    def duration(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def update(self, status: Any = ...): ...
    @property
    def published_tracks(self): ...
    @property
    def subscribed_tracks(self): ...
    @property
    def subscribe_rules(self): ...
