from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.video.v1.room.recording import RoomRecordingList as RoomRecordingList
from twilio.rest.video.v1.room.room_participant import ParticipantList as ParticipantList
from twilio.rest.video.v1.room.room_recording_rule import RecordingRulesList as RecordingRulesList
from typing import Any, Optional

class RoomList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def create(self, enable_turn: Any = ..., type: Any = ..., unique_name: Any = ..., status_callback: Any = ..., status_callback_method: Any = ..., max_participants: Any = ..., record_participants_on_connect: Any = ..., video_codecs: Any = ..., media_region: Any = ...): ...
    def stream(self, status: Any = ..., unique_name: Any = ..., date_created_after: Any = ..., date_created_before: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, status: Any = ..., unique_name: Any = ..., date_created_after: Any = ..., date_created_before: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, status: Any = ..., unique_name: Any = ..., date_created_after: Any = ..., date_created_before: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class RoomPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class RoomContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, status: Any): ...
    @property
    def recordings(self): ...
    @property
    def participants(self): ...
    @property
    def recording_rules(self): ...

class RoomInstance(InstanceResource):
    class RoomStatus:
        IN_PROGRESS: str = ...
        COMPLETED: str = ...
        FAILED: str = ...
    class RoomType:
        GO: str = ...
        PEER_TO_PEER: str = ...
        GROUP: str = ...
        GROUP_SMALL: str = ...
    class VideoCodec:
        VP8: str = ...
        H264: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def status(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def account_sid(self): ...
    @property
    def enable_turn(self): ...
    @property
    def unique_name(self): ...
    @property
    def status_callback(self): ...
    @property
    def status_callback_method(self): ...
    @property
    def end_time(self): ...
    @property
    def duration(self): ...
    @property
    def type(self): ...
    @property
    def max_participants(self): ...
    @property
    def record_participants_on_connect(self): ...
    @property
    def video_codecs(self): ...
    @property
    def media_region(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def update(self, status: Any): ...
    @property
    def recordings(self): ...
    @property
    def participants(self): ...
    @property
    def recording_rules(self): ...
