from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class FactorList(ListResource):
    def __init__(self, version: Any, service_sid: Any, identity: Any) -> None: ...
    def create(self, friendly_name: Any, factor_type: Any, binding_alg: Any = ..., binding_public_key: Any = ..., config_app_id: Any = ..., config_notification_platform: Any = ..., config_notification_token: Any = ..., config_sdk_version: Any = ...): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class FactorPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class FactorContext(InstanceContext):
    def __init__(self, version: Any, service_sid: Any, identity: Any, sid: Any) -> None: ...
    def delete(self): ...
    def fetch(self): ...
    def update(self, auth_payload: Any = ..., friendly_name: Any = ..., config_notification_token: Any = ..., config_sdk_version: Any = ...): ...

class FactorInstance(InstanceResource):
    class FactorStatuses:
        UNVERIFIED: str = ...
        VERIFIED: str = ...
    class FactorTypes:
        PUSH: str = ...
    class NotificationPlatforms:
        APN: str = ...
        FCM: str = ...
    def __init__(self, version: Any, payload: Any, service_sid: Any, identity: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def service_sid(self): ...
    @property
    def entity_sid(self): ...
    @property
    def identity(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def friendly_name(self): ...
    @property
    def status(self): ...
    @property
    def factor_type(self): ...
    @property
    def config(self): ...
    @property
    def url(self): ...
    def delete(self): ...
    def fetch(self): ...
    def update(self, auth_payload: Any = ..., friendly_name: Any = ..., config_notification_token: Any = ..., config_sdk_version: Any = ...): ...
