from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class EventList(ListResource):
    def __init__(self, version: Any, workspace_sid: Any) -> None: ...
    def stream(self, end_date: Any = ..., event_type: Any = ..., minutes: Any = ..., reservation_sid: Any = ..., start_date: Any = ..., task_queue_sid: Any = ..., task_sid: Any = ..., worker_sid: Any = ..., workflow_sid: Any = ..., task_channel: Any = ..., sid: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, end_date: Any = ..., event_type: Any = ..., minutes: Any = ..., reservation_sid: Any = ..., start_date: Any = ..., task_queue_sid: Any = ..., task_sid: Any = ..., worker_sid: Any = ..., workflow_sid: Any = ..., task_channel: Any = ..., sid: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, end_date: Any = ..., event_type: Any = ..., minutes: Any = ..., reservation_sid: Any = ..., start_date: Any = ..., task_queue_sid: Any = ..., task_sid: Any = ..., worker_sid: Any = ..., workflow_sid: Any = ..., task_channel: Any = ..., sid: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class EventPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class EventContext(InstanceContext):
    def __init__(self, version: Any, workspace_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...

class EventInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, workspace_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def actor_sid(self): ...
    @property
    def actor_type(self): ...
    @property
    def actor_url(self): ...
    @property
    def description(self): ...
    @property
    def event_data(self): ...
    @property
    def event_date(self): ...
    @property
    def event_date_ms(self): ...
    @property
    def event_type(self): ...
    @property
    def resource_sid(self): ...
    @property
    def resource_type(self): ...
    @property
    def resource_url(self): ...
    @property
    def sid(self): ...
    @property
    def source(self): ...
    @property
    def source_ip_address(self): ...
    @property
    def url(self): ...
    @property
    def workspace_sid(self): ...
    def fetch(self): ...
