from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.taskrouter.v1.workspace.activity import ActivityList as ActivityList
from twilio.rest.taskrouter.v1.workspace.event import EventList as EventList
from twilio.rest.taskrouter.v1.workspace.task import TaskList as TaskList
from twilio.rest.taskrouter.v1.workspace.task_channel import TaskChannelList as TaskChannelList
from twilio.rest.taskrouter.v1.workspace.task_queue import TaskQueueList as TaskQueueList
from twilio.rest.taskrouter.v1.workspace.worker import WorkerList as WorkerList
from twilio.rest.taskrouter.v1.workspace.workflow import WorkflowList as WorkflowList
from twilio.rest.taskrouter.v1.workspace.workspace_cumulative_statistics import WorkspaceCumulativeStatisticsList as WorkspaceCumulativeStatisticsList
from twilio.rest.taskrouter.v1.workspace.workspace_real_time_statistics import WorkspaceRealTimeStatisticsList as WorkspaceRealTimeStatisticsList
from twilio.rest.taskrouter.v1.workspace.workspace_statistics import WorkspaceStatisticsList as WorkspaceStatisticsList
from typing import Any, Optional

class WorkspaceList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def stream(self, friendly_name: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, friendly_name: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, friendly_name: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, friendly_name: Any, event_callback_url: Any = ..., events_filter: Any = ..., multi_task_enabled: Any = ..., template: Any = ..., prioritize_queue_order: Any = ...): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class WorkspacePage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class WorkspaceContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, default_activity_sid: Any = ..., event_callback_url: Any = ..., events_filter: Any = ..., friendly_name: Any = ..., multi_task_enabled: Any = ..., timeout_activity_sid: Any = ..., prioritize_queue_order: Any = ...): ...
    def delete(self): ...
    @property
    def activities(self): ...
    @property
    def events(self): ...
    @property
    def tasks(self): ...
    @property
    def task_queues(self): ...
    @property
    def workers(self): ...
    @property
    def workflows(self): ...
    @property
    def statistics(self): ...
    @property
    def real_time_statistics(self): ...
    @property
    def cumulative_statistics(self): ...
    @property
    def task_channels(self): ...

class WorkspaceInstance(InstanceResource):
    class QueueOrder:
        FIFO: str = ...
        LIFO: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def default_activity_name(self): ...
    @property
    def default_activity_sid(self): ...
    @property
    def event_callback_url(self): ...
    @property
    def events_filter(self): ...
    @property
    def friendly_name(self): ...
    @property
    def multi_task_enabled(self): ...
    @property
    def sid(self): ...
    @property
    def timeout_activity_name(self): ...
    @property
    def timeout_activity_sid(self): ...
    @property
    def prioritize_queue_order(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def update(self, default_activity_sid: Any = ..., event_callback_url: Any = ..., events_filter: Any = ..., friendly_name: Any = ..., multi_task_enabled: Any = ..., timeout_activity_sid: Any = ..., prioritize_queue_order: Any = ...): ...
    def delete(self): ...
    @property
    def activities(self): ...
    @property
    def events(self): ...
    @property
    def tasks(self): ...
    @property
    def task_queues(self): ...
    @property
    def workers(self): ...
    @property
    def workflows(self): ...
    @property
    def statistics(self): ...
    @property
    def real_time_statistics(self): ...
    @property
    def cumulative_statistics(self): ...
    @property
    def task_channels(self): ...
