from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class SimList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def stream(self, status: Any = ..., fleet: Any = ..., iccid: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, status: Any = ..., fleet: Any = ..., iccid: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, status: Any = ..., fleet: Any = ..., iccid: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class SimPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class SimContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, unique_name: Any = ..., status: Any = ..., fleet: Any = ..., callback_url: Any = ..., callback_method: Any = ..., account_sid: Any = ...): ...

class SimInstance(InstanceResource):
    class Status:
        NEW: str = ...
        READY: str = ...
        ACTIVE: str = ...
        INACTIVE: str = ...
        SCHEDULED: str = ...
    class StatusUpdate:
        READY: str = ...
        ACTIVE: str = ...
        INACTIVE: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def unique_name(self): ...
    @property
    def account_sid(self): ...
    @property
    def iccid(self): ...
    @property
    def status(self): ...
    @property
    def fleet_sid(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def url(self): ...
    def fetch(self): ...
    def update(self, unique_name: Any = ..., status: Any = ..., fleet: Any = ..., callback_url: Any = ..., callback_method: Any = ..., account_sid: Any = ...): ...
