from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.studio.v2.flow.execution.execution_context import ExecutionContextList as ExecutionContextList
from twilio.rest.studio.v2.flow.execution.execution_step import ExecutionStepList as ExecutionStepList
from typing import Any, Optional

class ExecutionList(ListResource):
    def __init__(self, version: Any, flow_sid: Any) -> None: ...
    def stream(self, date_created_from: Any = ..., date_created_to: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, date_created_from: Any = ..., date_created_to: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, date_created_from: Any = ..., date_created_to: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, to: Any, from_: Any, parameters: Any = ...): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class ExecutionPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class ExecutionContext(InstanceContext):
    def __init__(self, version: Any, flow_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, status: Any): ...
    @property
    def steps(self): ...
    @property
    def execution_context(self): ...

class ExecutionInstance(InstanceResource):
    class Status:
        ACTIVE: str = ...
        ENDED: str = ...
    def __init__(self, version: Any, payload: Any, flow_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def flow_sid(self): ...
    @property
    def contact_channel_address(self): ...
    @property
    def context(self): ...
    @property
    def status(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, status: Any): ...
    @property
    def steps(self): ...
    @property
    def execution_context(self): ...
