from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class LogList(ListResource):
    def __init__(self, version: Any, service_sid: Any, environment_sid: Any) -> None: ...
    def stream(self, function_sid: Any = ..., start_date: Any = ..., end_date: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, function_sid: Any = ..., start_date: Any = ..., end_date: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, function_sid: Any = ..., start_date: Any = ..., end_date: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class LogPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class LogContext(InstanceContext):
    def __init__(self, version: Any, service_sid: Any, environment_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...

class LogInstance(InstanceResource):
    class Level:
        INFO: str = ...
        WARN: str = ...
        ERROR: str = ...
    def __init__(self, version: Any, payload: Any, service_sid: Any, environment_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def service_sid(self): ...
    @property
    def environment_sid(self): ...
    @property
    def build_sid(self): ...
    @property
    def deployment_sid(self): ...
    @property
    def function_sid(self): ...
    @property
    def request_sid(self): ...
    @property
    def level(self): ...
    @property
    def message(self): ...
    @property
    def date_created(self): ...
    @property
    def url(self): ...
    def fetch(self): ...
