from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.proxy.v1.service.phone_number import PhoneNumberList as PhoneNumberList
from twilio.rest.proxy.v1.service.session import SessionList as SessionList
from twilio.rest.proxy.v1.service.short_code import ShortCodeList as ShortCodeList
from typing import Any, Optional

class ServiceList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, unique_name: Any, default_ttl: Any = ..., callback_url: Any = ..., geo_match_level: Any = ..., number_selection_behavior: Any = ..., intercept_callback_url: Any = ..., out_of_session_callback_url: Any = ..., chat_instance_sid: Any = ...): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class ServicePage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class ServiceContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, unique_name: Any = ..., default_ttl: Any = ..., callback_url: Any = ..., geo_match_level: Any = ..., number_selection_behavior: Any = ..., intercept_callback_url: Any = ..., out_of_session_callback_url: Any = ..., chat_instance_sid: Any = ...): ...
    @property
    def sessions(self): ...
    @property
    def phone_numbers(self): ...
    @property
    def short_codes(self): ...

class ServiceInstance(InstanceResource):
    class GeoMatchLevel:
        AREA_CODE: str = ...
        OVERLAY: str = ...
        RADIUS: str = ...
        COUNTRY: str = ...
    class NumberSelectionBehavior:
        AVOID_STICKY: str = ...
        PREFER_STICKY: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def unique_name(self): ...
    @property
    def account_sid(self): ...
    @property
    def chat_instance_sid(self): ...
    @property
    def callback_url(self): ...
    @property
    def default_ttl(self): ...
    @property
    def number_selection_behavior(self): ...
    @property
    def geo_match_level(self): ...
    @property
    def intercept_callback_url(self): ...
    @property
    def out_of_session_callback_url(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, unique_name: Any = ..., default_ttl: Any = ..., callback_url: Any = ..., geo_match_level: Any = ..., number_selection_behavior: Any = ..., intercept_callback_url: Any = ..., out_of_session_callback_url: Any = ..., chat_instance_sid: Any = ...): ...
    @property
    def sessions(self): ...
    @property
    def phone_numbers(self): ...
    @property
    def short_codes(self): ...
